/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.impl;

import com.github.benmanes.caffeine.cache.CacheWriter;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.AbstractIterator;
import org.infinispan.commons.util.ByRef;
import org.infinispan.commons.util.FilterSpliterator;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.container.impl.PeekableTouchableMap;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.eviction.impl.PassivationManager;
import org.infinispan.expiration.impl.InternalExpirationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.L1Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.concurrent.DataOperationOrderer;
import org.infinispan.util.concurrent.WithinThreadExecutor;

@Scope(value=Scopes.NAMED_CACHE)
public abstract class AbstractInternalDataContainer<K, V>
implements InternalDataContainer<K, V> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    @Inject
    protected TimeService timeService;
    @Inject
    protected EvictionManager<K, V> evictionManager;
    @Inject
    protected InternalExpirationManager<K, V> expirationManager;
    @Inject
    protected InternalEntryFactory entryFactory;
    @Inject
    protected ComponentRef<PassivationManager> passivator;
    @Inject
    protected Configuration configuration;
    @Inject
    protected KeyPartitioner keyPartitioner;
    @Inject
    protected DataOperationOrderer orderer;
    protected final List<Consumer<Iterable<InternalCacheEntry<K, V>>>> listeners = new CopyOnWriteArrayList<Consumer<Iterable<InternalCacheEntry<K, V>>>>();

    protected abstract PeekableTouchableMap<K, V> getMapForSegment(int var1);

    protected abstract int getSegmentForKey(Object var1);

    @Override
    public InternalCacheEntry<K, V> get(int segment, Object k) {
        InternalCacheEntry e;
        PeekableTouchableMap<K, V> map = this.getMapForSegment(segment);
        InternalCacheEntry internalCacheEntry = e = map != null ? (InternalCacheEntry)map.get(k) : null;
        if (e != null && e.canExpire()) {
            long currentTimeMillis = this.timeService.wallClockTime();
            if (e.isExpired(currentTimeMillis) && this.expirationManager.entryExpiredInMemory(e, currentTimeMillis, false).join() == Boolean.TRUE) {
                e = null;
            } else {
                e.touch(currentTimeMillis);
            }
        }
        return e;
    }

    @Override
    public InternalCacheEntry<K, V> get(Object k) {
        return this.get(this.getSegmentForKey(k), k);
    }

    @Override
    public InternalCacheEntry<K, V> peek(int segment, Object k) {
        PeekableTouchableMap<K, V> entries = this.getMapForSegment(segment);
        if (entries != null) {
            return entries.peek(k);
        }
        return null;
    }

    @Override
    public InternalCacheEntry<K, V> peek(Object k) {
        return this.peek(this.getSegmentForKey(k), k);
    }

    @Override
    public boolean touch(int segment, Object k, long currentTimeMillis) {
        PeekableTouchableMap<K, V> entries = this.getMapForSegment(segment);
        if (entries != null) {
            return entries.touchKey(k, currentTimeMillis);
        }
        return false;
    }

    @Override
    public void put(int segment, K k, V v, Metadata metadata, PrivateMetadata internalMetadata, long createdTimestamp, long lastUseTimestamp) {
        PeekableTouchableMap<K, InternalCacheEntry<K, V>> entries = this.getMapForSegment(segment);
        if (entries != null) {
            boolean l1Entry = false;
            if (metadata instanceof L1Metadata) {
                metadata = ((L1Metadata)metadata).metadata();
                l1Entry = true;
            }
            InternalCacheEntry e = (InternalCacheEntry)entries.get(k);
            if (log.isTraceEnabled()) {
                log.tracef("Creating new ICE for writing. Existing=%s, metadata=%s, new value=%s", (Object)e, (Object)metadata, (Object)Util.toStr(v));
            }
            InternalCacheEntry<K, V> copy = l1Entry ? this.entryFactory.createL1(k, v, metadata) : (e != null ? this.entryFactory.update(e, v, metadata) : (createdTimestamp == -1L && lastUseTimestamp == -1L ? this.entryFactory.create(k, v, metadata) : this.entryFactory.create(k, v, metadata, createdTimestamp, metadata.lifespan(), lastUseTimestamp, metadata.maxIdle())));
            copy.setInternalMetadata(internalMetadata);
            if (log.isTraceEnabled()) {
                log.tracef("Store %s=%s in container", k, copy);
            }
            entries.put(k, copy);
        } else {
            log.tracef("Insertion attempted for key: %s but there was no map created for it at segment: %d", k, (Object)segment);
        }
    }

    @Override
    public void put(K k, V v, Metadata metadata) {
        this.put(this.getSegmentForKey(k), k, v, metadata, null, -1L, -1L);
    }

    @Override
    public boolean containsKey(int segment, Object k) {
        long currentTimeMillis;
        InternalCacheEntry<K, V> ice = this.peek(segment, k);
        if (ice != null && ice.canExpire() && ice.isExpired(currentTimeMillis = this.timeService.wallClockTime()) && this.expirationManager.entryExpiredInMemory(ice, currentTimeMillis, false).join() == Boolean.TRUE) {
            ice = null;
        }
        return ice != null;
    }

    @Override
    public boolean containsKey(Object k) {
        return this.containsKey(this.getSegmentForKey(k), k);
    }

    @Override
    public InternalCacheEntry<K, V> remove(int segment, Object k) {
        PeekableTouchableMap<K, V> entries = this.getMapForSegment(segment);
        if (entries != null) {
            InternalCacheEntry e = (InternalCacheEntry)entries.remove(k);
            if (log.isTraceEnabled()) {
                log.tracef("Removed %s=%s from container", k, (Object)e);
            }
            return e == null || e.canExpire() && e.isExpired(this.timeService.wallClockTime()) ? null : e;
        }
        return null;
    }

    @Override
    public InternalCacheEntry<K, V> remove(Object k) {
        return this.remove(this.getSegmentForKey(k), k);
    }

    @Override
    public CompletionStage<Void> evict(int segment, K key) {
        PeekableTouchableMap<Object, InternalCacheEntry> entries = this.getMapForSegment(segment);
        if (entries == null) {
            return CompletableFutures.completedNull();
        }
        ByRef evictionStageRef = new ByRef(CompletableFutures.completedNull());
        entries.computeIfPresent(key, (o, entry) -> {
            evictionStageRef.set(AbstractInternalDataContainer.handleEviction(entry, null, this.passivator.running(), null, this, null));
            this.computeEntryRemoved((K)o, (InternalCacheEntry<K, V>)entry);
            return null;
        });
        return (CompletionStage)evictionStageRef.get();
    }

    @Override
    public void evict(K key) {
        CompletionStages.join(this.evict(this.getSegmentForKey(key), key));
    }

    @Override
    public InternalCacheEntry<K, V> compute(int segment, K key, DataContainer.ComputeAction<K, V> action) {
        PeekableTouchableMap<Object, InternalCacheEntry> entries = this.getMapForSegment(segment);
        return entries != null ? entries.compute(key, (? super K k, ? super V oldEntry) -> {
            InternalCacheEntry newEntry = action.compute((K)k, (InternalCacheEntry<K, V>)oldEntry, this.entryFactory);
            if (newEntry == oldEntry) {
                return oldEntry;
            }
            if (newEntry == null) {
                this.computeEntryRemoved((K)k, (InternalCacheEntry<K, V>)oldEntry);
                return null;
            }
            this.computeEntryWritten(k, newEntry);
            if (log.isTraceEnabled()) {
                log.tracef("Store %s in container", newEntry);
            }
            return newEntry;
        }) : null;
    }

    @Override
    public InternalCacheEntry<K, V> compute(K key, DataContainer.ComputeAction<K, V> action) {
        return this.compute(this.getSegmentForKey(key), key, action);
    }

    @Override
    public void clear(IntSet segments) {
        segments.forEach(segment -> {
            PeekableTouchableMap<K, V> map = this.getMapForSegment(segment);
            if (map != null) {
                map.clear();
            }
        });
    }

    protected void computeEntryWritten(K key, InternalCacheEntry<K, V> value) {
    }

    protected void computeEntryRemoved(K key, InternalCacheEntry<K, V> value) {
    }

    @Override
    public void addRemovalListener(Consumer<Iterable<InternalCacheEntry<K, V>>> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeRemovalListener(Object listener) {
        this.listeners.remove(listener);
    }

    protected Caffeine<K, InternalCacheEntry<K, V>> applyListener(Caffeine<K, InternalCacheEntry<K, V>> caffeine, final DefaultEvictionListener listener, final CacheWriter<K, InternalCacheEntry<K, V>> additionalWriter) {
        return caffeine.executor((Executor)new WithinThreadExecutor()).writer(new CacheWriter<K, InternalCacheEntry<K, V>>(){

            public void write(K key, InternalCacheEntry<K, V> value) {
                if (additionalWriter != null) {
                    additionalWriter.write(key, value);
                }
            }

            public void delete(K key, InternalCacheEntry<K, V> value, RemovalCause cause) {
                if (additionalWriter != null) {
                    additionalWriter.delete(key, value, cause);
                }
                if (cause == RemovalCause.SIZE) {
                    listener.onEntryChosenForEviction(key, value);
                }
            }
        }).removalListener((RemovalListener)listener);
    }

    static <K, V> Caffeine<K, V> caffeineBuilder() {
        return Caffeine.newBuilder();
    }

    public static <K, V> CompletionStage<Void> handleEviction(InternalCacheEntry<K, V> entry, DataOperationOrderer orderer, PassivationManager passivator, EvictionManager<K, V> evictionManager, DataContainer<K, V> dataContainer, CompletionStage<Void> selfDelay) {
        CompletionStage<DataOperationOrderer.Operation> ordererStage;
        Object key = entry.getKey();
        CompletableFuture<DataOperationOrderer.Operation> future = new CompletableFuture<DataOperationOrderer.Operation>();
        CompletionStage<DataOperationOrderer.Operation> completionStage = ordererStage = orderer != null ? orderer.orderOn(key, future) : null;
        if (ordererStage != null) {
            if (log.isTraceEnabled()) {
                log.tracef("Encountered concurrent operation during eviction of %s", key);
            }
            return ordererStage.thenCompose(operation -> {
                if (log.isTraceEnabled()) {
                    log.tracef("Concurrent operation during eviction of %s was %s", key, (Object)operation);
                }
                switch (operation) {
                    case REMOVE: {
                        return AbstractInternalDataContainer.skipPassivation(orderer, key, future, operation);
                    }
                    case WRITE: {
                        if (!dataContainer.containsKey(key)) break;
                        if (selfDelay != null) {
                            if (log.isTraceEnabled()) {
                                log.tracef("Delaying check for %s verify if passivation should occur as there was a concurrent write", key);
                            }
                            return selfDelay.thenCompose(ignore -> {
                                if (dataContainer.containsKey(key)) {
                                    return AbstractInternalDataContainer.skipPassivation(orderer, key, future, operation);
                                }
                                return AbstractInternalDataContainer.handleNotificationAndOrderer(key, entry, passivator.passivateAsync(entry), orderer, evictionManager, future);
                            });
                        }
                        return AbstractInternalDataContainer.skipPassivation(orderer, key, future, operation);
                    }
                }
                CompletionStage<Void> passivatedStage = passivator.passivateAsync(entry);
                return AbstractInternalDataContainer.handleNotificationAndOrderer(key, entry, passivatedStage, orderer, evictionManager, future);
            });
        }
        return AbstractInternalDataContainer.handleNotificationAndOrderer(key, entry, passivator.passivateAsync(entry), orderer, evictionManager, future);
    }

    private static CompletionStage<Void> skipPassivation(DataOperationOrderer orderer, Object key, CompletableFuture<DataOperationOrderer.Operation> future, DataOperationOrderer.Operation op) {
        if (log.isTraceEnabled()) {
            log.tracef("Skipping passivation for key %s due to %s", key, (Object)op);
        }
        orderer.completeOperation(key, future, DataOperationOrderer.Operation.READ);
        return CompletableFutures.completedNull();
    }

    private static <K, V> CompletionStage<Void> handleNotificationAndOrderer(K key, InternalCacheEntry<K, V> value, CompletionStage<Void> stage, DataOperationOrderer orderer, EvictionManager<K, V> evictionManager, CompletableFuture<DataOperationOrderer.Operation> future) {
        if (evictionManager != null) {
            stage = stage.thenCompose(ignore -> evictionManager.onEntryEviction(Collections.singletonMap(key, value)));
        }
        if (orderer != null) {
            return stage.whenComplete((ignore, ignoreT) -> orderer.completeOperation(key, future, DataOperationOrderer.Operation.READ));
        }
        return stage;
    }

    protected Spliterator<InternalCacheEntry<K, V>> filterExpiredEntries(Spliterator<InternalCacheEntry<K, V>> spliterator) {
        long accessTime = this.timeService.wallClockTime();
        return new FilterSpliterator(spliterator, this.expiredIterationPredicate(accessTime));
    }

    protected Predicate<InternalCacheEntry<K, V>> expiredIterationPredicate(long accessTime) {
        return e -> !e.canExpire() || !e.isExpired(accessTime) || !this.expirationManager.entryExpiredInMemoryFromIteration((InternalCacheEntry<K, V>)e, accessTime);
    }

    final class DefaultEvictionListener
    implements RemovalListener<K, InternalCacheEntry<K, V>> {
        Map<Object, CompletableFuture<Void>> ensureEvictionDone = new ConcurrentHashMap<Object, CompletableFuture<Void>>();

        DefaultEvictionListener() {
        }

        void onEntryChosenForEviction(K key, InternalCacheEntry<K, V> value) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            this.ensureEvictionDone.put(key, future);
            AbstractInternalDataContainer.handleEviction(value, AbstractInternalDataContainer.this.orderer, AbstractInternalDataContainer.this.passivator.running(), AbstractInternalDataContainer.this.evictionManager, AbstractInternalDataContainer.this, future);
        }

        public void onRemoval(K key, InternalCacheEntry<K, V> value, RemovalCause cause) {
            CompletableFuture<Void> future;
            if (cause == RemovalCause.SIZE && (future = this.ensureEvictionDone.remove(key)) != null) {
                future.complete(null);
            }
        }
    }

    protected class EntryIterator
    extends AbstractIterator<InternalCacheEntry<K, V>> {
        private final Iterator<InternalCacheEntry<K, V>> it;

        public EntryIterator(Iterator<InternalCacheEntry<K, V>> it) {
            this.it = it;
        }

        protected InternalCacheEntry<K, V> getNext() {
            boolean initializedTime = false;
            long now = 0L;
            while (this.it.hasNext()) {
                InternalCacheEntry entry = this.it.next();
                if (!entry.canExpire()) {
                    if (log.isTraceEnabled()) {
                        log.tracef("Return next entry %s", entry);
                    }
                    return entry;
                }
                if (!initializedTime) {
                    now = AbstractInternalDataContainer.this.timeService.wallClockTime();
                    initializedTime = true;
                }
                if (!entry.isExpired(now) || !AbstractInternalDataContainer.this.expirationManager.entryExpiredInMemoryFromIteration(entry, now)) {
                    if (log.isTraceEnabled()) {
                        log.tracef("Return next entry %s", entry);
                    }
                    return entry;
                }
                if (!log.isTraceEnabled()) continue;
                log.tracef("%s is expired", entry);
            }
            if (log.isTraceEnabled()) {
                log.tracef("Return next null", new Object[0]);
            }
            return null;
        }
    }
}

