/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableEmitter;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.nio.channels.FileChannel;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.ByRef;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.Util;
import org.infinispan.persistence.sifs.EntryHeader;
import org.infinispan.persistence.sifs.EntryInfo;
import org.infinispan.persistence.sifs.EntryPosition;
import org.infinispan.persistence.sifs.EntryRecord;
import org.infinispan.persistence.sifs.FileProvider;
import org.infinispan.persistence.sifs.Index;
import org.infinispan.persistence.sifs.IndexRequest;
import org.infinispan.persistence.sifs.Log;
import org.infinispan.reactive.FlowableCreate;
import org.infinispan.util.logging.LogFactory;

class IndexNode {
    private static final Log log = LogFactory.getLog(IndexNode.class, Log.class);
    private static final byte HAS_LEAVES = 1;
    private static final byte HAS_NODES = 2;
    private static final int INNER_NODE_HEADER_SIZE = 5;
    private static final int INNER_NODE_REFERENCE_SIZE = 10;
    private static final int LEAF_NODE_REFERENCE_SIZE = 14;
    public static final int RESERVED_SPACE = 5 + 2 * Math.max(10, 14);
    private final Index.Segment segment;
    private byte[] prefix;
    private byte[][] keyParts;
    private InnerNode[] innerNodes;
    private LeafNode[] leafNodes = LeafNode.EMPTY_ARRAY;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private long offset = -1L;
    private short keyPartsLength = (short)-1;
    private short contentLength = (short)-1;
    private short totalLength = (short)-1;
    private short occupiedSpace;
    public static final Comparator<byte[]> REVERSED_COMPARE_TO = ((Comparator)IndexNode::compare).reversed();
    static final OverwriteHook NOOP_HOOK = (request, cacheSegment, overwritten, prevFile, prevOffset) -> {};

    IndexNode(Index.Segment segment, long offset, short occupiedSpace) throws IOException {
        int i;
        this.segment = segment;
        this.offset = offset;
        this.occupiedSpace = occupiedSpace;
        java.nio.ByteBuffer buffer = IndexNode.loadBuffer(segment.getIndexFile(), offset, occupiedSpace);
        this.prefix = new byte[buffer.getShort()];
        buffer.get(this.prefix);
        byte flags = buffer.get();
        int numKeyParts = buffer.getShort();
        int afterHeaderPos = buffer.position();
        this.keyParts = new byte[numKeyParts][];
        for (i = 0; i < numKeyParts; ++i) {
            this.keyParts[i] = new byte[buffer.getShort()];
            buffer.get(this.keyParts[i]);
        }
        assert (buffer.position() - afterHeaderPos < Short.MAX_VALUE);
        this.keyPartsLength = (short)(buffer.position() - afterHeaderPos);
        if ((flags & 1) != 0) {
            this.leafNodes = new LeafNode[numKeyParts + 1];
            for (i = 0; i < numKeyParts + 1; ++i) {
                this.leafNodes[i] = new LeafNode(buffer.getInt(), buffer.getInt(), buffer.getShort(), buffer.getInt());
            }
        } else if ((flags & 2) != 0) {
            this.innerNodes = new InnerNode[numKeyParts + 1];
            for (i = 0; i < numKeyParts + 1; ++i) {
                this.innerNodes[i] = new InnerNode(buffer.getLong(), buffer.getShort());
            }
        }
        assert (buffer.position() - afterHeaderPos < Short.MAX_VALUE);
        this.contentLength = (short)(buffer.position() - afterHeaderPos);
        if (log.isTraceEnabled()) {
            log.tracef("Loaded %08x from %d:%d (length %d)", new Object[]{System.identityHashCode(this), offset, occupiedSpace, this.length()});
        }
    }

    private static java.nio.ByteBuffer loadBuffer(FileChannel indexFile, long offset, int occupiedSpace) throws IOException {
        int nowRead;
        java.nio.ByteBuffer buffer = java.nio.ByteBuffer.allocate(occupiedSpace);
        int read = 0;
        do {
            if ((nowRead = indexFile.read(buffer, offset + (long)read)) >= 0) continue;
            throw new IOException("Cannot read record [" + offset + ":" + occupiedSpace + "] (already read " + read + "), file size is " + indexFile.size());
        } while ((read += nowRead) < occupiedSpace);
        buffer.rewind();
        return buffer;
    }

    private IndexNode(Index.Segment segment, byte[] newPrefix, byte[][] newKeyParts, LeafNode[] newLeafNodes) {
        this.segment = segment;
        this.prefix = newPrefix;
        this.keyParts = newKeyParts;
        this.leafNodes = newLeafNodes;
    }

    private IndexNode(Index.Segment segment, byte[] newPrefix, byte[][] newKeyParts, InnerNode[] newInnerNodes) {
        this.segment = segment;
        this.prefix = newPrefix;
        this.keyParts = newKeyParts;
        this.innerNodes = newInnerNodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexNode indexNode = (IndexNode)o;
        if (!Arrays.equals(this.innerNodes, indexNode.innerNodes)) {
            return false;
        }
        if (!Arrays.equals(this.leafNodes, indexNode.leafNodes)) {
            return false;
        }
        if (!Arrays.equals(this.prefix, indexNode.prefix)) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.keyParts, (Object[])indexNode.keyParts);
    }

    private void replaceContent(IndexNode other) throws IOException {
        try {
            this.lock.writeLock().lock();
            this.prefix = other.prefix;
            this.keyParts = other.keyParts;
            this.innerNodes = other.innerNodes;
            this.leafNodes = other.leafNodes;
            this.contentLength = (short)-1;
            this.keyPartsLength = (short)-1;
            this.totalLength = (short)-1;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (this.offset >= 0L) {
            this.store(new Index.IndexSpace(this.offset, this.occupiedSpace));
        }
    }

    void store(Index.IndexSpace indexSpace) throws IOException {
        this.offset = indexSpace.offset;
        this.occupiedSpace = indexSpace.length;
        java.nio.ByteBuffer buffer = java.nio.ByteBuffer.allocate(this.length());
        buffer.putShort((short)this.prefix.length);
        buffer.put(this.prefix);
        byte flags = 0;
        if (this.innerNodes != null && this.innerNodes.length != 0) {
            flags = (byte)(flags | 2);
        } else if (this.leafNodes != null && this.leafNodes.length != 0) {
            flags = (byte)(flags | 1);
        }
        buffer.put(flags);
        buffer.putShort((short)this.keyParts.length);
        for (byte[] keyPart : this.keyParts) {
            buffer.putShort((short)keyPart.length);
            buffer.put(keyPart);
        }
        if (this.innerNodes != null) {
            for (InnerNode innerNode : this.innerNodes) {
                buffer.putLong(innerNode.offset);
                buffer.putShort(innerNode.length);
            }
        } else {
            for (LeafNode leafNode : this.leafNodes) {
                buffer.putInt(leafNode.file);
                buffer.putInt(leafNode.offset);
                buffer.putShort(leafNode.numRecords);
                buffer.putInt(leafNode.cacheSegment);
            }
        }
        assert (buffer.position() == buffer.limit()) : "Buffer position: " + buffer.position() + " limit: " + buffer.limit();
        buffer.flip();
        this.segment.getIndexFile().write(buffer, this.offset);
        if (log.isTraceEnabled()) {
            log.tracef("Persisted %08x (length %d, %d %s) to %d:%d", new Object[]{System.identityHashCode(this), this.length(), this.innerNodes != null ? this.innerNodes.length : this.leafNodes.length, this.innerNodes != null ? "children" : "leaves", this.offset, this.occupiedSpace});
        }
    }

    private static boolean entryKeyEqualsBuffer(EntryRecord headerAndKey, ByteBuffer buffer) {
        byte[] key = headerAndKey.getKey();
        return Util.arraysEqual((byte[])key, (int)0, (int)key.length, (byte[])buffer.getBuf(), (int)buffer.getOffset(), (int)(buffer.getOffset() + buffer.getLength()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T applyOnLeaf(Index.Segment segment, int cacheSegment, byte[] indexKey, Lock rootLock, ReadOperation operation) throws IOException {
        int attempts = 0;
        while (true) {
            rootLock.lock();
            IndexNode node = segment.getRoot();
            Lock parentLock = rootLock;
            Lock currentLock = null;
            try {
                int insertionPoint2;
                while (node.innerNodes != null) {
                    currentLock = node.lock.readLock();
                    currentLock.lock();
                    parentLock.unlock();
                    parentLock = currentLock;
                    insertionPoint2 = node.getInsertionPoint(indexKey);
                    node = node.innerNodes[insertionPoint2].getIndexNode(segment);
                    if (node != null) continue;
                    T t = null;
                    return t;
                }
                currentLock = node.lock.readLock();
                currentLock.lock();
                if (node.leafNodes.length == 0) {
                    log.tracef("No leaf nodes found that maps to provided key", new Object[0]);
                    T insertionPoint2 = null;
                    return insertionPoint2;
                }
                insertionPoint2 = node.getInsertionPoint(indexKey);
                byte cacheSegmentBytesSize = UnsignedNumeric.sizeUnsignedInt((int)cacheSegment);
                Object t = operation.apply(node.leafNodes[insertionPoint2], (ByteBuffer)ByteBufferImpl.create((byte[])indexKey, (int)cacheSegmentBytesSize, (int)(indexKey.length - cacheSegmentBytesSize)), segment.getFileProvider(), segment.getTimeService());
                return t;
            }
            catch (IndexNodeOutdatedException e) {
                try {
                    if (attempts > 10) {
                        throw log.indexLooksCorrupt(e);
                    }
                    Thread.sleep(1000L);
                    ++attempts;
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                if (parentLock != currentLock) {
                    parentLock.unlock();
                }
                if (currentLock == null) continue;
                currentLock.unlock();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long calculateMaxSeqId(Index.Segment segment, Lock lock) throws IOException {
        lock.lock();
        try {
            long l = IndexNode.calculateMaxSeqId(segment.getRoot(), segment);
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    private static long calculateMaxSeqId(IndexNode node, Index.Segment segment) throws IOException {
        long maxSeqId = 0L;
        node.lock.readLock().lock();
        try {
            if (node.leafNodes != null) {
                for (LeafNode ln : node.leafNodes) {
                    EntryRecord record = ln.loadHeaderAndKey(segment.getFileProvider());
                    maxSeqId = Math.max(maxSeqId, record.getHeader().seqId());
                }
            }
            if (node.innerNodes != null) {
                for (InnerNode in : node.innerNodes) {
                    maxSeqId = Math.max(maxSeqId, IndexNode.calculateMaxSeqId(in.getIndexNode(segment), segment));
                }
            }
        }
        catch (IndexNodeOutdatedException e) {
            throw log.indexLooksCorrupt(e);
        }
        finally {
            node.lock.readLock().unlock();
        }
        return maxSeqId;
    }

    private void updateFileOffsetInFile(int leafOffset, int newFile, int newOffset, short numRecords) throws IOException {
        long offset = this.offset >= 0L ? this.offset : 0L;
        offset += (long)this.headerLength();
        offset += (long)this.keyPartsLength();
        offset += (long)leafOffset * 14L;
        java.nio.ByteBuffer buffer = java.nio.ByteBuffer.allocate(10);
        buffer.putInt(newFile);
        buffer.putInt(newOffset);
        buffer.putShort(numRecords);
        buffer.flip();
        this.segment.getIndexFile().write(buffer, offset);
    }

    private static IndexNode findParentNode(IndexNode root, byte[] indexKey, Deque<Path> stack) throws IOException {
        IndexNode node = root;
        while (node.innerNodes != null) {
            int insertionPoint = node.getInsertionPoint(indexKey);
            if (stack != null) {
                stack.push(new Path(node, insertionPoint));
            }
            if (log.isTraceEnabled()) {
                log.tracef("Pushed %08x (length %d, %d children) to stack (insertion point %d)", new Object[]{System.identityHashCode(node), node.length(), node.innerNodes.length, insertionPoint});
            }
            node = node.innerNodes[insertionPoint].getIndexNode(root.segment);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setPosition(IndexNode root, IndexRequest request, OverwriteHook overwriteHook, RecordChange recordChange) throws IOException {
        block39: {
            block37: {
                cacheSegment = request.getSegment();
                indexKey = Index.toIndexKey(cacheSegment, request.getSerializedKey());
                node = IndexNode.findParentNode(root, indexKey, stack = new ArrayDeque<Path>());
                copy = node.copyWith(request, cacheSegment, indexKey, overwriteHook, recordChange);
                if (copy == node) {
                    return;
                }
                if (IndexNode.log.isTraceEnabled()) {
                    IndexNode.log.tracef("Created %08x (length %d) from %08x (length %d), stack size %d", new Object[]{System.identityHashCode(copy), copy.length(), System.identityHashCode(node), node.length(), stack.size()});
                }
                garbage = new ArrayDeque<IndexNode>();
                try {
                    block41: {
                        block40: {
                            result = IndexNode.manageLength(root.segment, stack, node, copy, garbage);
                            if (result == null) break block40;
                            if (IndexNode.log.isTraceEnabled()) {
                                IndexNode.log.tracef("Created (1) %d new nodes, GC %08x", result.newNodes.size(), System.identityHashCode(node));
                            }
                            break block41;
                        }
                        while (true) lbl-1000:
                        // 4 sources

                        {
                            if (garbage.isEmpty()) {
                                return;
                            }
                            oldNode = (IndexNode)garbage.pop();
                            oldNode.lock.writeLock().lock();
                            try {
                                if (oldNode.offset < 0L) ** GOTO lbl-1000
                                oldNode.segment.freeIndexSpace(oldNode.offset, oldNode.occupiedSpace);
                                oldNode.offset = -1L;
                                oldNode.occupiedSpace = (short)-1;
                            }
                            finally {
                                oldNode.lock.writeLock().unlock();
                                continue;
                            }
                            break;
                        }
                        ** GOTO lbl-1000
                    }
                    garbage.push(node);
                    while (true) {
                        if (stack.isEmpty()) {
                            if (result.newNodes.size() == 1) {
                                newRoot = result.newNodes.get(0);
                                if (IndexNode.log.isTraceEnabled()) {
                                    IndexNode.log.tracef("Setting new root %08x (index has shrunk)", System.identityHashCode(newRoot));
                                }
                            } else {
                                newRoot = IndexNode.emptyWithInnerNodes(root.segment).copyWith(0, 0, result.newNodes);
                                root.segment.getIndexFile().force(false);
                                if (IndexNode.log.isTraceEnabled()) {
                                    IndexNode.log.tracef("Setting new root %08x (index has grown)", System.identityHashCode(newRoot));
                                }
                            }
                            newRoot.segment.setRoot(newRoot);
                            break block37;
                        }
                        path = (Path)stack.pop();
                        copy = path.node.copyWith(result.from, result.to, result.newNodes);
                        if (IndexNode.log.isTraceEnabled()) {
                            IndexNode.log.tracef("Created %08x (length %d) from %08x with the %d new nodes (%d - %d)", new Object[]{System.identityHashCode(copy), copy.length(), System.identityHashCode(path.node), result.newNodes.size(), result.from, result.to});
                        }
                        if ((result = IndexNode.manageLength(path.node.segment, stack, path.node, copy, garbage)) != null) ** break block38
                        if (IndexNode.log.isTraceEnabled()) {
                            IndexNode.log.tracef("No more index updates required", new Object[0]);
                        }
                        break block39;
                        break;
                    }
                }
                catch (Throwable var15_18) {}
                {
                    if (IndexNode.log.isTraceEnabled()) {
                        IndexNode.log.tracef("Created (2) %d new nodes, GC %08x", result.newNodes.size(), System.identityHashCode(path.node));
                    }
                    garbage.push(path.node);
                    continue;
                }
                ** GOTO lbl95
            }
            while (true) lbl-1000:
            // 4 sources

            {
                if (garbage.isEmpty()) {
                    return;
                }
                oldNode = (IndexNode)garbage.pop();
                oldNode.lock.writeLock().lock();
                try {
                    if (oldNode.offset < 0L) ** GOTO lbl-1000
                    oldNode.segment.freeIndexSpace(oldNode.offset, oldNode.occupiedSpace);
                    oldNode.offset = -1L;
                    oldNode.occupiedSpace = (short)-1;
                }
                finally {
                    oldNode.lock.writeLock().unlock();
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
        }
        while (true) lbl-1000:
        // 4 sources

        {
            if (garbage.isEmpty()) {
                return;
            }
            oldNode = (IndexNode)garbage.pop();
            oldNode.lock.writeLock().lock();
            try {
                if (oldNode.offset < 0L) ** GOTO lbl-1000
                oldNode.segment.freeIndexSpace(oldNode.offset, oldNode.occupiedSpace);
                oldNode.offset = -1L;
                oldNode.occupiedSpace = (short)-1;
            }
            finally {
                oldNode.lock.writeLock().unlock();
                continue;
            }
            break;
        }
        {
            ** GOTO lbl-1000
lbl95:
            // 1 sources

            while (true) {
                if (garbage.isEmpty()) {
                    throw var15_18;
                }
                oldNode = (IndexNode)garbage.pop();
                oldNode.lock.writeLock().lock();
                try {
                    if (oldNode.offset < 0L) continue;
                    oldNode.segment.freeIndexSpace(oldNode.offset, oldNode.occupiedSpace);
                    oldNode.offset = -1L;
                    oldNode.occupiedSpace = (short)-1;
                    continue;
                }
                finally {
                    oldNode.lock.writeLock().unlock();
                    continue;
                }
                break;
            }
        }
    }

    private static JoinSplitResult manageLength(Index.Segment segment, Deque<Path> stack, IndexNode node, IndexNode copy, Deque<IndexNode> garbage) throws IOException {
        int to;
        int from;
        if (copy.length() < segment.getMinNodeSize() && !stack.isEmpty()) {
            int joinWith;
            Path parent = stack.peek();
            if (parent.node.innerNodes.length == 1) {
                if (copy.length() <= node.occupiedSpace) {
                    node.replaceContent(copy);
                    return null;
                }
                return new JoinSplitResult(parent.index, parent.index, Collections.singletonList(copy));
            }
            int sizeWithLeft = Integer.MAX_VALUE;
            int sizeWithRight = Integer.MAX_VALUE;
            if (parent.index > 0) {
                sizeWithLeft = copy.length() + parent.node.innerNodes[parent.index - 1].length - 5;
            }
            if (parent.index < parent.node.innerNodes.length - 1) {
                sizeWithRight = copy.length() + parent.node.innerNodes[parent.index + 1].length - 5;
            }
            if (sizeWithLeft == Integer.MAX_VALUE) {
                joinWith = parent.index + 1;
            } else if (sizeWithRight == Integer.MAX_VALUE) {
                joinWith = parent.index - 1;
            } else if (sizeWithLeft > segment.getMaxNodeSize() && sizeWithRight > segment.getMaxNodeSize()) {
                joinWith = sizeWithLeft >= sizeWithRight ? parent.index - 1 : parent.index + 1;
            } else {
                int n = joinWith = sizeWithLeft <= sizeWithRight ? parent.index - 1 : parent.index + 1;
            }
            if (joinWith < 0 || joinWith >= parent.node.innerNodes.length) {
                throw new IllegalStateException(String.format("parent %08x, %08x -> %08x: cannot join to %d, with left %d, with right %d, max %d", System.identityHashCode(parent.node), System.identityHashCode(node), System.identityHashCode(copy), joinWith, sizeWithLeft, sizeWithRight, segment.getMaxNodeSize()));
            }
            IndexNode joiner = parent.node.innerNodes[joinWith].getIndexNode(segment);
            byte[] middleKey = IndexNode.concat(parent.node.prefix, parent.node.keyParts[joinWith < parent.index ? parent.index - 1 : parent.index]);
            if (joinWith < parent.index) {
                copy = IndexNode.join(joiner, middleKey, copy);
                from = joinWith;
                to = parent.index;
            } else {
                copy = IndexNode.join(copy, middleKey, joiner);
                from = parent.index;
                to = joinWith;
            }
            garbage.push(joiner);
        } else {
            if (copy.length() <= node.occupiedSpace) {
                if (copy.innerNodes != null && copy.innerNodes.length == 1 && stack.isEmpty()) {
                    IndexNode child = copy.innerNodes[0].getIndexNode(copy.segment);
                    return new JoinSplitResult(0, 0, Collections.singletonList(child));
                }
                node.replaceContent(copy);
                return null;
            }
            if (stack.isEmpty()) {
                to = 0;
                from = 0;
            } else {
                from = to = stack.peek().index;
            }
        }
        if (copy.length() <= segment.getMaxNodeSize()) {
            return new JoinSplitResult(from, to, Collections.singletonList(copy));
        }
        return new JoinSplitResult(from, to, copy.split());
    }

    private static IndexNode join(IndexNode left, byte[] middleKey, IndexNode right) throws IOException {
        byte[] rightmostKey;
        byte[] newPrefix = IndexNode.commonPrefix(left.prefix, right.prefix);
        byte[][] newKeyParts = new byte[left.keyParts.length + right.keyParts.length + 1][];
        newPrefix = IndexNode.commonPrefix(newPrefix, middleKey);
        IndexNode.copyKeyParts(left.keyParts, 0, newKeyParts, 0, left.keyParts.length, left.prefix, newPrefix);
        try {
            rightmostKey = left.rightmostKey();
        }
        catch (IndexNodeOutdatedException e) {
            throw new IllegalStateException(e);
        }
        int commonLength = Math.abs(IndexNode.compare(middleKey, rightmostKey));
        newKeyParts[left.keyParts.length] = IndexNode.substring(middleKey, newPrefix.length, commonLength);
        IndexNode.copyKeyParts(right.keyParts, 0, newKeyParts, left.keyParts.length + 1, right.keyParts.length, right.prefix, newPrefix);
        if (left.innerNodes != null && right.innerNodes != null) {
            InnerNode[] newInnerNodes = new InnerNode[left.innerNodes.length + right.innerNodes.length];
            System.arraycopy(left.innerNodes, 0, newInnerNodes, 0, left.innerNodes.length);
            System.arraycopy(right.innerNodes, 0, newInnerNodes, left.innerNodes.length, right.innerNodes.length);
            return new IndexNode(left.segment, newPrefix, (byte[][])newKeyParts, newInnerNodes);
        }
        if (left.leafNodes != null && right.leafNodes != null) {
            LeafNode[] newLeafNodes = new LeafNode[left.leafNodes.length + right.leafNodes.length];
            System.arraycopy(left.leafNodes, 0, newLeafNodes, 0, left.leafNodes.length);
            System.arraycopy(right.leafNodes, 0, newLeafNodes, left.leafNodes.length, right.leafNodes.length);
            return new IndexNode(left.segment, newPrefix, (byte[][])newKeyParts, newLeafNodes);
        }
        throw new IllegalArgumentException("Cannot join " + left + " and " + right);
    }

    private IndexNode copyWith(int oldNodesFrom, int oldNodesTo, List<IndexNode> newNodes) throws IOException {
        InnerNode[] newInnerNodes = new InnerNode[this.innerNodes.length + newNodes.size() - 1 - oldNodesTo + oldNodesFrom];
        System.arraycopy(this.innerNodes, 0, newInnerNodes, 0, oldNodesFrom);
        System.arraycopy(this.innerNodes, oldNodesTo + 1, newInnerNodes, oldNodesFrom + newNodes.size(), this.innerNodes.length - oldNodesTo - 1);
        for (int i = 0; i < newNodes.size(); ++i) {
            IndexNode node = newNodes.get(i);
            Index.IndexSpace space = this.segment.allocateIndexSpace(node.length());
            node.store(space);
            newInnerNodes[i + oldNodesFrom] = new InnerNode(node);
        }
        byte[][] newKeys = new byte[newNodes.size() - 1][];
        byte[] newPrefix = this.prefix;
        for (int i = 0; i < newKeys.length; ++i) {
            try {
                newKeys[i] = newNodes.get(i + 1).leftmostKey();
                if (newKeys[i] == null) {
                    throw new IllegalStateException();
                }
            }
            catch (IndexNodeOutdatedException e) {
                throw new IllegalStateException("Index cannot be outdated for segment updater thread", e);
            }
            newPrefix = IndexNode.commonPrefix(newPrefix, newKeys[i]);
        }
        byte[][] newKeyParts = new byte[this.keyParts.length + newNodes.size() - 1 - oldNodesTo + oldNodesFrom][];
        IndexNode.copyKeyParts(this.keyParts, 0, newKeyParts, 0, oldNodesFrom, this.prefix, newPrefix);
        IndexNode.copyKeyParts(this.keyParts, oldNodesTo, newKeyParts, oldNodesFrom + newKeys.length, this.keyParts.length - oldNodesTo, this.prefix, newPrefix);
        for (int i = 0; i < newKeys.length; ++i) {
            newKeyParts[i + oldNodesFrom] = IndexNode.substring(newKeys[i], newPrefix.length, newKeys[i].length);
        }
        return new IndexNode(this.segment, newPrefix, (byte[][])newKeyParts, newInnerNodes);
    }

    private byte[] leftmostKey() throws IOException, IndexNodeOutdatedException {
        if (this.innerNodes != null) {
            for (InnerNode innerNode : this.innerNodes) {
                byte[] key = innerNode.getIndexNode(this.segment).leftmostKey();
                if (key == null) continue;
                return key;
            }
        } else {
            for (LeafNode leafNode : this.leafNodes) {
                EntryRecord hak = leafNode.loadHeaderAndKey(this.segment.getFileProvider());
                if (hak.getKey() == null) continue;
                return Index.toIndexKey(leafNode.cacheSegment, hak.getKey());
            }
        }
        return null;
    }

    private byte[] rightmostKey() throws IOException, IndexNodeOutdatedException {
        if (this.innerNodes != null) {
            for (int i = this.innerNodes.length - 1; i >= 0; --i) {
                byte[] key = this.innerNodes[i].getIndexNode(this.segment).rightmostKey();
                if (key == null) continue;
                return key;
            }
        } else {
            for (int i = this.leafNodes.length - 1; i >= 0; --i) {
                EntryRecord hak = this.leafNodes[i].loadHeaderAndKey(this.segment.getFileProvider());
                if (hak.getKey() == null) continue;
                return Index.toIndexKey(this.leafNodes[i].cacheSegment, hak.getKey());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexNode copyWith(IndexRequest request, int cacheSegment, byte[] indexKey, OverwriteHook overwriteHook, RecordChange recordChange) throws IOException {
        LeafNode[] newLeafNodes;
        Object newKeyParts;
        byte[] newPrefix;
        EntryRecord hak;
        if (this.leafNodes == null) {
            throw new IllegalArgumentException();
        }
        int file = request.getFile();
        int offset = request.getOffset();
        int size = request.getSize();
        if (this.leafNodes.length == 0) {
            overwriteHook.setOverwritten(request, cacheSegment, false, -1, -1);
            if (overwriteHook.check(request, -1, -1)) {
                return new IndexNode(this.segment, this.prefix, this.keyParts, new LeafNode[]{new LeafNode(file, offset, 1, cacheSegment)});
            }
            this.segment.getCompactor().free(file, size);
            return this;
        }
        int insertPart = this.getInsertionPoint(indexKey);
        LeafNode oldLeafNode = this.leafNodes[insertPart];
        short numRecords = oldLeafNode.numRecords;
        switch (recordChange) {
            case INCREASE: 
            case INCREASE_FOR_OLD: {
                if (numRecords == Short.MAX_VALUE) {
                    throw new IllegalStateException("Too many records for this key (short overflow)");
                }
                numRecords = (short)(numRecords + 1);
                break;
            }
            case MOVE: {
                break;
            }
            case DECREASE: {
                numRecords = (short)(numRecords - 1);
            }
        }
        try {
            hak = oldLeafNode.loadHeaderAndKey(this.segment.getFileProvider());
        }
        catch (IndexNodeOutdatedException e) {
            throw new IllegalStateException("Index cannot be outdated for segment updater thread", e);
        }
        byte[] oldIndexKey = Index.toIndexKey(oldLeafNode.cacheSegment, hak.getKey());
        int keyComp = IndexNode.compare(oldIndexKey, indexKey);
        Object objectKey = request.getKey();
        if (keyComp == 0) {
            if (numRecords > 0) {
                if (overwriteHook.check(request, oldLeafNode.file, oldLeafNode.offset)) {
                    if (recordChange == RecordChange.INCREASE || recordChange == RecordChange.MOVE) {
                        if (log.isTraceEnabled()) {
                            log.trace(String.format("Overwriting %s %d:%d with %d:%d (%d)", objectKey, oldLeafNode.file, oldLeafNode.offset, file, offset, numRecords));
                        }
                        this.updateFileOffsetInFile(insertPart, file, offset, numRecords);
                        this.segment.getCompactor().free(oldLeafNode.file, hak.getHeader().totalLength());
                    } else {
                        if (log.isTraceEnabled()) {
                            log.trace(String.format("Updating num records for %s %d:%d to %d", objectKey, oldLeafNode.file, oldLeafNode.offset, numRecords));
                        }
                        if (recordChange == RecordChange.INCREASE_FOR_OLD) {
                            this.segment.getCompactor().free(file, size);
                        }
                        file = oldLeafNode.file;
                        offset = oldLeafNode.offset;
                    }
                    this.lock.writeLock().lock();
                    try {
                        this.leafNodes[insertPart] = new LeafNode(file, offset, numRecords, cacheSegment);
                    }
                    finally {
                        this.lock.writeLock().unlock();
                    }
                    overwriteHook.setOverwritten(request, cacheSegment, true, oldLeafNode.file, oldLeafNode.offset);
                    return this;
                }
                overwriteHook.setOverwritten(request, cacheSegment, false, -1, -1);
                this.segment.getCompactor().free(file, size);
                return this;
            }
            overwriteHook.setOverwritten(request, cacheSegment, true, oldLeafNode.file, oldLeafNode.offset);
            if (this.keyParts.length <= 1) {
                newPrefix = Util.EMPTY_BYTE_ARRAY;
                newKeyParts = Util.EMPTY_BYTE_ARRAY_ARRAY;
            } else {
                newPrefix = this.prefix;
                newKeyParts = new byte[this.keyParts.length - 1][];
                if (insertPart == this.keyParts.length) {
                    System.arraycopy(this.keyParts, 0, newKeyParts, 0, ((byte[][])newKeyParts).length);
                } else {
                    System.arraycopy(this.keyParts, 0, newKeyParts, 0, insertPart);
                    System.arraycopy(this.keyParts, insertPart + 1, newKeyParts, insertPart, ((byte[][])newKeyParts).length - insertPart);
                }
            }
            if (this.leafNodes.length > 0) {
                newLeafNodes = new LeafNode[this.leafNodes.length - 1];
                System.arraycopy(this.leafNodes, 0, newLeafNodes, 0, insertPart);
                System.arraycopy(this.leafNodes, insertPart + 1, newLeafNodes, insertPart, newLeafNodes.length - insertPart);
            } else {
                newLeafNodes = this.leafNodes;
            }
            this.segment.getCompactor().free(oldLeafNode.file, hak.getHeader().totalLength());
        } else {
            assert (recordChange == RecordChange.INCREASE);
            overwriteHook.setOverwritten(request, cacheSegment, false, -1, -1);
            newPrefix = this.keyParts.length == 0 ? (keyComp > 0 ? indexKey : oldIndexKey) : IndexNode.commonPrefix(this.prefix, indexKey);
            newKeyParts = new byte[this.keyParts.length + 1][];
            newLeafNodes = new LeafNode[this.leafNodes.length + 1];
            IndexNode.copyKeyParts(this.keyParts, 0, newKeyParts, 0, insertPart, this.prefix, newPrefix);
            IndexNode.copyKeyParts(this.keyParts, insertPart, newKeyParts, insertPart + 1, this.keyParts.length - insertPart, this.prefix, newPrefix);
            if (keyComp > 0) {
                newKeyParts[insertPart] = IndexNode.substring(indexKey, newPrefix.length, keyComp);
                System.arraycopy(this.leafNodes, 0, newLeafNodes, 0, insertPart + 1);
                System.arraycopy(this.leafNodes, insertPart + 1, newLeafNodes, insertPart + 2, this.leafNodes.length - insertPart - 1);
                log.tracef("Creating new leafNode for %s at %d:%d", objectKey, file, offset);
                newLeafNodes[insertPart + 1] = new LeafNode(file, offset, 1, cacheSegment);
            } else {
                newKeyParts[insertPart] = IndexNode.substring(oldIndexKey, newPrefix.length, -keyComp);
                System.arraycopy(this.leafNodes, 0, newLeafNodes, 0, insertPart);
                System.arraycopy(this.leafNodes, insertPart, newLeafNodes, insertPart + 1, this.leafNodes.length - insertPart);
                log.tracef("Creating new leafNode for %s at %d:%d", objectKey, file, offset);
                newLeafNodes[insertPart] = new LeafNode(file, offset, 1, cacheSegment);
            }
        }
        return new IndexNode(this.segment, newPrefix, (byte[][])newKeyParts, newLeafNodes);
    }

    private int getIterationPoint(byte[] key, int cacheSegment) {
        int insertionPoint;
        int comp = IndexNode.compare(key, this.prefix, this.prefix.length);
        if (comp > 0) {
            insertionPoint = 0;
        } else if (comp < 0) {
            insertionPoint = this.keyParts.length;
        } else {
            byte[] keyPostfix = IndexNode.substring(key, this.prefix.length, key.length);
            insertionPoint = Arrays.binarySearch(this.keyParts, keyPostfix, REVERSED_COMPARE_TO);
            if (insertionPoint < 0) {
                insertionPoint = -insertionPoint - 1;
            } else {
                int cacheSegmentToUse;
                int n = cacheSegmentToUse = cacheSegment < 0 ? UnsignedNumeric.readUnsignedInt((byte[])key, (int)0) : cacheSegment;
                if (UnsignedNumeric.sizeUnsignedInt((int)cacheSegmentToUse) < key.length) {
                    insertionPoint += cacheSegment < 0 ? 1 : 2;
                }
            }
        }
        return insertionPoint;
    }

    private int getInsertionPoint(byte[] key) {
        byte[] keyPostfix;
        int insertionPoint;
        int comp = IndexNode.compare(key, this.prefix, this.prefix.length);
        insertionPoint = comp > 0 ? 0 : (comp < 0 ? this.keyParts.length : ((insertionPoint = Arrays.binarySearch(this.keyParts, keyPostfix = IndexNode.substring(key, this.prefix.length, key.length), REVERSED_COMPARE_TO)) < 0 ? -insertionPoint - 1 : ++insertionPoint));
        return insertionPoint;
    }

    private List<IndexNode> split() {
        short headerLength = this.headerLength();
        short contentLength = this.contentLength();
        int maxLength = this.segment.getMaxNodeSize();
        int targetParts = contentLength / Math.max(maxLength - headerLength, 1) + 1;
        int targetLength = contentLength / targetParts + headerLength;
        ArrayList<IndexNode> list = new ArrayList<IndexNode>();
        int childLength = this.innerNodes != null ? 10 : 14;
        byte[] prefixExtension = this.keyParts[0];
        int currentLength = 5 + this.prefix.length + prefixExtension.length + 2 * childLength + 2;
        int nodeFrom = 0;
        for (int i = 1; i < this.keyParts.length; ++i) {
            byte[] newPrefixExtension = IndexNode.commonPrefix(prefixExtension, this.keyParts[i]);
            int newLength = newPrefixExtension.length != prefixExtension.length ? currentLength + (prefixExtension.length - newPrefixExtension.length) * (i - nodeFrom - 1) : currentLength;
            if ((newLength += this.keyParts[i].length - newPrefixExtension.length + childLength + 2) < targetLength) {
                currentLength = newLength;
            } else {
                IndexNode subNode;
                if (newLength > maxLength) {
                    subNode = this.subNode(prefixExtension, nodeFrom, i);
                    ++i;
                } else {
                    subNode = this.subNode(newPrefixExtension, nodeFrom, i + 1);
                    i += 2;
                }
                list.add(subNode);
                if (i < this.keyParts.length) {
                    newPrefixExtension = this.keyParts[i];
                }
                currentLength = 5 + this.prefix.length + newPrefixExtension.length + 2 * childLength + 2;
                nodeFrom = i;
            }
            prefixExtension = newPrefixExtension;
        }
        if (nodeFrom <= this.keyParts.length) {
            list.add(this.subNode(prefixExtension, nodeFrom, this.keyParts.length));
        }
        return list;
    }

    private IndexNode subNode(byte[] newPrefixExtension, int childFrom, int childTo) {
        byte[] newPrefix;
        byte[][] newKeyParts = new byte[childTo - childFrom][];
        if (newPrefixExtension.length > 0) {
            for (int i = childFrom; i < childTo; ++i) {
                newKeyParts[i - childFrom] = IndexNode.substring(this.keyParts[i], newPrefixExtension.length, this.keyParts[i].length);
            }
        } else {
            System.arraycopy(this.keyParts, childFrom, newKeyParts, 0, childTo - childFrom);
        }
        byte[] byArray = newPrefix = childFrom == childTo ? Util.EMPTY_BYTE_ARRAY : IndexNode.concat(this.prefix, newPrefixExtension);
        if (this.innerNodes != null) {
            InnerNode[] newInnerNodes = new InnerNode[childTo - childFrom + 1];
            System.arraycopy(this.innerNodes, childFrom, newInnerNodes, 0, childTo - childFrom + 1);
            return new IndexNode(this.segment, newPrefix, (byte[][])newKeyParts, newInnerNodes);
        }
        if (this.leafNodes != null) {
            LeafNode[] newLeafNodes = new LeafNode[childTo - childFrom + 1];
            System.arraycopy(this.leafNodes, childFrom, newLeafNodes, 0, childTo - childFrom + 1);
            return new IndexNode(this.segment, newPrefix, (byte[][])newKeyParts, newLeafNodes);
        }
        throw new IllegalStateException();
    }

    private static byte[] concat(byte[] first, byte[] second) {
        if (first == null || first.length == 0) {
            return second;
        }
        if (second == null || second.length == 0) {
            return first;
        }
        byte[] result = new byte[first.length + second.length];
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    private static void copyKeyParts(byte[][] src, int srcIndex, byte[][] dest, int destIndex, int length, byte[] oldPrefix, byte[] common) {
        if (oldPrefix.length == common.length) {
            System.arraycopy(src, srcIndex, dest, destIndex, length);
        } else {
            for (int i = 0; i < length; ++i) {
                dest[destIndex + i] = IndexNode.findNewKeyPart(oldPrefix, src[srcIndex + i], common);
            }
        }
    }

    private static byte[] findNewKeyPart(byte[] oldPrefix, byte[] oldKeyPart, byte[] common) {
        byte[] newPart = new byte[oldKeyPart.length + oldPrefix.length - common.length];
        System.arraycopy(oldPrefix, common.length, newPart, 0, oldPrefix.length - common.length);
        System.arraycopy(oldKeyPart, 0, newPart, oldPrefix.length - common.length, oldKeyPart.length);
        return newPart;
    }

    private static byte[] substring(byte[] key, int begin, int end) {
        if (end <= begin) {
            return Util.EMPTY_BYTE_ARRAY;
        }
        if (begin == 0 && end == key.length) {
            return key;
        }
        byte[] sub = new byte[end - begin];
        System.arraycopy(key, begin, sub, 0, end - begin);
        return sub;
    }

    private static byte[] commonPrefix(byte[] oldPrefix, byte[] newKey) {
        int i = Arrays.mismatch(oldPrefix, newKey);
        if (i == oldPrefix.length) {
            return oldPrefix;
        }
        if (i == newKey.length) {
            return newKey;
        }
        if (i == 0) {
            return Util.EMPTY_BYTE_ARRAY;
        }
        byte[] prefix = new byte[i];
        System.arraycopy(oldPrefix, 0, prefix, 0, i);
        return prefix;
    }

    private static int compare(byte[] first, byte[] second, int secondLength) {
        if (secondLength == 0) {
            return 0;
        }
        int mismatchPos = Arrays.mismatch(first, 0, first.length, second, 0, secondLength);
        if (mismatchPos == -1 || mismatchPos == secondLength) {
            return 0;
        }
        if (mismatchPos >= first.length) {
            return first.length + 1;
        }
        return second[mismatchPos] > first[mismatchPos] ? mismatchPos + 1 : -mismatchPos - 1;
    }

    private static int compare(byte[] first, byte[] second) {
        int mismatchPos = Arrays.mismatch(first, second);
        if (mismatchPos == -1) {
            return 0;
        }
        if (mismatchPos >= first.length) {
            return first.length + 1;
        }
        if (mismatchPos >= second.length) {
            return -second.length - 1;
        }
        return second[mismatchPos] > first[mismatchPos] ? mismatchPos + 1 : -mismatchPos - 1;
    }

    private short headerLength() {
        int headerLength = 5 + this.prefix.length;
        assert (headerLength <= Short.MAX_VALUE);
        return (short)headerLength;
    }

    private short keyPartsLength() {
        if (this.keyPartsLength >= 0) {
            return this.keyPartsLength;
        }
        int sum = 0;
        for (byte[] keyPart : this.keyParts) {
            sum += 2 + keyPart.length;
        }
        assert (sum <= Short.MAX_VALUE);
        this.keyPartsLength = (short)sum;
        return this.keyPartsLength;
    }

    private short contentLength() {
        if (this.contentLength >= 0) {
            return this.contentLength;
        }
        int sum = this.keyPartsLength();
        if (this.innerNodes != null) {
            sum += 10 * this.innerNodes.length;
        } else if (this.leafNodes != null) {
            sum += 14 * this.leafNodes.length;
        } else {
            throw new IllegalStateException();
        }
        assert (sum <= Short.MAX_VALUE);
        this.contentLength = (short)sum;
        return this.contentLength;
    }

    public short length() {
        if (this.totalLength >= 0) {
            return this.totalLength;
        }
        int totalLength = this.headerLength() + this.contentLength();
        assert (totalLength >= 0 && totalLength <= Short.MAX_VALUE);
        this.totalLength = (short)totalLength;
        return this.totalLength;
    }

    public static IndexNode emptyWithLeaves(Index.Segment segment) {
        return new IndexNode(segment, Util.EMPTY_BYTE_ARRAY, Util.EMPTY_BYTE_ARRAY_ARRAY, LeafNode.EMPTY_ARRAY);
    }

    private static IndexNode emptyWithInnerNodes(Index.Segment segment) {
        return new IndexNode(segment, Util.EMPTY_BYTE_ARRAY, Util.EMPTY_BYTE_ARRAY_ARRAY, new InnerNode[]{new InnerNode(-1L, -1)});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i <= this.keyParts.length; ++i) {
            sb.append('\n');
            if (this.leafNodes != null && i < this.leafNodes.length) {
                sb.append(" [").append(this.leafNodes[i].file).append(':').append(this.leafNodes[i].offset).append(':').append(this.leafNodes[i].cacheSegment).append("] ");
            } else {
                sb.append(" [").append(this.innerNodes[i].offset).append(':').append(this.innerNodes[i].length).append("] ");
            }
            if (i >= this.keyParts.length) continue;
            sb.append(new String(IndexNode.concat(this.prefix, this.keyParts[i])));
        }
        sb.append('\n');
        return sb.toString();
    }

    Flowable<EntryRecord> publish(IntSet cacheSegments, boolean loadValues) {
        long currentTime = this.segment.getTimeService().wallClockTime();
        int cacheSegmentSize = cacheSegments.size();
        if (cacheSegmentSize == 0) {
            return Flowable.empty();
        }
        return Flowable.defer(() -> {
            Deque sortedSegmentPrefixes = cacheSegments.intStream().filter(cacheSegment -> this.segment.index.sizePerSegment.get(cacheSegment) != 0L).mapToObj(cacheSegment -> {
                byte[] segmentPrefix = new byte[UnsignedNumeric.sizeUnsignedInt((int)cacheSegment)];
                UnsignedNumeric.writeUnsignedInt((byte[])segmentPrefix, (int)0, (int)cacheSegment);
                return segmentPrefix;
            }).sorted(REVERSED_COMPARE_TO).collect(Collectors.toCollection(ArrayDeque::new));
            if (sortedSegmentPrefixes.isEmpty()) {
                return Flowable.empty();
            }
            return new FlowableCreate(emitter -> {
                ByRef.Boolean done = new ByRef.Boolean(false);
                do {
                    done.set(false);
                    this.recursiveNode(this, this.segment, sortedSegmentPrefixes, (FlowableEmitter<EntryRecord>)emitter, loadValues, currentTime, new ByRef.Boolean(false), done, false);
                    if (emitter.requested() != 0L && !emitter.isCancelled()) continue;
                    return;
                } while (done.get() && !sortedSegmentPrefixes.isEmpty());
                emitter.onComplete();
            }, BackpressureStrategy.ERROR);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recursiveNode(IndexNode node, Index.Segment segment, Deque<byte[]> segmentPrefixes, FlowableEmitter<EntryRecord> emitter, boolean loadValues, long currentTime, ByRef.Boolean foundData, ByRef.Boolean done, boolean firstNodeAttempted) throws IOException {
        block27: {
            Lock readLock = node.lock.readLock();
            readLock.lock();
            try {
                int suggestedIteration;
                boolean firstData;
                byte[] previousKey = null;
                int previousSegment = -1;
                if (node.innerNodes != null) {
                    int point;
                    for (int i = point = foundData.get() ? 0 : node.getIterationPoint(segmentPrefixes.getFirst(), -1); !segmentPrefixes.isEmpty() && i < node.innerNodes.length && !done.get(); ++i) {
                        this.recursiveNode(node.innerNodes[i].getIndexNode(segment), segment, segmentPrefixes, emitter, loadValues, currentTime, foundData, done, i == point);
                    }
                    break block27;
                }
                if (node.leafNodes == null) break block27;
                byte[] segmentPrefix = segmentPrefixes.getFirst();
                int cacheSegment = UnsignedNumeric.readUnsignedInt((byte[])segmentPrefix, (int)0);
                boolean bl = firstData = !foundData.get();
                if (firstData) {
                    suggestedIteration = node.getIterationPoint(segmentPrefix, cacheSegment);
                    foundData.set(true);
                } else {
                    suggestedIteration = 0;
                }
                for (int i = suggestedIteration; i < node.leafNodes.length; ++i) {
                    byte[] keyArray;
                    int keyLength;
                    int lengthDiff;
                    EntryRecord record;
                    LeafNode leafNode = node.leafNodes[i];
                    if (leafNode.cacheSegment != cacheSegment) {
                        if (i == suggestedIteration && firstData && segmentPrefix.length == UnsignedNumeric.sizeUnsignedInt((int)cacheSegment)) {
                            if (i != node.leafNodes.length - 1 && (i == node.keyParts.length || i < node.keyParts.length && IndexNode.compare(node.keyParts[i], segmentPrefix, Math.min(segmentPrefix.length, node.keyParts[i].length)) == 0)) continue;
                            if (i == node.leafNodes.length - 1 && firstNodeAttempted) {
                                return;
                            }
                        }
                        segmentPrefixes.removeFirst();
                        segmentPrefix = segmentPrefixes.peekFirst();
                        if (segmentPrefix != null) {
                            cacheSegment = UnsignedNumeric.readUnsignedInt((byte[])segmentPrefix, (int)0);
                        }
                        if (leafNode.cacheSegment != cacheSegment) {
                            done.set(true);
                            return;
                        }
                    }
                    try {
                        if (loadValues) {
                            log.tracef("Loading record for leafNode: %s", leafNode);
                            record = leafNode.loadRecord(segment.getFileProvider(), null, segment.getTimeService());
                        } else {
                            log.tracef("Loading header and key for leafNode: %s", leafNode);
                            record = leafNode.getHeaderAndKey(segment.getFileProvider(), null);
                        }
                    }
                    catch (IndexNodeOutdatedException e) {
                        if (previousKey != null) {
                            byte[] currentIndexKey = Index.toIndexKey(previousSegment, previousKey);
                            segmentPrefixes.removeFirst();
                            segmentPrefixes.addFirst(currentIndexKey);
                        }
                        done.set(true);
                        readLock.unlock();
                        return;
                    }
                    if (record == null || record.getHeader().valueLength() <= 0 || firstData && i == suggestedIteration && (lengthDiff = segmentPrefix.length - (keyLength = record.getHeader().keyLength())) > 0 && Util.arraysEqual((byte[])(keyArray = record.getKey()), (int)0, (int)keyArray.length, (byte[])segmentPrefix, (int)lengthDiff, (int)segmentPrefix.length)) continue;
                    long expiryTime = record.getHeader().expiryTime();
                    if (expiryTime < 0L || expiryTime > currentTime) {
                        emitter.onNext((Object)record);
                        if (emitter.requested() == 0L) {
                            byte[] currentIndexKey = Index.toIndexKey(cacheSegment, record.getKey());
                            segmentPrefixes.removeFirst();
                            segmentPrefixes.addFirst(currentIndexKey);
                            done.set(true);
                            return;
                        }
                        if (emitter.isCancelled()) {
                            done.set(true);
                            return;
                        }
                    }
                    previousKey = record.getKey();
                    previousSegment = cacheSegment;
                }
                if (previousKey != null) {
                    byte[] currentIndexKey = Index.toIndexKey(previousSegment, previousKey);
                    segmentPrefixes.removeFirst();
                    segmentPrefixes.addFirst(currentIndexKey);
                }
            }
            finally {
                readLock.unlock();
            }
        }
    }

    private static class LeafNode
    extends EntryInfo {
        private static final LeafNode[] EMPTY_ARRAY = new LeafNode[0];
        private volatile SoftReference<EntryRecord> keyReference;

        LeafNode(int file, int offset, short numRecords, int cacheSegment) {
            super(file, offset, numRecords, cacheSegment);
        }

        public EntryRecord loadHeaderAndKey(FileProvider fileProvider) throws IOException, IndexNodeOutdatedException {
            return this.getHeaderAndKey(fileProvider, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EntryRecord getHeaderAndKey(FileProvider fileProvider, FileProvider.Handle handle) throws IOException, IndexNodeOutdatedException {
            EntryRecord headerAndKey;
            if (this.keyReference == null || (headerAndKey = this.keyReference.get()) == null) {
                LeafNode leafNode = this;
                synchronized (leafNode) {
                    if (this.keyReference == null || (headerAndKey = this.keyReference.get()) == null) {
                        boolean ownHandle = false;
                        if (handle == null) {
                            ownHandle = true;
                            handle = fileProvider.getFile(this.file);
                            if (handle == null) {
                                throw new IndexNodeOutdatedException(this.file + ":" + this.offset + " (" + this.numRecords + ")");
                            }
                        }
                        try {
                            int readOffset = this.offset < 0 ? ~this.offset : this.offset;
                            EntryHeader header = EntryRecord.readEntryHeader(handle, readOffset);
                            if (header == null) {
                                throw new IllegalStateException("Error reading header from " + this.file + ":" + readOffset + " | " + handle.getFileSize());
                            }
                            byte[] key = EntryRecord.readKey(handle, header, readOffset);
                            if (key == null) {
                                throw new IllegalStateException("Error reading key from " + this.file + ":" + readOffset);
                            }
                            headerAndKey = new EntryRecord(header, key);
                            this.keyReference = new SoftReference<EntryRecord>(headerAndKey);
                        }
                        finally {
                            if (ownHandle) {
                                handle.close();
                            }
                        }
                    }
                }
            }
            assert (headerAndKey.getKey() != null);
            return headerAndKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EntryRecord loadRecord(FileProvider fileProvider, ByteBuffer key, TimeService timeService) throws IOException, IndexNodeOutdatedException {
            int readOffset;
            FileProvider.Handle handle = fileProvider.getFile(this.file);
            int n = readOffset = this.offset < 0 ? ~this.offset : this.offset;
            if (handle == null) {
                throw new IndexNodeOutdatedException(this.file + ":" + readOffset);
            }
            try {
                boolean trace = log.isTraceEnabled();
                EntryRecord headerAndKey = this.getHeaderAndKey(fileProvider, handle);
                if (key != null && !IndexNode.entryKeyEqualsBuffer(headerAndKey, key)) {
                    if (trace) {
                        log.trace("Key on " + this.file + ":" + readOffset + " not matched.");
                    }
                    EntryRecord entryRecord = null;
                    return entryRecord;
                }
                if (headerAndKey.getHeader().valueLength() <= 0) {
                    if (trace) {
                        log.trace("Entry " + this.file + ":" + readOffset + " matched, it is a tombstone.");
                    }
                    EntryRecord entryRecord = null;
                    return entryRecord;
                }
                if (timeService != null && headerAndKey.getHeader().expiryTime() > 0L && headerAndKey.getHeader().expiryTime() <= timeService.wallClockTime()) {
                    if (trace) {
                        log.trace("Key on " + this.file + ":" + readOffset + " matched but expired.");
                    }
                    EntryRecord entryRecord = null;
                    return entryRecord;
                }
                if (trace) {
                    log.trace("Loaded from " + this.file + ":" + readOffset);
                }
                EntryRecord entryRecord = headerAndKey.loadMetadataAndValue(handle, readOffset, key != null);
                return entryRecord;
            }
            finally {
                handle.close();
            }
        }
    }

    static class InnerNode
    extends Index.IndexSpace {
        private volatile SoftReference<IndexNode> reference;

        InnerNode(long offset, short length) {
            super(offset, length);
        }

        InnerNode(IndexNode node) {
            super(node.offset, node.occupiedSpace);
            this.reference = new SoftReference<IndexNode>(node);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        IndexNode getIndexNode(Index.Segment segment) throws IOException {
            IndexNode node;
            if (this.reference == null || (node = this.reference.get()) == null) {
                InnerNode innerNode = this;
                synchronized (innerNode) {
                    if (this.reference == null || (node = this.reference.get()) == null) {
                        if (this.offset < 0L) {
                            return null;
                        }
                        node = new IndexNode(segment, this.offset, this.length);
                        this.reference = new SoftReference<IndexNode>(node);
                        if (log.isTraceEnabled()) {
                            log.trace("Loaded inner node from " + this.offset + " - " + this.length);
                        }
                    }
                }
            }
            return node;
        }
    }

    public static enum ReadOperation {
        GET_RECORD{

            protected EntryRecord apply(LeafNode leafNode, ByteBuffer key, FileProvider fileProvider, TimeService timeService) throws IOException, IndexNodeOutdatedException {
                return leafNode.loadRecord(fileProvider, key, timeService);
            }
        }
        ,
        GET_EXPIRED_RECORD{

            protected EntryRecord apply(LeafNode leafNode, ByteBuffer key, FileProvider fileProvider, TimeService timeService) throws IOException, IndexNodeOutdatedException {
                return leafNode.loadRecord(fileProvider, key, null);
            }
        }
        ,
        GET_POSITION{

            protected EntryPosition apply(LeafNode leafNode, ByteBuffer key, FileProvider fileProvider, TimeService timeService) throws IOException, IndexNodeOutdatedException {
                EntryRecord hak = leafNode.loadHeaderAndKey(fileProvider);
                if (IndexNode.entryKeyEqualsBuffer(hak, key)) {
                    if (hak.getHeader().expiryTime() > 0L && hak.getHeader().expiryTime() <= timeService.wallClockTime()) {
                        if (log.isTraceEnabled()) {
                            log.tracef("Found node on %d:%d but it is expired", leafNode.file, leafNode.offset);
                        }
                        return null;
                    }
                    return leafNode;
                }
                if (log.isTraceEnabled()) {
                    log.tracef("Found node on %d:%d but key does not match", leafNode.file, leafNode.offset);
                }
                return null;
            }
        }
        ,
        GET_INFO{

            protected EntryInfo apply(LeafNode leafNode, ByteBuffer key, FileProvider fileProvider, TimeService timeService) throws IOException, IndexNodeOutdatedException {
                EntryRecord hak = leafNode.loadHeaderAndKey(fileProvider);
                if (IndexNode.entryKeyEqualsBuffer(hak, key)) {
                    log.tracef("Found matching leafNode %s", leafNode);
                    return leafNode;
                }
                if (log.isTraceEnabled()) {
                    log.tracef("Found node on %d:%d but key does not match", leafNode.file, leafNode.offset);
                }
                return null;
            }
        };


        protected abstract <T> T apply(LeafNode var1, ByteBuffer var2, FileProvider var3, TimeService var4) throws IOException, IndexNodeOutdatedException;
    }

    private static class IndexNodeOutdatedException
    extends Exception {
        IndexNodeOutdatedException(String message) {
            super(message);
        }
    }

    private static class Path {
        IndexNode node;
        public int index;

        private Path(IndexNode node, int index) {
            this.node = node;
            this.index = index;
        }
    }

    public static interface OverwriteHook {
        default public boolean check(IndexRequest request, int oldFile, int oldOffset) {
            return true;
        }

        public void setOverwritten(IndexRequest var1, int var2, boolean var3, int var4, int var5);
    }

    public static enum RecordChange {
        INCREASE,
        INCREASE_FOR_OLD,
        MOVE,
        DECREASE;

    }

    private static class JoinSplitResult {
        public final int from;
        public final int to;
        final List<IndexNode> newNodes;

        private JoinSplitResult(int from, int to, List<IndexNode> newNodes) {
            this.from = from;
            this.to = to;
            this.newNodes = newNodes;
        }
    }
}

