/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import java.util.concurrent.CompletableFuture;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.persistence.sifs.EntryMetadata;
import org.infinispan.persistence.sifs.IndexRequest;
import org.infinispan.persistence.spi.MarshallableEntry;

class LogRequest
extends CompletableFuture<Void> {
    private final Type type;
    private final int segment;
    private final Object key;
    private final long expirationTime;
    private final ByteBuffer serializedKey;
    private final ByteBuffer serializedMetadata;
    private final ByteBuffer serializedValue;
    private final ByteBuffer serializedInternalMetadata;
    private final long created;
    private final long lastUsed;
    private volatile int file;
    private volatile int fileOffset;
    private volatile IndexRequest indexRequest;

    private LogRequest(Type type, int segment, Object key, long expirationTime, ByteBuffer serializedKey, ByteBuffer serializedMetadata, ByteBuffer serializedInternalMetadata, ByteBuffer serializedValue, long created, long lastUsed) {
        this.segment = segment;
        this.key = key;
        this.expirationTime = expirationTime;
        this.serializedKey = serializedKey;
        this.serializedMetadata = serializedMetadata;
        this.serializedInternalMetadata = serializedInternalMetadata;
        this.serializedValue = serializedValue;
        this.created = created;
        this.lastUsed = lastUsed;
        this.type = type;
    }

    private LogRequest(Type type) {
        this(type, -1, null, 0L, null, null, null, null, -1L, -1L);
    }

    public static LogRequest storeRequest(int segment, MarshallableEntry entry) {
        return new LogRequest(Type.STORE, segment, entry.getKey(), entry.expiryTime(), entry.getKeyBytes(), entry.getMetadataBytes(), entry.getInternalMetadataBytes(), entry.getValueBytes(), entry.created(), entry.lastUsed());
    }

    public static LogRequest deleteRequest(int segment, Object key, ByteBuffer serializedKey) {
        return new LogRequest(Type.DELETE, segment, key, -1L, serializedKey, null, null, null, -1L, -1L);
    }

    public static LogRequest clearRequest() {
        return new LogRequest(Type.CLEAR_ALL);
    }

    public static LogRequest pauseRequest() {
        return new LogRequest(Type.PAUSE);
    }

    public static LogRequest resumeRequest() {
        return new LogRequest(Type.RESUME);
    }

    public int length() {
        return 27 + this.serializedKey.getLength() + (this.serializedValue != null ? this.serializedValue.getLength() : 0) + EntryMetadata.size(this.serializedMetadata) + (this.serializedInternalMetadata != null ? this.serializedInternalMetadata.getLength() : 0);
    }

    public Object getKey() {
        return this.key;
    }

    public int getSegment() {
        return this.segment;
    }

    public ByteBuffer getSerializedKey() {
        return this.serializedKey;
    }

    public ByteBuffer getSerializedMetadata() {
        return this.serializedMetadata;
    }

    public ByteBuffer getSerializedInternalMetadata() {
        return this.serializedInternalMetadata;
    }

    public ByteBuffer getSerializedValue() {
        return this.serializedValue;
    }

    public long getCreated() {
        return this.created;
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    public long getExpiration() {
        return this.expirationTime;
    }

    public boolean isClear() {
        return this.type == Type.CLEAR_ALL;
    }

    public boolean isPause() {
        return this.type == Type.PAUSE;
    }

    public boolean isResume() {
        return this.type == Type.RESUME;
    }

    public void setIndexRequest(IndexRequest indexRequest) {
        this.indexRequest = indexRequest;
    }

    public int getFile() {
        return this.file;
    }

    public void setFile(int file) {
        this.file = file;
    }

    public int getFileOffset() {
        return this.fileOffset;
    }

    public void setFileOffset(int fileOffset) {
        this.fileOffset = fileOffset;
    }

    public IndexRequest getIndexRequest() {
        return this.indexRequest;
    }

    @Override
    public String toString() {
        return "LogRequest{type=" + this.type + ", segment=" + this.segment + ", key=" + this.key + ", file=" + this.file + ", fileOffset=" + this.fileOffset + "}";
    }

    static enum Type {
        STORE,
        DELETE,
        CLEAR_ALL,
        PAUSE,
        RESUME;

    }
}

