/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.infinispan.commons.util.IntSet;
import org.infinispan.distribution.LocalizedCacheTopology;

public class ReadOnlySegmentAwareIterator<E>
implements Iterator<E> {
    protected final Iterator<E> iter;
    protected final LocalizedCacheTopology topology;
    protected final IntSet allowedSegments;
    protected E next;

    public ReadOnlySegmentAwareIterator(Iterator<E> iter, LocalizedCacheTopology topology, IntSet allowedSegments) {
        this.iter = iter;
        this.topology = topology;
        this.allowedSegments = allowedSegments;
        this.next = this.findNext();
    }

    protected boolean valueAllowed(Object obj) {
        int segment = this.topology.getSegment(obj);
        return this.allowedSegments.contains(segment);
    }

    protected E findNext() {
        while (this.iter.hasNext()) {
            E next = this.iter.next();
            if (!this.valueAllowed(next)) continue;
            return next;
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public E next() {
        E prev = this.next;
        if (prev == null) {
            throw new NoSuchElementException();
        }
        this.next = this.findNext();
        return prev;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }
}

