/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.affinity.impl;

import java.util.concurrent.Executor;
import org.infinispan.Cache;
import org.infinispan.affinity.KeyAffinityServiceFactory;
import org.infinispan.affinity.KeyGenerator;
import org.infinispan.affinity.ListenerRegistration;
import org.infinispan.affinity.impl.BaseKeyAffinityServiceTest;
import org.infinispan.affinity.impl.KeyAffinityServiceImpl;
import org.infinispan.affinity.impl.RndKeyGenerator;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="affinity.KeyAffinityServiceShutdownTest")
public class KeyAffinityServiceShutdownTest
extends BaseKeyAffinityServiceTest {
    private EmbeddedCacheManager cacheManager;

    @Override
    protected void createCacheManagers() throws Throwable {
        super.createCacheManagers();
        this.cacheManager = this.manager(0);
        this.keyAffinityService = (KeyAffinityServiceImpl)KeyAffinityServiceFactory.newKeyAffinityService((Cache)this.cacheManager.getCache(this.cacheName), (Executor)this.executor, (KeyGenerator)new RndKeyGenerator(), (int)100);
    }

    public void testSimpleShutdown() throws Exception {
        this.assertListenerRegistered(true);
        this.assertEventualFullCapacity();
        assert (this.keyAffinityService.isKeyGeneratorThreadAlive());
        this.keyAffinityService.stop();
        for (int i = 0; i < 10 && this.keyAffinityService.isKeyGeneratorThreadAlive(); ++i) {
            Thread.sleep(1000L);
        }
        assert (!this.keyAffinityService.isKeyGeneratorThreadAlive());
        assert (!this.executor.isShutdown());
    }

    @Test(dependsOnMethods={"testSimpleShutdown"})
    public void testServiceCannotBeUsedAfterShutdown() {
        try {
            this.keyAffinityService.getKeyForAddress(this.topology().get(0));
            assert (false) : "Exception expected!";
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.keyAffinityService.getCollocatedKey((Object)"a");
            assert (false) : "Exception expected!";
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test(dependsOnMethods={"testServiceCannotBeUsedAfterShutdown"})
    public void testViewChaneListenerUnregistered() {
        this.assertListenerRegistered(false);
    }

    @Test(dependsOnMethods={"testViewChaneListenerUnregistered"})
    public void testRestart() throws InterruptedException {
        this.keyAffinityService.start();
        this.assertEventualFullCapacity();
    }

    private void assertListenerRegistered(boolean registered) {
        boolean isRegistered = false;
        for (Object o : TestingUtil.getListeners(this.cacheManager)) {
            if (!(o instanceof ListenerRegistration)) continue;
            isRegistered = true;
            break;
        }
        AssertJUnit.assertEquals((boolean)registered, (boolean)isRegistered);
    }
}

