/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.batch;

import java.lang.reflect.Method;
import org.infinispan.Cache;
import org.infinispan.api.batch.AbstractBatchTest;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="api.batch.BatchWithoutTMTest")
public class BatchWithoutTMTest
extends AbstractBatchTest {
    @Override
    public EmbeddedCacheManager createCacheManager() {
        ConfigurationBuilder defaultConfiguration = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        defaultConfiguration.invocationBatching().enable().transaction().autoCommit(false);
        return TestCacheManagerFactory.createCacheManager(defaultConfiguration);
    }

    public void testBatchWithoutCfg(Method method) {
        Cache cache = this.createCache(false, method.getName());
        Exceptions.expectException(CacheConfigurationException.class, () -> cache.startBatch());
        Exceptions.expectException(CacheConfigurationException.class, () -> cache.endBatch(true));
        Exceptions.expectException(CacheConfigurationException.class, () -> cache.endBatch(false));
    }

    public void testEndBatchWithoutStartBatch(Method method) {
        Cache cache = this.createCache(method.getName());
        cache.endBatch(true);
        cache.endBatch(false);
    }

    public void testStartBatchIdempotency(Method method) {
        Cache cache = this.createCache(method.getName());
        cache.startBatch();
        cache.put((Object)"k", (Object)"v");
        cache.startBatch();
        cache.put((Object)"k2", (Object)"v2");
        cache.endBatch(true);
        AssertJUnit.assertEquals((String)"v", (String)((String)cache.get((Object)"k")));
        AssertJUnit.assertEquals((String)"v2", (String)((String)cache.get((Object)"k2")));
    }

    public void testBatchVisibility(Method method) throws Exception {
        Cache cache = this.createCache(method.getName());
        cache.startBatch();
        cache.put((Object)"k", (Object)"v");
        AssertJUnit.assertNull((String)"Other thread should not see batch update till batch completes!", (Object)this.getOnDifferentThread(cache, "k"));
        cache.endBatch(true);
        AssertJUnit.assertEquals((String)"v", (String)this.getOnDifferentThread(cache, "k"));
    }

    public void testBatchRollback(Method method) throws Exception {
        Cache cache = this.createCache(method.getName());
        cache.startBatch();
        cache.put((Object)"k", (Object)"v");
        cache.put((Object)"k2", (Object)"v2");
        AssertJUnit.assertNull((Object)this.getOnDifferentThread(cache, "k"));
        AssertJUnit.assertNull((Object)this.getOnDifferentThread(cache, "k2"));
        cache.endBatch(false);
        AssertJUnit.assertNull((Object)this.getOnDifferentThread(cache, "k"));
        AssertJUnit.assertNull((Object)this.getOnDifferentThread(cache, "k2"));
    }

    @Override
    protected <K, V> Cache<K, V> createCache(String name) {
        return this.createCache(true, name);
    }

    private <K, V> Cache<K, V> createCache(boolean enableBatch, String name) {
        ConfigurationBuilder c = new ConfigurationBuilder();
        c.invocationBatching().enable(enableBatch);
        this.cacheManager.defineConfiguration(name, c.build());
        return this.cacheManager.getCache(name);
    }
}

