/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.lazy;

import java.lang.reflect.Method;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.data.Person;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.lazy.LazyCacheAPITest")
public class LazyCacheAPITest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder c = this.getDefaultStandaloneCacheConfig(true);
        c.memory().storageType(StorageType.BINARY);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(false, TestDataSCI.INSTANCE);
        cm.defineConfiguration("lazy-cache-test", c.build());
        this.cache = cm.getCache("lazy-cache-test");
        return cm;
    }

    public void testReplace(Method m) {
        Person key = new Person(m.getName());
        this.cache.put((Object)key, (Object)"1");
        assert ("1".equals(this.cache.get((Object)new Person(m.getName()))));
        Object oldValue = this.cache.replace((Object)new Person(m.getName()), (Object)"2");
        assert ("1".equals(oldValue));
        assert ("2".equals(this.cache.get((Object)new Person(m.getName()))));
    }

    public void testReplaceWithOld(Method m) {
        Person key = new Person(m.getName());
        this.cache.put((Object)key, (Object)"1");
        assert ("1".equals(this.cache.get((Object)new Person(m.getName()))));
        assert (!this.cache.replace((Object)new Person(m.getName()), (Object)"99", (Object)"2"));
        assert (this.cache.replace((Object)new Person(m.getName()), (Object)"1", (Object)"2"));
        key = new Person(m.getName() + "-withCustomValue");
        Person v1 = new Person("value1");
        this.cache.put((Object)key, (Object)v1);
        assert (v1.equals(this.cache.get((Object)key)));
        Person v99 = new Person("value99");
        Person v2 = new Person("value2");
        assert (!this.cache.replace((Object)key, (Object)v99, (Object)v2));
        assert (this.cache.replace((Object)key, (Object)v1, (Object)v2));
    }
}

