/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commands.StressTest;
import org.infinispan.commons.executors.BlockingThreadPoolExecutorFactory;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.fwk.InCacheMode;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"stress"}, testName="commands.GetAllCommandStressTest", timeOut=900000L)
@InCacheMode(value={CacheMode.DIST_SYNC})
public class GetAllCommandStressTest
extends StressTest {
    protected final String CACHE_NAME = "testCache";
    protected static final int CACHE_COUNT = 6;
    protected static final int THREAD_MULTIPLIER = 4;
    protected static final int CACHE_ENTRY_COUNT = 50000;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.builderUsed = new ConfigurationBuilder();
        this.builderUsed.clustering().cacheMode(this.cacheMode);
        this.builderUsed.clustering().stateTransfer().chunkSize(25000);
        this.builderUsed.clustering().remoteTimeout(30000L);
        this.createClusteredCaches(6, "testCache", this.builderUsed);
    }

    @Override
    protected EmbeddedCacheManager addClusterEnabledCacheManager(TransportFlags flags) {
        GlobalConfigurationBuilder gcb = GlobalConfigurationBuilder.defaultClusteredBuilder();
        TestCacheManagerFactory.amendGlobalConfiguration(gcb, flags);
        BlockingThreadPoolExecutorFactory executorFactory = new BlockingThreadPoolExecutorFactory(25, 25, 10000, 30000L);
        gcb.transport().transportThreadPool().threadPoolFactory((ThreadPoolExecutorFactory)executorFactory);
        gcb.transport().remoteCommandThreadPool().threadPoolFactory((ThreadPoolExecutorFactory)executorFactory);
        EmbeddedCacheManager cm = TestCacheManagerFactory.newDefaultCacheManager(true, gcb, new ConfigurationBuilder());
        this.cacheManagers.add(cm);
        return cm;
    }

    public void testStressNodesLeavingWhileMultipleIterators() throws Throwable {
        int i;
        HashMap<Integer, Integer> masterValues = new HashMap<Integer, Integer>();
        int threadWorkerCount = 20;
        Set[] keys = new Set[threadWorkerCount];
        for (i = 0; i < keys.length; ++i) {
            keys[i] = new HashSet();
        }
        for (i = 0; i < 50000; ++i) {
            masterValues.put(i, i);
            keys[i % threadWorkerCount].add(i);
        }
        this.cache(0, "testCache").putAll(masterValues);
        for (i = 0; i < keys.length; ++i) {
            keys[i] = Collections.unmodifiableSet(keys[i]);
        }
        List<Future<Void>> futures = this.forkWorkerThreads("testCache", 4, 6, keys, this::workerLogic);
        futures.add(this.forkRestartingThread(6));
        this.waitAndFinish(futures, 1, TimeUnit.MINUTES);
    }

    protected void workerLogic(Cache<Integer, Integer> cache, Set<Integer> threadKeys, int iteration) {
        Map results = cache.getAdvancedCache().getAll(threadKeys);
        AssertJUnit.assertEquals((String)("Missing: " + String.valueOf(this.diff(threadKeys, results.keySet()))), (int)threadKeys.size(), (int)results.size());
        for (Integer key : threadKeys) {
            AssertJUnit.assertEquals((Object)key, results.get(key));
        }
    }

    private Set<Integer> diff(Set<Integer> superset, Set<Integer> subset) {
        HashSet<Integer> diff = new HashSet<Integer>(superset);
        diff.removeAll(subset);
        return diff;
    }
}

