/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning;

import jakarta.transaction.RollbackException;
import jakarta.transaction.Transaction;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.container.versioning.AbstractClusteredWriteSkewTest;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DistributionTestHelper;
import org.infinispan.distribution.MagicKey;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="container.versioning.DistWriteSkewTest", groups={"functional"})
public class DistWriteSkewTest
extends AbstractClusteredWriteSkewTest {
    @Override
    protected CacheMode getCacheMode() {
        return CacheMode.DIST_SYNC;
    }

    @Override
    protected int clusterSize() {
        return 4;
    }

    public void testWriteSkew() throws Exception {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        Cache cache2 = this.cache(2);
        Cache cache3 = this.cache(3);
        MagicKey hello = new MagicKey("hello", this.cache(2));
        cache1.put((Object)hello, (Object)"world 1");
        this.tm(1).begin();
        AssertJUnit.assertEquals((Object)"world 1", (Object)cache1.get((Object)hello));
        Transaction t = this.tm(1).suspend();
        cache3.put((Object)hello, (Object)"world 3");
        AssertJUnit.assertEquals((Object)"world 3", (Object)cache0.get((Object)hello));
        AssertJUnit.assertEquals((Object)"world 3", (Object)cache1.get((Object)hello));
        AssertJUnit.assertEquals((Object)"world 3", (Object)cache2.get((Object)hello));
        AssertJUnit.assertEquals((Object)"world 3", (Object)cache3.get((Object)hello));
        this.tm(1).resume(t);
        cache1.put((Object)hello, (Object)"world 2");
        try {
            this.tm(1).commit();
            AssertJUnit.fail((String)"Transaction should roll back");
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
        AssertJUnit.assertEquals((Object)"world 3", (Object)cache0.get((Object)hello));
        AssertJUnit.assertEquals((Object)"world 3", (Object)cache1.get((Object)hello));
        AssertJUnit.assertEquals((Object)"world 3", (Object)cache2.get((Object)hello));
        AssertJUnit.assertEquals((Object)"world 3", (Object)cache3.get((Object)hello));
    }

    public void testWriteSkewOnNonOwner() throws Exception {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        Cache cache2 = this.cache(2);
        Cache cache3 = this.cache(3);
        MagicKey hello = new MagicKey("hello", this.cache(0));
        int[] owners = new int[]{0, 0};
        int[] nonOwners = new int[]{0, 0};
        int j = 0;
        int k = 0;
        for (int i = 0; i < 4; ++i) {
            if (DistributionTestHelper.isOwner(this.cache(i), hello)) {
                owners[j++] = i;
                continue;
            }
            nonOwners[k++] = i;
        }
        this.cache(owners[1]).put((Object)hello, (Object)"world 1");
        this.tm(nonOwners[0]).begin();
        assert ("world 1".equals(this.cache(nonOwners[0]).get((Object)hello)));
        Transaction t = this.tm(nonOwners[0]).suspend();
        this.cache(nonOwners[1]).put((Object)hello, (Object)"world 3");
        AssertJUnit.assertEquals((Object)"world 3", (Object)cache0.get((Object)hello));
        AssertJUnit.assertEquals((Object)"world 3", (Object)cache1.get((Object)hello));
        AssertJUnit.assertEquals((Object)"world 3", (Object)cache2.get((Object)hello));
        AssertJUnit.assertEquals((Object)"world 3", (Object)cache3.get((Object)hello));
        this.tm(nonOwners[0]).resume(t);
        this.cache(nonOwners[0]).put((Object)hello, (Object)"world 2");
        try {
            this.tm(nonOwners[0]).commit();
            AssertJUnit.fail((String)"Transaction should roll back");
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
        AssertJUnit.assertEquals((Object)"world 3", (Object)cache0.get((Object)hello));
        AssertJUnit.assertEquals((Object)"world 3", (Object)cache1.get((Object)hello));
        AssertJUnit.assertEquals((Object)"world 3", (Object)cache2.get((Object)hello));
        AssertJUnit.assertEquals((Object)"world 3", (Object)cache3.get((Object)hello));
    }

    public void testWriteSkewMultiEntries() throws Exception {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        Cache cache2 = this.cache(2);
        Cache cache3 = this.cache(3);
        MagicKey hello = new MagicKey("hello", this.cache(2));
        MagicKey hello2 = new MagicKey("hello2", this.cache(3));
        MagicKey hello3 = new MagicKey("hello3", this.cache(0));
        this.tm(1).begin();
        cache1.put((Object)hello, (Object)"world 1");
        cache1.put((Object)hello2, (Object)"world 1");
        cache1.put((Object)hello3, (Object)"world 1");
        this.tm(1).commit();
        this.tm(1).begin();
        cache1.put((Object)hello2, (Object)"world 2");
        cache1.put((Object)hello3, (Object)"world 2");
        AssertJUnit.assertEquals((Object)"world 1", (Object)cache1.get((Object)hello));
        AssertJUnit.assertEquals((Object)"world 2", (Object)cache1.get((Object)hello2));
        AssertJUnit.assertEquals((Object)"world 2", (Object)cache1.get((Object)hello3));
        Transaction t = this.tm(1).suspend();
        cache3.put((Object)hello, (Object)"world 3");
        for (Cache c : this.caches()) {
            AssertJUnit.assertEquals((Object)"world 3", (Object)c.get((Object)hello));
            AssertJUnit.assertEquals((Object)"world 1", (Object)c.get((Object)hello2));
            AssertJUnit.assertEquals((Object)"world 1", (Object)c.get((Object)hello3));
        }
        this.tm(1).resume(t);
        cache1.put((Object)hello, (Object)"world 2");
        try {
            this.tm(1).commit();
            AssertJUnit.fail((String)"Transaction should roll back");
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
        for (Cache c : this.caches()) {
            AssertJUnit.assertEquals((Object)"world 3", (Object)c.get((Object)hello));
            AssertJUnit.assertEquals((Object)"world 1", (Object)c.get((Object)hello2));
            AssertJUnit.assertEquals((Object)"world 1", (Object)c.get((Object)hello3));
        }
    }

    public void testNullEntries() throws Exception {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        Cache cache2 = this.cache(2);
        Cache cache3 = this.cache(3);
        MagicKey hello = new MagicKey("hello", cache2, cache1);
        cache0.put((Object)hello, (Object)"world");
        this.tm(0).begin();
        AssertJUnit.assertEquals((Object)"world", (Object)cache0.get((Object)hello));
        Transaction t = this.tm(0).suspend();
        cache1.remove((Object)hello);
        AssertJUnit.assertNull((Object)cache0.get((Object)hello));
        AssertJUnit.assertNull((Object)cache1.get((Object)hello));
        AssertJUnit.assertNull((Object)cache2.get((Object)hello));
        AssertJUnit.assertNull((Object)cache3.get((Object)hello));
        this.tm(0).resume(t);
        cache0.put((Object)hello, (Object)"world2");
        try {
            this.tm(0).commit();
            AssertJUnit.fail((String)"This transaction should roll back");
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
        AssertJUnit.assertNull((Object)cache0.get((Object)hello));
        AssertJUnit.assertNull((Object)cache1.get((Object)hello));
        AssertJUnit.assertNull((Object)cache2.get((Object)hello));
        AssertJUnit.assertNull((Object)cache3.get((Object)hello));
    }

    public void testResendPrepare() throws Exception {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        Cache cache2 = this.cache(2);
        Cache cache3 = this.cache(3);
        MagicKey hello = new MagicKey("hello", this.cache(2));
        cache0.put((Object)hello, (Object)"world");
        this.tm(2).begin();
        AssertJUnit.assertEquals((Object)"world", (Object)cache2.get((Object)hello));
        Transaction t = this.tm(2).suspend();
        this.cache(0).put((Object)hello, (Object)"world 2");
        AssertJUnit.assertEquals((Object)"world 2", (Object)cache0.get((Object)hello));
        AssertJUnit.assertEquals((Object)"world 2", (Object)cache1.get((Object)hello));
        AssertJUnit.assertEquals((Object)"world 2", (Object)cache2.get((Object)hello));
        AssertJUnit.assertEquals((Object)"world 2", (Object)cache3.get((Object)hello));
        this.tm(2).resume(t);
        cache2.put((Object)hello, (Object)"world 3");
        try {
            this.tm(2).commit();
            AssertJUnit.fail((String)"This transaction should roll back");
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
        AssertJUnit.assertEquals((Object)"world 2", (Object)cache0.get((Object)hello));
        AssertJUnit.assertEquals((Object)"world 2", (Object)cache1.get((Object)hello));
        AssertJUnit.assertEquals((Object)"world 2", (Object)cache2.get((Object)hello));
        AssertJUnit.assertEquals((Object)"world 2", (Object)cache3.get((Object)hello));
    }

    public void testLocalOnlyPut() {
        this.localOnlyPut(this.cache(0), 1, "v1");
        this.localOnlyPut(this.cache(1), 2, "v2");
        this.localOnlyPut(this.cache(2), 3, "v3");
        this.localOnlyPut(this.cache(3), 4, "v4");
    }

    public void testSameNodeKeyCreation() throws Exception {
        this.tm(0).begin();
        Assert.assertEquals((Object)this.cache(0).get((Object)"NewKey"), null);
        this.cache(0).put((Object)"NewKey", (Object)"v1");
        Transaction tx0 = this.tm(0).suspend();
        this.tm(0).begin();
        Assert.assertEquals((Object)this.cache(0).get((Object)"NewKey"), null);
        this.cache(0).put((Object)"NewKey", (Object)"v2");
        this.tm(0).commit();
        this.tm(0).resume(tx0);
        try {
            this.tm(0).commit();
            Assert.fail((String)"The transaction should rollback");
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
        Assert.assertEquals((Object)this.cache(0).get((Object)"NewKey"), (Object)"v2");
        Assert.assertEquals((Object)this.cache(1).get((Object)"NewKey"), (Object)"v2");
    }

    public void testDifferentNodeKeyCreation() throws Exception {
        this.tm(0).begin();
        Assert.assertEquals((Object)this.cache(0).get((Object)"NewKey"), null);
        this.cache(0).put((Object)"NewKey", (Object)"v1");
        Transaction tx0 = this.tm(0).suspend();
        this.tm(1).begin();
        Assert.assertEquals((Object)this.cache(1).get((Object)"NewKey"), null);
        this.cache(1).put((Object)"NewKey", (Object)"v2");
        this.tm(1).commit();
        this.tm(0).resume(tx0);
        try {
            this.tm(0).commit();
            Assert.fail((String)"The transaction should rollback");
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
        Assert.assertEquals((Object)this.cache(0).get((Object)"NewKey"), (Object)"v2");
        Assert.assertEquals((Object)this.cache(1).get((Object)"NewKey"), (Object)"v2");
    }

    private void localOnlyPut(Cache<Integer, String> cache, Integer k, String v) {
        cache.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL).put((Object)k, (Object)v);
    }
}

