/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context;

import jakarta.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.BaseAsyncInterceptor;
import org.infinispan.interceptors.impl.InvocationContextInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.data.Key;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.locks.LockManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="context.MarshalledValueContextTest", groups={"functional"})
public class MarshalledValueContextTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder c = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        c.memory().storageType(StorageType.BINARY).transaction().lockingMode(LockingMode.PESSIMISTIC);
        return TestCacheManagerFactory.createCacheManager(TestDataSCI.INSTANCE, c);
    }

    public void testContentsOfContext() throws Exception {
        Cache c = this.cacheManager.getCache();
        ContextExtractingInterceptor cex = new ContextExtractingInterceptor();
        AssertJUnit.assertTrue((boolean)TestingUtil.extractInterceptorChain(c).addInterceptorAfter((AsyncInterceptor)cex, InvocationContextInterceptor.class));
        c.put((Object)new Key("k"), (Object)"v");
        AssertJUnit.assertEquals((String)"v", (String)((String)c.get((Object)new Key("k"))));
        TransactionManager tm = c.getAdvancedCache().getTransactionManager();
        tm.begin();
        c.getAdvancedCache().lock((Object[])new Key[]{new Key("k")});
        LockManager lockManager = TestingUtil.extractComponent(c, LockManager.class);
        AssertJUnit.assertTrue((boolean)(cex.ctx instanceof LocalTxInvocationContext));
        AssertJUnit.assertEquals((String)"Looked up key should not be in transactional invocation context as we don't perform any changes", (int)0, (int)cex.ctx.lookedUpEntriesCount());
        AssertJUnit.assertEquals((String)"Only one lock should be held", (int)1, (int)lockManager.getNumberOfLocksHeld());
        c.put((Object)new Key("k"), (Object)"v2");
        AssertJUnit.assertEquals((String)"Still should only be one entry in the context", (int)1, (int)cex.ctx.lookedUpEntriesCount());
        AssertJUnit.assertEquals((String)"Only one lock should be held", (int)1, (int)lockManager.getNumberOfLocksHeld());
        tm.commit();
        AssertJUnit.assertEquals((String)"No locks should be held anymore", (int)0, (int)lockManager.getNumberOfLocksHeld());
        AssertJUnit.assertEquals((String)"v2", (String)((String)c.get((Object)new Key("k"))));
    }

    static class ContextExtractingInterceptor
    extends BaseAsyncInterceptor {
        InvocationContext ctx;

        ContextExtractingInterceptor() {
        }

        public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
            this.ctx = ctx;
            return this.invokeNext(ctx, command);
        }
    }
}

