/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.dataconversion;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;

public interface Compression {
    public static final Compression GZIP = new Compression(){

        /*
         * Enabled aggressive exception aggregation
         */
        @Override
        public byte[] compress(String str) {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                byte[] byArray;
                try (GZIPOutputStream os = new GZIPOutputStream(baos);){
                    os.write(str.getBytes(StandardCharsets.UTF_8));
                    os.close();
                    byArray = baos.toByteArray();
                }
                return byArray;
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to compress", e);
            }
        }

        /*
         * Enabled aggressive exception aggregation
         */
        @Override
        public String decompress(byte[] compressed) {
            try (GZIPInputStream is = new GZIPInputStream(new ByteArrayInputStream(compressed));){
                String string;
                try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                    is.transferTo(os);
                    string = os.toString(StandardCharsets.UTF_8);
                }
                return string;
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to decompress", e);
            }
        }

        @Override
        public String name() {
            return "gzip";
        }
    };
    public static final Compression DEFLATE = new Compression(){

        /*
         * Enabled aggressive exception aggregation
         */
        @Override
        public byte[] compress(String str) {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                byte[] byArray;
                try (DeflaterOutputStream os = new DeflaterOutputStream(baos);){
                    os.write(str.getBytes(StandardCharsets.UTF_8));
                    os.close();
                    byArray = baos.toByteArray();
                }
                return byArray;
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to compress", e);
            }
        }

        /*
         * Enabled aggressive exception aggregation
         */
        @Override
        public String decompress(byte[] compressed) {
            try (InflaterInputStream is = new InflaterInputStream(new ByteArrayInputStream(compressed));){
                String string;
                try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                    is.transferTo(os);
                    string = os.toString(StandardCharsets.UTF_8);
                }
                return string;
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to decompress", e);
            }
        }

        @Override
        public String name() {
            return "deflate";
        }
    };

    public byte[] compress(String var1);

    public String decompress(byte[] var1);

    public String name();
}

