/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.dataconversion;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.SAXException;

class TestXMLParser {
    TestXMLParser() {
    }

    public Map<String, String> parse(String input) throws ParserConfigurationException, SAXException, XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader reader = factory.createXMLStreamReader(new StringReader(input));
        HashMap<String, String> pairs = new HashMap<String, String>();
        String currentElement = null;
        String currentValue = null;
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    currentElement = reader.getLocalName();
                    break;
                }
                case 4: {
                    currentValue = reader.getText();
                    break;
                }
                case 2: {
                    if (currentElement != null) {
                        pairs.put(currentElement, currentValue);
                    }
                    currentElement = null;
                    currentValue = null;
                }
            }
        }
        return pairs;
    }

    String serialize(Map<String, String> pairs) throws XMLStreamException {
        if (pairs.isEmpty()) {
            return "";
        }
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        StringWriter writer = new StringWriter();
        XMLStreamWriter streamWriter = factory.createXMLStreamWriter(writer);
        streamWriter.writeStartElement("root");
        for (Map.Entry<String, String> entry : pairs.entrySet()) {
            streamWriter.writeStartElement(entry.getKey());
            streamWriter.writeCharacters(entry.getValue());
            streamWriter.writeEndElement();
        }
        streamWriter.writeEndElement();
        return writer.toString();
    }
}

