/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.distribution.BlockingInterceptor;
import org.infinispan.distribution.MagicKey;
import org.infinispan.interceptors.impl.EntryWrappingInterceptor;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.CacheStoppedDuringReadTest")
public class CacheStoppedDuringReadTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        this.createClusteredCaches(3, TestDataSCI.INSTANCE, CacheStoppedDuringReadTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC));
    }

    public void test() throws Exception {
        MagicKey key = new MagicKey(this.cache(0), this.cache(1));
        this.cache(2).put((Object)key, (Object)"value");
        CyclicBarrier barrier0 = new CyclicBarrier(2);
        TestingUtil.extractInterceptorChain(this.cache(0)).addInterceptorBefore(new BlockingInterceptor<GetCacheEntryCommand>(barrier0, GetCacheEntryCommand.class, false, false), EntryWrappingInterceptor.class);
        Future<Object> f = this.fork(() -> this.cache(2).get((Object)key));
        barrier0.await(10L, TimeUnit.SECONDS);
        this.cache(0).stop();
        barrier0.await(10L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((Object)"value", (Object)f.get(10L, TimeUnit.SECONDS));
    }
}

