/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.infinispan.Cache;
import org.infinispan.container.DataContainer;
import org.infinispan.context.Flag;
import org.infinispan.distribution.BaseDistStoreTest;
import org.infinispan.distribution.MagicKey;
import org.infinispan.marshall.persistence.impl.MarshalledEntryUtil;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.DistSyncStoreNotSharedTest")
@CleanupAfterMethod
public class DistSyncStoreNotSharedTest<D extends DistSyncStoreNotSharedTest<D>>
extends BaseDistStoreTest<Object, String, D> {
    private static final String k1 = "1";
    private static final String v1 = "one";
    private static final String k2 = "2";
    private static final String v2 = "two";
    private static final String k3 = "3";
    private static final String v3 = "three";
    private static final String k4 = "4";
    private static final String v4 = "four";
    private static final String[] keys = new String[]{"1", "2", "3", "4"};
    private static final String[] values = new String[]{"one", "two", "three", "four"};

    public DistSyncStoreNotSharedTest() {
        this.testRetVals = true;
        this.shared = false;
    }

    @Override
    public Object[] factory() {
        return new Object[]{new DistSyncStoreNotSharedTest<D>().segmented(true), new DistSyncStoreNotSharedTest<D>().segmented(false)};
    }

    public void testPutFromNonOwner(Method m) throws Exception {
        String key = TestingUtil.k(m);
        String value = "value2";
        Cache nonOwner = this.getFirstNonOwner(key);
        Cache owner = this.getFirstOwner(key);
        DummyInMemoryStore nonOwnerLoader = (DummyInMemoryStore)TestingUtil.getFirstStore(nonOwner);
        DummyInMemoryStore ownerLoader = (DummyInMemoryStore)TestingUtil.getFirstStore(owner);
        AssertJUnit.assertFalse((boolean)nonOwnerLoader.contains(key));
        AssertJUnit.assertFalse((boolean)ownerLoader.contains(key));
        Object retval = nonOwner.put((Object)key, (Object)value);
        this.assertInStores(key, value, true);
        if (this.testRetVals) assert (retval == null);
        this.assertOnAllCachesAndOwnership(key, value);
    }

    public void testGetFromNonOwnerWithFlags(Method m) throws Exception {
        String key = TestingUtil.k(m);
        String value = "value2";
        Cache nonOwner = this.getFirstNonOwner(key);
        Cache owner = this.getFirstOwner(key);
        DummyInMemoryStore ownerLoader = (DummyInMemoryStore)TestingUtil.getFirstStore(owner);
        owner.put((Object)key, (Object)value);
        AssertJUnit.assertEquals((Object)value, (Object)ownerLoader.loadEntry(key).getValue());
        owner.getAdvancedCache().withFlags(Flag.SKIP_CACHE_STORE).clear();
        AssertJUnit.assertEquals((Object)value, (Object)ownerLoader.loadEntry(key).getValue());
        AssertJUnit.assertNull((Object)owner.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD).get((Object)key));
        AssertJUnit.assertNull((Object)nonOwner.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD).get((Object)key));
        AssertJUnit.assertEquals((String)value, (String)((String)nonOwner.get((Object)key)));
        this.assertOnAllCaches(key, value);
        this.assertOwnershipAndNonOwnership(key, true);
    }

    public void testAsyncGetCleansContextFlags(Method m) throws Exception {
        String key = TestingUtil.k(m);
        String value = "value2";
        Cache nonOwner = this.getFirstNonOwner(key);
        Cache owner = this.getFirstOwner(key);
        owner.put((Object)key, (Object)value);
        owner.getAdvancedCache().withFlags(Flag.SKIP_CACHE_STORE).clear();
        CompletableFuture async = nonOwner.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD).getAsync((Object)key);
        AssertJUnit.assertNotNull((Object)async);
        AssertJUnit.assertNull(async.get());
        async = nonOwner.getAdvancedCache().getAsync((Object)key);
        AssertJUnit.assertNotNull((Object)async);
        String returnedValue = (String)async.get();
        AssertJUnit.assertEquals((String)value, (String)returnedValue);
    }

    public void testPutFromNonOwnerWithFlags(Method m) throws Exception {
        String key = TestingUtil.k(m);
        String value = "value2";
        Cache nonOwner = this.getFirstNonOwner(key);
        Cache owner = this.getFirstOwner(key);
        DummyInMemoryStore nonOwnerLoader = (DummyInMemoryStore)TestingUtil.getFirstStore(nonOwner);
        DummyInMemoryStore ownerLoader = (DummyInMemoryStore)TestingUtil.getFirstStore(owner);
        AssertJUnit.assertFalse((boolean)ownerLoader.contains(key));
        AssertJUnit.assertFalse((boolean)nonOwnerLoader.contains(key));
        Object retval = nonOwner.getAdvancedCache().withFlags(Flag.SKIP_CACHE_STORE).put((Object)key, (Object)value);
        AssertJUnit.assertFalse((boolean)ownerLoader.contains(key));
        AssertJUnit.assertFalse((boolean)nonOwnerLoader.contains(key));
        if (this.testRetVals) assert (retval == null);
        this.assertOnAllCachesAndOwnership(key, value);
    }

    public void testPutFromOwner(Method m) throws Exception {
        String key = TestingUtil.k(m);
        String value = "value3";
        this.getOwners(key)[0].put((Object)key, (Object)value);
        this.assertInStores(key, value, false);
    }

    protected void assertInStores(String key, String value, boolean allowL1) {
        for (Cache c : this.caches) {
            DummyInMemoryStore store = (DummyInMemoryStore)TestingUtil.getFirstStore(c);
            if (this.isOwner(c, key)) {
                this.assertIsInContainerImmortal(c, key);
                AssertJUnit.assertEquals((Object)value, (Object)store.loadEntry(key).getValue());
                continue;
            }
            if (!allowL1) {
                this.assertIsNotInL1(c, key);
            }
            AssertJUnit.assertFalse((boolean)store.contains(key));
        }
    }

    public void testPutForStateTransfer() throws Exception {
        MagicKey k1 = this.getMagicKey();
        DummyInMemoryStore store2 = (DummyInMemoryStore)TestingUtil.getFirstStore(this.c2);
        this.c2.put((Object)k1, (Object)v1);
        AssertJUnit.assertTrue((boolean)store2.contains(k1));
        AssertJUnit.assertEquals((Object)v1, (Object)store2.loadEntry(k1).getValue());
        this.c2.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL).put((Object)k1, (Object)v2);
        AssertJUnit.assertEquals((Object)v2, (Object)store2.loadEntry(k1).getValue());
    }

    public void testPutAll() throws Exception {
        this.c1.putAll(this.makePutAllTestData());
        for (int i = 0; i < keys.length; ++i) {
            this.assertInStores(keys[i], values[i], true);
        }
    }

    public void testPutAllWithFlags() throws Exception {
        Map<String, String> data = this.makePutAllTestData();
        this.c1.getAdvancedCache().withFlags(Flag.SKIP_CACHE_STORE).putAll(data);
        for (Cache c : this.caches) {
            DummyInMemoryStore store = (DummyInMemoryStore)TestingUtil.getFirstStore(c);
            for (String key : keys) {
                AssertJUnit.assertFalse((boolean)store.contains(key));
                if (!this.isOwner(c, key)) continue;
                this.assertIsInContainerImmortal(c, key);
            }
        }
    }

    public void testRemoveFromNonOwner() throws Exception {
        String key = "k1";
        String value = "value";
        this.initAndTest();
        this.assertInStores(key, value, true);
        Object retval = this.getFirstNonOwner(key).remove((Object)key);
        if (this.testRetVals) assert ("value".equals(retval));
        this.assertRemovedFromStores(key);
    }

    protected void assertRemovedFromStores(String key) {
        for (Cache c : this.caches) {
            DummyInMemoryStore store = (DummyInMemoryStore)TestingUtil.getFirstStore(c);
            MarshallableEntry me = store.loadEntry(key);
            assert (me == null || me.getValue() == null);
        }
    }

    public void testRemoveFromNonOwnerWithFlags() throws Exception {
        String key = "k1";
        String value = "value";
        this.initAndTest();
        Object retval = this.getFirstNonOwner(key).getAdvancedCache().withFlags(Flag.SKIP_CACHE_STORE).remove((Object)key);
        if (this.testRetVals) assert (value.equals(retval));
        for (Cache c : this.caches) {
            if (!this.isOwner(c, key)) continue;
            DummyInMemoryStore store = (DummyInMemoryStore)TestingUtil.getFirstStore(c);
            AssertJUnit.assertTrue((boolean)store.contains(key));
        }
    }

    public void testReplaceFromNonOwner() throws Exception {
        String key = "k1";
        String value = "value";
        String value2 = "v2";
        this.initAndTest();
        this.assertInStores(key, value, true);
        Object retval = this.getFirstNonOwner(key).replace((Object)key, (Object)value2);
        if (this.testRetVals) assert (value.equals(retval));
        this.assertInStores(key, value2, true);
    }

    public void testReplaceFromNonOwnerWithFlag() throws Exception {
        String key = "k1";
        String value = "value";
        String value2 = "v2";
        this.initAndTest();
        Object retval = this.getFirstNonOwner(key).getAdvancedCache().withFlags(Flag.SKIP_CACHE_STORE).replace((Object)key, (Object)value2);
        if (this.testRetVals) assert (value.equals(retval));
        AssertJUnit.assertEquals((String)((String)this.getFirstOwner(key).get((Object)key)), (String)value2);
        this.assertInStores(key, value, true);
    }

    public void testAtomicReplaceFromNonOwner() throws Exception {
        String key = "k1";
        String value = "value";
        String value2 = "v2";
        this.initAndTest();
        boolean replaced = this.getFirstNonOwner(key).replace((Object)key, (Object)value2, (Object)value);
        AssertJUnit.assertFalse((boolean)replaced);
        replaced = this.getFirstNonOwner(key).replace((Object)key, (Object)value, (Object)value2);
        AssertJUnit.assertTrue((boolean)replaced);
        for (Cache c : this.caches) {
            AssertJUnit.assertEquals((String)value2, (String)((String)c.get((Object)key)));
            if (!this.isOwner(c, key)) continue;
            DummyInMemoryStore store = (DummyInMemoryStore)TestingUtil.getFirstStore(c);
            AssertJUnit.assertTrue((boolean)store.contains(key));
            AssertJUnit.assertEquals((Object)value2, (Object)store.loadEntry(key).getValue());
        }
    }

    public void testAtomicReplaceFromNonOwnerWithFlag() throws Exception {
        String key = "k1";
        String value = "value";
        String value2 = "v2";
        this.initAndTest();
        boolean replaced = this.getFirstNonOwner(key).replace((Object)key, (Object)value2, (Object)value);
        AssertJUnit.assertFalse((boolean)replaced);
        replaced = this.getFirstNonOwner(key).getAdvancedCache().withFlags(Flag.SKIP_CACHE_STORE).replace((Object)key, (Object)value, (Object)value2);
        AssertJUnit.assertTrue((boolean)replaced);
        for (Cache c : this.caches) {
            AssertJUnit.assertEquals((String)value2, (String)((String)c.get((Object)key)));
            if (!this.isOwner(c, key)) continue;
            DummyInMemoryStore store = (DummyInMemoryStore)TestingUtil.getFirstStore(c);
            AssertJUnit.assertTrue((boolean)store.contains(key));
            AssertJUnit.assertEquals((Object)value, (Object)store.loadEntry(key).getValue());
        }
    }

    public void testAtomicPutIfAbsentFromNonOwner(Method m) throws Exception {
        String key = TestingUtil.k(m);
        String value = "value";
        String value2 = "v2";
        String replaced = (String)this.getFirstNonOwner(key).putIfAbsent((Object)key, (Object)value);
        AssertJUnit.assertNull((Object)replaced);
        replaced = (String)this.getFirstNonOwner(key).putIfAbsent((Object)key, (Object)value2);
        AssertJUnit.assertEquals((String)replaced, (String)value);
        for (Cache c : this.caches) {
            AssertJUnit.assertEquals((String)replaced, (String)((String)c.get((Object)key)));
            if (!this.isOwner(c, key)) continue;
            DummyInMemoryStore store = (DummyInMemoryStore)TestingUtil.getFirstStore(c);
            AssertJUnit.assertTrue((boolean)store.contains(key));
            AssertJUnit.assertEquals((Object)value, (Object)store.loadEntry(key).getValue());
        }
    }

    public void testAtomicPutIfAbsentFromNonOwnerWithFlag(Method m) throws Exception {
        String key = TestingUtil.k(m);
        String value = "value";
        String replaced = (String)this.getFirstNonOwner(key).getAdvancedCache().withFlags(Flag.SKIP_CACHE_STORE).putIfAbsent((Object)key, (Object)value);
        AssertJUnit.assertNull((Object)replaced);
        replaced = (String)this.getFirstNonOwner(key).putIfAbsent((Object)key, (Object)value);
        AssertJUnit.assertEquals((String)replaced, (String)value);
        for (Cache c : this.caches) {
            AssertJUnit.assertEquals((String)replaced, (String)((String)c.get((Object)key)));
            DummyInMemoryStore store = (DummyInMemoryStore)TestingUtil.getFirstStore(c);
            AssertJUnit.assertFalse((boolean)store.contains(key));
        }
    }

    public void testClear() throws Exception {
        this.prepareClearTest();
        this.c1.clear();
        for (Cache c : this.caches) {
            assert (c.isEmpty());
        }
        for (int i = 0; i < 5; ++i) {
            String key = "k" + i;
            this.assertRemovedFromStores(key);
        }
    }

    public void testClearWithFlag() throws Exception {
        this.prepareClearTest();
        this.c1.getAdvancedCache().withFlags(Flag.SKIP_CACHE_STORE).clear();
        for (Cache c : this.caches) {
            DataContainer dc = c.getAdvancedCache().getDataContainer();
            AssertJUnit.assertEquals((int)0, (int)dc.size());
            DummyInMemoryStore store = (DummyInMemoryStore)TestingUtil.getFirstStore(c);
            for (int i = 0; i < 5; ++i) {
                String key = "k" + i;
                if (!this.isOwner(c, key)) continue;
                AssertJUnit.assertTrue((boolean)store.contains(key));
            }
        }
    }

    public void testGetOnlyQueriesCacheOnOwners() throws PersistenceException {
        MagicKey k = this.getMagicKey();
        String v1 = "real-data";
        String v2 = "stale-data";
        Cache c = this.getFirstOwner(k);
        DummyInMemoryStore store = (DummyInMemoryStore)TestingUtil.getFirstStore(c);
        store.write(MarshalledEntryUtil.create(k, "stale-data", this.c3));
        this.getFirstNonOwner(k).put((Object)k, (Object)"real-data");
        AssertJUnit.assertEquals((String)"real-data", (String)((String)c.get((Object)k)));
    }

    private Map<String, String> makePutAllTestData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(k1, v1);
        data.put(k2, v2);
        data.put(k3, v3);
        data.put(k4, v4);
        return data;
    }

    private void prepareClearTest() throws PersistenceException {
        int i;
        for (Cache c : this.caches) {
            assert (c.isEmpty()) : "Data container " + String.valueOf(c) + " should be empty, instead it contains keys " + String.valueOf(c.keySet());
        }
        for (i = 0; i < 5; ++i) {
            this.getOwners("k" + i)[0].put((Object)("k" + i), (Object)("value" + i));
        }
        for (i = 0; i < 5; ++i) {
            this.assertOnAllCachesAndOwnership("k" + i, "value" + i);
        }
        for (Cache c : this.caches) {
            AssertJUnit.assertFalse((boolean)c.isEmpty());
            DummyInMemoryStore store = (DummyInMemoryStore)TestingUtil.getFirstStore(c);
            for (int i2 = 0; i2 < 5; ++i2) {
                String key = "k" + i2;
                if (!this.isOwner(c, key)) continue;
                AssertJUnit.assertTrue((String)("Cache store " + String.valueOf(c) + " does not contain key " + key), (boolean)store.contains(key));
            }
        }
    }
}

