/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.Collection;
import java.util.Collections;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.InvalidationNoReplicationTest")
public class InvalidationNoReplicationTest
extends MultipleCacheManagersTest {
    protected Object k0;

    public InvalidationNoReplicationTest() {
        this.transactional = true;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder config = InvalidationNoReplicationTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, this.transactional);
        config.clustering().l1().enable().hash().numOwners(1);
        this.createCluster(TestDataSCI.INSTANCE, config, 2);
        this.waitForClusterToForm();
        this.k0 = this.getKeyForCache(0);
    }

    public void testInvalidation() throws Exception {
        Assert.assertEquals(Collections.singletonList(this.address(0)), (Collection)this.cacheTopology(0).getDistribution(this.k0).writeOwners());
        Assert.assertEquals(Collections.singletonList(this.address(0)), (Collection)this.cacheTopology(1).getDistribution(this.k0).writeOwners());
        this.advancedCache(1).put(this.k0, (Object)"k1");
        Assert.assertTrue((boolean)this.advancedCache(1).getDataContainer().containsKey(this.k0));
        Assert.assertTrue((boolean)this.advancedCache(0).getDataContainer().containsKey(this.k0));
        this.tm(0).begin();
        this.cache(0).put(this.k0, (Object)"v2");
        this.tm(0).commit();
        Assert.assertFalse((boolean)this.advancedCache(1).getDataContainer().containsKey(this.k0));
    }
}

