/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import org.infinispan.distribution.TestAddress;
import org.infinispan.remoting.transport.TopologyAwareAddress;

public class TestTopologyAwareAddress
extends TestAddress
implements TopologyAwareAddress {
    String siteId;
    String rackId;
    String machineId;

    public TestTopologyAwareAddress(int addressNum, String siteId, String rackId, String machineId) {
        super(addressNum);
        this.siteId = siteId;
        this.rackId = rackId;
        this.machineId = machineId;
    }

    public TestTopologyAwareAddress(int addressNum) {
        this(addressNum, null, null, null);
    }

    @Override
    public String toString() {
        return super.toString() + "|" + this.machineId + "|" + this.rackId + "|" + this.siteId;
    }

    public boolean isSameSite(TopologyAwareAddress addr) {
        return this.siteId != null ? this.siteId.equals(addr.getSiteId()) : addr.getSiteId() == null;
    }

    public boolean isSameRack(TopologyAwareAddress addr) {
        if (!this.isSameSite(addr)) {
            return false;
        }
        return this.rackId != null ? this.rackId.equals(addr.getRackId()) : addr.getRackId() == null;
    }

    public boolean isSameMachine(TopologyAwareAddress addr) {
        if (!this.isSameSite(addr) || !this.isSameRack(addr)) {
            return false;
        }
        return this.machineId != null ? this.machineId.equals(addr.getMachineId()) : addr.getMachineId() == null;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    public String getRackId() {
        return this.rackId;
    }

    public void setRackId(String rackId) {
        this.rackId = rackId;
    }

    public String getMachineId() {
        return this.machineId;
    }

    public void setMachineId(String machineId) {
        this.machineId = machineId;
    }
}

