/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.util.Arrays;
import java.util.List;
import org.infinispan.distribution.TestAddress;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.impl.OwnershipStatistics;
import org.infinispan.distribution.ch.impl.ReplicatedConsistentHash;
import org.infinispan.distribution.ch.impl.ReplicatedConsistentHashFactory;
import org.infinispan.remoting.transport.Address;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="distribution.ch.ReplicatedConsistentHashFactoryTest")
public class ReplicatedConsistentHashFactoryTest {
    public void test1() {
        int[] testSegments = new int[]{1, 2, 4, 8, 16, 31, 32, 33, 67, 128};
        ReplicatedConsistentHashFactory factory = new ReplicatedConsistentHashFactory();
        TestAddress A2 = new TestAddress(0, "A");
        TestAddress B2 = new TestAddress(1, "B");
        TestAddress C2 = new TestAddress(2, "C");
        TestAddress D4 = new TestAddress(3, "D");
        List<Address> a = Arrays.asList(A2);
        List<Address> ab = Arrays.asList(A2, B2);
        List<Address> abc = Arrays.asList(A2, B2, C2);
        List<Address> abcd = Arrays.asList(A2, B2, C2, D4);
        List<Address> bcd = Arrays.asList(B2, C2, D4);
        List<Address> c = Arrays.asList(C2);
        for (int segments : testSegments) {
            ReplicatedConsistentHash ch = factory.create(0, segments, a, null);
            this.checkDistribution(ch);
            ch = factory.updateMembers(ch, ab, null);
            ch = factory.rebalance(ch);
            this.checkDistribution(ch);
            ch = factory.updateMembers(ch, abc, null);
            ch = factory.rebalance(ch);
            this.checkDistribution(ch);
            ch = factory.updateMembers(ch, abcd, null);
            ch = factory.rebalance(ch);
            this.checkDistribution(ch);
            ch = factory.updateMembers(ch, bcd, null);
            ch = factory.rebalance(ch);
            this.checkDistribution(ch);
            ch = factory.updateMembers(ch, c, null);
            ch = factory.rebalance(ch);
            this.checkDistribution(ch);
        }
    }

    private void checkDistribution(ReplicatedConsistentHash ch) {
        int minSegments = Integer.MAX_VALUE;
        int maxSegments = Integer.MIN_VALUE;
        OwnershipStatistics stats = new OwnershipStatistics((ConsistentHash)ch, ch.getMembers());
        for (Address member : ch.getMembers()) {
            int primary = stats.getPrimaryOwned(member);
            minSegments = Math.min(minSegments, primary);
            maxSegments = Math.max(maxSegments, primary);
            Assert.assertEquals((int)stats.getOwned(member), (int)ch.getNumSegments());
        }
        Assert.assertTrue((maxSegments - minSegments <= 1 ? 1 : 0) != 0);
    }
}

