/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.groups;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.distribution.groups.BaseUtilGroupTest;
import org.infinispan.distribution.groups.GetGroupKeysTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.groups.TransactionalGetGroupKeysTest")
public class TransactionalGetGroupKeysTest
extends GetGroupKeysTest {
    @Override
    public Object[] factory() {
        return new Object[]{new TransactionalGetGroupKeysTest(BaseUtilGroupTest.TestCacheFactory.PRIMARY_OWNER).isolationLevel(IsolationLevel.READ_COMMITTED), new TransactionalGetGroupKeysTest(BaseUtilGroupTest.TestCacheFactory.BACKUP_OWNER).isolationLevel(IsolationLevel.READ_COMMITTED), new TransactionalGetGroupKeysTest(BaseUtilGroupTest.TestCacheFactory.NON_OWNER).isolationLevel(IsolationLevel.READ_COMMITTED)};
    }

    public TransactionalGetGroupKeysTest() {
        this(null);
    }

    protected TransactionalGetGroupKeysTest(BaseUtilGroupTest.TestCacheFactory factory) {
        super(true, factory);
    }

    public void testGetGroupsInTransaction() throws SystemException, NotSupportedException, HeuristicRollbackException, HeuristicMixedException, RollbackException {
        BaseUtilGroupTest.TestCache testCache = this.createTestCacheAndReset("test-group", this.caches());
        TransactionalGetGroupKeysTest.initCache(testCache.primaryOwner);
        Map<BaseUtilGroupTest.GroupKey, String> expectedGroupSet = TransactionalGetGroupKeysTest.createMap(0, 12);
        TransactionManager tm = this.tm((Cache<?, ?>)testCache.testCache);
        tm.begin();
        testCache.testCache.put((Object)TransactionalGetGroupKeysTest.key(10), (Object)TransactionalGetGroupKeysTest.value(10));
        testCache.testCache.put((Object)TransactionalGetGroupKeysTest.key(11), (Object)TransactionalGetGroupKeysTest.value(11));
        AssertJUnit.assertEquals(expectedGroupSet, (Object)testCache.testCache.getGroup("test-group"));
        tm.commit();
        AssertJUnit.assertEquals(TransactionalGetGroupKeysTest.createMap(0, 12), (Object)testCache.testCache.getGroup("test-group"));
    }

    public void testGetGroupsWithConcurrentPut() throws Exception {
        BaseUtilGroupTest.TestCache testCache = this.createTestCacheAndReset("test-group", this.caches());
        TransactionalGetGroupKeysTest.initCache(testCache.primaryOwner);
        Map<BaseUtilGroupTest.GroupKey, String> expectedGroupSet = TransactionalGetGroupKeysTest.createMap(0, 12);
        TransactionManager tm = this.tm((Cache<?, ?>)testCache.testCache);
        tm.begin();
        testCache.testCache.put((Object)TransactionalGetGroupKeysTest.key(10), (Object)TransactionalGetGroupKeysTest.value(10));
        testCache.testCache.put((Object)TransactionalGetGroupKeysTest.key(11), (Object)TransactionalGetGroupKeysTest.value(11));
        AssertJUnit.assertEquals(expectedGroupSet, (Object)testCache.testCache.getGroup("test-group"));
        Transaction tx = tm.suspend();
        testCache.primaryOwner.put((Object)TransactionalGetGroupKeysTest.key(12), (Object)TransactionalGetGroupKeysTest.value(12));
        expectedGroupSet.put(TransactionalGetGroupKeysTest.key(12), TransactionalGetGroupKeysTest.value(12));
        tm.resume(tx);
        AssertJUnit.assertEquals(expectedGroupSet, (Object)testCache.testCache.getGroup("test-group"));
        tm.commit();
        AssertJUnit.assertEquals(expectedGroupSet, (Object)testCache.testCache.getGroup("test-group"));
    }

    public void testGetGroupsWithConcurrentRemove() throws Exception {
        BaseUtilGroupTest.TestCache testCache = this.createTestCacheAndReset("test-group", this.caches());
        TransactionalGetGroupKeysTest.initCache(testCache.primaryOwner);
        Map<BaseUtilGroupTest.GroupKey, String> expectedGroupSet = TransactionalGetGroupKeysTest.createMap(0, 12);
        TransactionManager tm = this.tm((Cache<?, ?>)testCache.testCache);
        tm.begin();
        testCache.testCache.put((Object)TransactionalGetGroupKeysTest.key(10), (Object)TransactionalGetGroupKeysTest.value(10));
        testCache.testCache.put((Object)TransactionalGetGroupKeysTest.key(11), (Object)TransactionalGetGroupKeysTest.value(11));
        AssertJUnit.assertEquals(expectedGroupSet, (Object)testCache.testCache.getGroup("test-group"));
        Transaction tx = tm.suspend();
        testCache.primaryOwner.remove((Object)TransactionalGetGroupKeysTest.key(1));
        tm.resume(tx);
        AssertJUnit.assertEquals(expectedGroupSet, (Object)testCache.testCache.getGroup("test-group"));
        tm.commit();
        expectedGroupSet.remove(TransactionalGetGroupKeysTest.key(1));
        AssertJUnit.assertEquals(expectedGroupSet, (Object)testCache.testCache.getGroup("test-group"));
    }

    public void testGetGroupsWithConcurrentReplace() throws Exception {
        BaseUtilGroupTest.TestCache testCache = this.createTestCacheAndReset("test-group", this.caches());
        TransactionalGetGroupKeysTest.initCache(testCache.primaryOwner);
        Map<BaseUtilGroupTest.GroupKey, String> expectedGroupSet = TransactionalGetGroupKeysTest.createMap(0, 12);
        TransactionManager tm = this.tm((Cache<?, ?>)testCache.testCache);
        tm.begin();
        testCache.testCache.put((Object)TransactionalGetGroupKeysTest.key(10), (Object)TransactionalGetGroupKeysTest.value(10));
        testCache.testCache.put((Object)TransactionalGetGroupKeysTest.key(11), (Object)TransactionalGetGroupKeysTest.value(11));
        AssertJUnit.assertEquals(expectedGroupSet, (Object)testCache.testCache.getGroup("test-group"));
        Transaction tx = tm.suspend();
        testCache.primaryOwner.put((Object)TransactionalGetGroupKeysTest.key(1), (Object)TransactionalGetGroupKeysTest.value(-1));
        if (this.isolationLevel == IsolationLevel.READ_COMMITTED && this.factory != BaseUtilGroupTest.TestCacheFactory.NON_OWNER) {
            expectedGroupSet.put(TransactionalGetGroupKeysTest.key(1), TransactionalGetGroupKeysTest.value(-1));
        }
        tm.resume(tx);
        AssertJUnit.assertEquals(expectedGroupSet, (Object)testCache.testCache.getGroup("test-group"));
        tm.commit();
        expectedGroupSet.put(TransactionalGetGroupKeysTest.key(1), TransactionalGetGroupKeysTest.value(-1));
        AssertJUnit.assertEquals(expectedGroupSet, (Object)testCache.testCache.getGroup("test-group"));
    }

    @Override
    protected ConfigurationBuilder amendConfiguration(ConfigurationBuilder builder) {
        super.amendConfiguration(builder);
        builder.locking().isolationLevel(this.isolationLevel);
        builder.transaction().recovery().disable();
        return builder;
    }
}

