/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.util.concurrent.locks.LockManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional", "unstable"}, testName="distribution.rehash.NonTxPutIfAbsentDuringJoinStressTest")
@CleanupAfterMethod
public class NonTxPutIfAbsentDuringJoinStressTest
extends MultipleCacheManagersTest {
    private static final int NUM_WRITERS = 4;
    private static final int NUM_ORIGINATORS = 2;
    private static final int NUM_KEYS = 100;
    private final ConcurrentMap<String, String> insertedValues = new ConcurrentHashMap<String, String>();
    private volatile boolean stop = false;

    @Override
    public Object[] factory() {
        return new Object[]{new NonTxPutIfAbsentDuringJoinStressTest().cacheMode(CacheMode.DIST_SYNC)};
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder c = this.getConfigurationBuilder();
        this.addClusterEnabledCacheManager(c);
        this.addClusterEnabledCacheManager(c);
        this.waitForClusterToForm();
    }

    private ConfigurationBuilder getConfigurationBuilder() {
        return NonTxPutIfAbsentDuringJoinStressTest.getDefaultClusteredCacheConfig(this.cacheMode, false);
    }

    public void testNodeJoiningDuringPutIfAbsent() throws Exception {
        String key;
        int i;
        Future[] futures = new Future[4];
        for (i = 0; i < 4; ++i) {
            int writerIndex = i;
            futures[i] = this.fork(() -> {
                while (!this.stop) {
                    for (int j = 0; j < 100; ++j) {
                        Cache cache = this.cache(writerIndex % 2);
                        String key = "key_" + j;
                        String value = "value_" + j + "_" + writerIndex;
                        Object oldValue = cache.putIfAbsent((Object)key, (Object)value);
                        Object newValue = cache.get((Object)key);
                        if (oldValue == null) {
                            log.tracef("Successfully inserted value %s for key %s", (Object)value, (Object)key);
                            AssertJUnit.assertEquals((Object)value, (Object)newValue);
                            boolean isFirst = this.insertedValues.putIfAbsent(key, value) == null;
                            AssertJUnit.assertTrue((String)("A second putIfAbsent succeeded for " + key), (boolean)isFirst);
                            continue;
                        }
                        AssertJUnit.assertEquals((Object)oldValue, (Object)newValue);
                    }
                }
            });
        }
        this.addClusterEnabledCacheManager(this.getConfigurationBuilder());
        this.waitForClusterToForm();
        this.addClusterEnabledCacheManager(this.getConfigurationBuilder());
        this.waitForClusterToForm();
        this.stop = true;
        for (i = 0; i < 4; ++i) {
            futures[i].get(10L, TimeUnit.SECONDS);
            for (int j = 0; j < 100; ++j) {
                for (int k = 0; k < this.caches().size(); ++k) {
                    key = "key_" + j;
                    AssertJUnit.assertEquals(this.insertedValues.get(key), (Object)this.cache(k).get((Object)key));
                }
            }
        }
        for (i = 0; i < this.caches().size(); ++i) {
            LockManager lockManager = this.advancedCache(i).getLockManager();
            AssertJUnit.assertEquals((int)0, (int)lockManager.getNumberOfLocksHeld());
            for (int j = 0; j < 100; ++j) {
                key = "key_" + j;
                AssertJUnit.assertFalse((boolean)lockManager.isLocked((Object)key));
            }
        }
    }
}

