/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.topologyaware;

import java.util.List;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterTest;
import org.infinispan.test.fwk.InCacheMode;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.topologyaware.TopologyAwareStateTransferTest")
@CleanupAfterTest
@InCacheMode(value={CacheMode.DIST_SYNC})
public class TopologyAwareStateTransferTest
extends MultipleCacheManagersTest {
    private Address[] addresses;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder defaultConfig = TopologyAwareStateTransferTest.getDefaultClusteredCacheConfig(this.cacheMode);
        log.debug((Object)("defaultConfig = " + defaultConfig.build().clustering().hash().numOwners()));
        defaultConfig.clustering().l1().disable().stateTransfer().fetchInMemoryState(true);
        this.createClusteredCaches(5, defaultConfig);
        ConsistentHash hash = this.cache(0).getAdvancedCache().getDistributionManager().getWriteConsistentHash();
        List members = hash.getMembers();
        this.addresses = members.toArray(new Address[members.size()]);
    }

    @Override
    @AfterMethod
    protected void clearContent() throws Throwable {
    }

    Cache<?, ?> cache(Address addr) {
        for (Cache c : this.caches()) {
            if (!c.getAdvancedCache().getRpcManager().getAddress().equals((Object)addr)) continue;
            return c;
        }
        throw new RuntimeException("Address: " + String.valueOf(addr));
    }

    public void test() {
        this.cache(0).put((Object)this.addresses[0], (Object)"v0");
        this.cache(0).put((Object)this.addresses[1], (Object)"v1");
        this.cache(0).put((Object)this.addresses[2], (Object)"v2");
        this.cache(0).put((Object)this.addresses[3], (Object)"v3");
        this.cache(0).put((Object)this.addresses[4], (Object)"v4");
        log.debugf("Cache on node %s: %s", (Object)this.addresses[0], (Object)TestingUtil.printCache(this.cache(this.addresses[0])));
        log.debugf("Cache on node %s: %s", (Object)this.addresses[1], (Object)TestingUtil.printCache(this.cache(this.addresses[1])));
        log.debugf("Cache on node %s: %s", (Object)this.addresses[2], (Object)TestingUtil.printCache(this.cache(this.addresses[2])));
        log.debugf("Cache on node %s: %s", (Object)this.addresses[3], (Object)TestingUtil.printCache(this.cache(this.addresses[3])));
        this.assertExistence(this.addresses[0]);
        this.assertExistence(this.addresses[1]);
        this.assertExistence(this.addresses[2]);
        this.assertExistence(this.addresses[3]);
        this.assertExistence(this.addresses[4]);
        EmbeddedCacheManager cm4 = this.cache(this.addresses[4]).getCacheManager();
        log.info((Object)"Here is where ST starts");
        TestingUtil.killCacheManagers(cm4);
        this.cacheManagers.remove(cm4);
        TestingUtil.blockUntilViewsReceived(60000, false, this.caches());
        TestingUtil.waitForNoRebalance(this.caches());
        log.info((Object)"Here is where ST ends");
        List addressList = this.cache(this.addresses[0]).getAdvancedCache().getDistributionManager().getWriteConsistentHash().getMembers();
        log.debug((Object)("After shutting down " + String.valueOf(this.addresses[4]) + " caches are " + String.valueOf(addressList)));
        log.debugf("Cache on node %s: %s", (Object)this.addresses[0], (Object)TestingUtil.printCache(this.cache(this.addresses[0])));
        log.debugf("Cache on node %s: %s", (Object)this.addresses[1], (Object)TestingUtil.printCache(this.cache(this.addresses[1])));
        log.debugf("Cache on node %s: %s", (Object)this.addresses[2], (Object)TestingUtil.printCache(this.cache(this.addresses[2])));
        log.debugf("Cache on node %s: %s", (Object)this.addresses[3], (Object)TestingUtil.printCache(this.cache(this.addresses[3])));
        this.assertExistence(this.addresses[0]);
        this.assertExistence(this.addresses[1]);
        this.assertExistence(this.addresses[2]);
        this.assertExistence(this.addresses[3]);
        this.assertExistence(this.addresses[4]);
        EmbeddedCacheManager cm2 = this.cache(this.addresses[2]).getCacheManager();
        TestingUtil.killCacheManagers(cm2);
        this.cacheManagers.remove(cm2);
        TestingUtil.blockUntilViewsReceived(60000, false, this.caches());
        TestingUtil.waitForNoRebalance(this.caches());
        addressList = this.cache(this.addresses[0]).getAdvancedCache().getDistributionManager().getWriteConsistentHash().getMembers();
        log.debug((Object)("After shutting down " + String.valueOf(this.addresses[2]) + " caches are " + String.valueOf(addressList)));
        log.debugf("Cache on node %s: %s", (Object)this.addresses[0], (Object)TestingUtil.printCache(this.cache(this.addresses[0])));
        log.debugf("Cache on node %s: %s", (Object)this.addresses[1], (Object)TestingUtil.printCache(this.cache(this.addresses[1])));
        log.debugf("Cache on node %s: %s", (Object)this.addresses[3], (Object)TestingUtil.printCache(this.cache(this.addresses[3])));
        this.assertExistence(this.addresses[0]);
        this.assertExistence(this.addresses[1]);
        this.assertExistence(this.addresses[2]);
        this.assertExistence(this.addresses[3]);
        this.assertExistence(this.addresses[4]);
        EmbeddedCacheManager cm1 = this.cache(this.addresses[1]).getCacheManager();
        TestingUtil.killCacheManagers(cm1);
        this.cacheManagers.remove(cm1);
        TestingUtil.blockUntilViewsReceived(60000, false, this.caches());
        TestingUtil.waitForNoRebalance(this.caches());
        addressList = this.cache(this.addresses[0]).getAdvancedCache().getDistributionManager().getWriteConsistentHash().getMembers();
        log.debug((Object)("After shutting down " + String.valueOf(this.addresses[1]) + " caches are " + String.valueOf(addressList)));
        log.debugf("Cache on node %s: %s", (Object)this.addresses[0], (Object)TestingUtil.printCache(this.cache(this.addresses[0])));
        log.debugf("Cache on node %s: %s", (Object)this.addresses[3], (Object)TestingUtil.printCache(this.cache(this.addresses[3])));
        this.assertExistence(this.addresses[0]);
        this.assertExistence(this.addresses[1]);
        this.assertExistence(this.addresses[2]);
        this.assertExistence(this.addresses[3]);
        this.assertExistence(this.addresses[4]);
    }

    private <K> void assertExistence(K key) {
        LocalizedCacheTopology cacheTopology = this.cache(this.addresses[0]).getAdvancedCache().getDistributionManager().getCacheTopology();
        List addresses = cacheTopology.getDistribution(key).writeOwners();
        log.debug((Object)(String.valueOf(key) + " should be present on = " + String.valueOf(addresses)));
        this.eventuallyEquals(2, () -> this.caches().stream().mapToInt(c -> c.getAdvancedCache().getDataContainer().containsKey(key) ? 1 : 0).sum());
        for (Cache c : this.caches()) {
            TopologyAwareStateTransferTest.eventuallyEquals("Failure for key " + String.valueOf(key) + " on cache " + String.valueOf(this.address(c)), addresses.contains(this.address(c)), () -> c.getAdvancedCache().getDataContainer().containsKey(key));
        }
    }

    @Override
    protected EmbeddedCacheManager addClusterEnabledCacheManager(ConfigurationBuilder deConfiguration) {
        String rack;
        int index = this.cacheManagers.size();
        String machine = switch (index) {
            case 0 -> {
                rack = "r0";
                yield "m0";
            }
            case 1 -> {
                rack = "r0";
                yield "m1";
            }
            case 2 -> {
                rack = "r1";
                yield "m0";
            }
            case 3 -> {
                rack = "r2";
                yield "m0";
            }
            case 4 -> {
                rack = "r2";
                yield "m0";
            }
            default -> throw new RuntimeException("Bad!");
        };
        GlobalConfigurationBuilder gcb = GlobalConfigurationBuilder.defaultClusteredBuilder();
        gcb.transport().rackId(rack).machineId(machine);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager(gcb, deConfiguration);
        this.cacheManagers.add(cm);
        return cm;
    }
}

