/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.encoding.impl;

import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.encoding.impl.StorageConfigurationManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="encoding.impl.StorageConfigurationManagerTest")
public class StorageConfigurationManagerTest
extends SingleCacheManagerTest {
    public static final String CACHE_NAME = "testCache";

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager();
    }

    public static long wallClockTime() {
        return TIME_SERVICE.wallClockTime();
    }

    public static long time() {
        return TIME_SERVICE.time();
    }

    public static Instant instant() {
        return TIME_SERVICE.instant();
    }

    public static long timeDuration(long startTimeNanos, TimeUnit outputTimeUnit) {
        return TIME_SERVICE.timeDuration(startTimeNanos, outputTimeUnit);
    }

    public static long timeDuration(long startTimeNanos, long endTimeNanos, TimeUnit outputTimeUnit) {
        return TIME_SERVICE.timeDuration(startTimeNanos, endTimeNanos, outputTimeUnit);
    }

    public static boolean isTimeExpired(long endTimeNanos) {
        return TIME_SERVICE.isTimeExpired(endTimeNanos);
    }

    public static long remainingTime(long endTimeNanos, TimeUnit outputTimeUnit) {
        return TIME_SERVICE.remainingTime(endTimeNanos, outputTimeUnit);
    }

    public static long expectedEndTime(long duration, TimeUnit inputTimeUnit) {
        return TIME_SERVICE.expectedEndTime(duration, inputTimeUnit);
    }

    public void testDefaultMediaType() {
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        this.assertStorageMediaTypes(configurationBuilder, StorageType.HEAP, StorageType.HEAP, MediaType.APPLICATION_OBJECT);
        configurationBuilder = new ConfigurationBuilder();
        configurationBuilder.memory().storage(StorageType.HEAP);
        this.assertStorageMediaTypes(configurationBuilder, StorageType.HEAP, StorageType.HEAP, MediaType.APPLICATION_OBJECT);
        configurationBuilder = new ConfigurationBuilder();
        configurationBuilder.memory().storageType(StorageType.HEAP);
        this.assertStorageMediaTypes(configurationBuilder, StorageType.HEAP, StorageType.HEAP, MediaType.APPLICATION_OBJECT);
        configurationBuilder = new ConfigurationBuilder();
        configurationBuilder.memory().storage(StorageType.OBJECT);
        this.assertStorageMediaTypes(configurationBuilder, StorageType.OBJECT, StorageType.OBJECT, MediaType.APPLICATION_OBJECT);
        configurationBuilder = new ConfigurationBuilder();
        configurationBuilder.memory().storageType(StorageType.OBJECT);
        this.assertStorageMediaTypes(configurationBuilder, StorageType.OBJECT, StorageType.OBJECT, MediaType.APPLICATION_OBJECT);
        configurationBuilder = new ConfigurationBuilder();
        configurationBuilder.memory().storageType(StorageType.BINARY);
        this.assertStorageMediaTypes(configurationBuilder, StorageType.BINARY, StorageType.BINARY, MediaType.APPLICATION_PROTOSTREAM);
        configurationBuilder = new ConfigurationBuilder();
        configurationBuilder.memory().storageType(StorageType.BINARY);
        this.assertStorageMediaTypes(configurationBuilder, StorageType.BINARY, StorageType.BINARY, MediaType.APPLICATION_PROTOSTREAM);
        configurationBuilder = new ConfigurationBuilder();
        configurationBuilder.memory().storageType(StorageType.OFF_HEAP);
        this.assertStorageMediaTypes(configurationBuilder, StorageType.OFF_HEAP, StorageType.OFF_HEAP, MediaType.APPLICATION_PROTOSTREAM);
        configurationBuilder = new ConfigurationBuilder();
        configurationBuilder.memory().storageType(StorageType.OFF_HEAP);
        this.assertStorageMediaTypes(configurationBuilder, StorageType.OFF_HEAP, StorageType.OFF_HEAP, MediaType.APPLICATION_PROTOSTREAM);
    }

    private void assertStorageMediaTypes(ConfigurationBuilder configurationBuilder, StorageType storage, StorageType storageType, MediaType mediaType) {
        this.cacheManager.defineConfiguration(CACHE_NAME, configurationBuilder.build());
        Cache cache = this.cacheManager.getCache(CACHE_NAME);
        Configuration cacheConfiguration = cache.getCacheConfiguration();
        AssertJUnit.assertEquals((String)"Wrong storage", (Object)storage, (Object)cacheConfiguration.memory().storage());
        AssertJUnit.assertEquals((String)"Wrong storageType", (Object)storageType, (Object)cacheConfiguration.memory().storageType());
        AssertJUnit.assertEquals((String)"Wrong heapConfiguration.storageType", (Object)storageType, (Object)cacheConfiguration.memory().heapConfiguration().storageType());
        StorageConfigurationManager scm = TestingUtil.extractComponent(cache, StorageConfigurationManager.class);
        AssertJUnit.assertEquals((String)"Wrong key media type", (Object)mediaType, (Object)scm.getKeyStorageMediaType());
        AssertJUnit.assertEquals((String)"Wrong value media type", (Object)mediaType, (Object)scm.getValueStorageMediaType());
        this.cacheManager.administration().removeCache(CACHE_NAME);
    }
}

