/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction.impl;

import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.eviction.impl.EvictionWithConcurrentOperationsSCIImpl;
import org.infinispan.eviction.impl.PassivationManager;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.impl.CacheLoaderInterceptor;
import org.infinispan.interceptors.impl.EntryWrappingInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntriesEvicted;
import org.infinispan.notifications.cachelistener.event.CacheEntriesEvictedEvent;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.support.WaitDelegatingNonBlockingStore;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.Mocks;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CheckPoint;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.DataOperationOrderer;
import org.mockito.ArgumentMatchers;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="eviction.EvictionWithConcurrentOperationsTest")
public class EvictionWithConcurrentOperationsTest
extends SingleCacheManagerTest {
    protected boolean passivation = false;
    protected final AtomicInteger storeNamePrefix = new AtomicInteger(0);
    public final String storeName = this.getClass().getSimpleName();
    protected final String persistentLocation = CommonsTestingUtil.tmpDirectory(this.getClass());

    public EvictionWithConcurrentOperationsTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScenario1() throws Exception {
        Future<Object> put;
        SameHashCodeKey key1 = new SameHashCodeKey("key1");
        this.initializeKeyAndCheckData(key1, "v1");
        SameHashCodeKey key2 = new SameHashCodeKey("key2");
        Latch latch = new Latch();
        ControlledPassivationManager controlledPassivationManager = this.replacePassivationManager(latch);
        latch.enable();
        try {
            put = this.fork(() -> this.cache.put(key2, (Object)"v2"));
            latch.waitToBlock(30L, TimeUnit.SECONDS);
            AssertJUnit.assertEquals((String)("Wrong value for key " + String.valueOf(key1) + " in get operation."), (Object)"v1", (Object)this.cache.get((Object)key1));
        }
        finally {
            latch.disable();
        }
        put.get(30L, TimeUnit.SECONDS);
        this.assertInMemory(key2, "v2");
        this.assertNotInMemory(key1, "v1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScenario2() throws Exception {
        Future<Object> put;
        SameHashCodeKey key1 = new SameHashCodeKey("key1");
        this.initializeKeyAndCheckData(key1, "v1");
        SameHashCodeKey key2 = new SameHashCodeKey("key2");
        Latch latch = new Latch();
        ControlledPassivationManager controlledPassivationManager = this.replacePassivationManager(latch);
        latch.enable();
        try {
            put = this.fork(() -> this.cache.put(key2, (Object)"v2"));
            latch.waitToBlock(30L, TimeUnit.SECONDS);
            AssertJUnit.assertEquals((String)("Wrong value for key " + String.valueOf(key1) + " in get operation."), (Object)"v1", (Object)this.cache.get((Object)key1));
        }
        finally {
            latch.disable();
        }
        put.get(30L, TimeUnit.SECONDS);
        this.assertInMemory(key2, "v2");
        this.assertNotInMemory(key1, "v1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScenario3() throws Exception {
        Future<Object> put;
        final SameHashCodeKey key1 = new SameHashCodeKey("key1");
        this.initializeKeyAndCheckData(key1, "v1");
        SameHashCodeKey key2 = new SameHashCodeKey("key2");
        final Latch latch = new Latch();
        SyncEvictionListener evictionListener = new SyncEvictionListener(){

            @Override
            @CacheEntriesEvicted
            public void evicted(CacheEntriesEvictedEvent event) {
                if (event.getEntries().containsKey(key1)) {
                    latch.blockIfNeeded();
                }
            }
        };
        this.cache.addListener((Object)evictionListener);
        latch.enable();
        try {
            put = this.fork(() -> this.cache.put(key2, (Object)"v2"));
            latch.waitToBlock(30L, TimeUnit.SECONDS);
        }
        finally {
            latch.disable();
        }
        put.get(30L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((String)("Wrong value for key " + String.valueOf(key1) + " in get operation."), (Object)"v1", (Object)this.cache.get((Object)key1));
        this.assertInMemory(key1, "v1");
        this.assertNotInMemory(key2, "v2");
    }

    public void testScenario4() throws Exception {
        final SameHashCodeKey key1 = new SameHashCodeKey("key1");
        this.initializeKeyAndCheckData(key1, "v1");
        SameHashCodeKey key2 = new SameHashCodeKey("key2");
        Latch readLatch = new Latch();
        final Latch writeLatch = new Latch();
        AtomicBoolean firstGet = new AtomicBoolean(false);
        AfterEntryWrappingInterceptor afterEntryWrappingInterceptor = new AfterEntryWrappingInterceptor().injectThis((Cache<Object, Object>)this.cache);
        afterEntryWrappingInterceptor.beforeGet = () -> {
            if (firstGet.compareAndSet(false, true)) {
                readLatch.blockIfNeeded();
            }
        };
        SyncEvictionListener evictionListener = new SyncEvictionListener(){

            @Override
            @CacheEntriesEvicted
            public void evicted(CacheEntriesEvictedEvent event) {
                if (event.getEntries().containsKey(key1)) {
                    writeLatch.blockIfNeeded();
                }
            }
        };
        this.cache.addListener((Object)evictionListener);
        readLatch.enable();
        Future<Object> put = this.fork(() -> this.cache.put(key2, (Object)"v2"));
        writeLatch.waitToBlock(30L, TimeUnit.SECONDS);
        Future<Object> get = this.fork(() -> this.cache.get(key1));
        readLatch.waitToBlock(30L, TimeUnit.SECONDS);
        put.get(30L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((String)("Wrong value for key " + String.valueOf(key1) + " in get operation."), (Object)"v1", (Object)this.cache.get((Object)key1));
        readLatch.disable();
        AssertJUnit.assertEquals((String)("Wrong value for key " + String.valueOf(key1) + " in get operation."), (Object)"v1", (Object)get.get());
        this.assertInMemory(key1, "v1");
        this.assertNotInMemory(key2, "v2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScenario5() throws Exception {
        Future<Object> get;
        final SameHashCodeKey key1 = new SameHashCodeKey("key1");
        this.initializeKeyAndCheckData(key1, "v1");
        SameHashCodeKey key2 = new SameHashCodeKey("key2");
        Latch readLatch = new Latch();
        final Latch writeLatch = new Latch();
        AfterEntryWrappingInterceptor afterEntryWrappingInterceptor = new AfterEntryWrappingInterceptor().injectThis((Cache<Object, Object>)this.cache);
        afterEntryWrappingInterceptor.beforeGet = () -> readLatch.blockIfNeeded();
        SyncEvictionListener evictionListener = new SyncEvictionListener(){

            @Override
            @CacheEntriesEvicted
            public void evicted(CacheEntriesEvictedEvent event) {
                if (event.getEntries().containsKey(key1)) {
                    writeLatch.blockIfNeeded();
                }
            }
        };
        this.cache.addListener((Object)evictionListener);
        readLatch.enable();
        try {
            this.cache.put((Object)key2, (Object)"v2");
            writeLatch.waitToBlock(30L, TimeUnit.SECONDS);
            get = this.fork(() -> this.cache.get(key1));
            readLatch.waitToBlock(30L, TimeUnit.SECONDS);
            AssertJUnit.assertEquals((String)("Wrong value for key " + String.valueOf(key1) + " in get operation."), (Object)"v1", (Object)this.cache.put((Object)key1, (Object)"v3"));
        }
        finally {
            readLatch.disable();
        }
        AssertJUnit.assertEquals((String)("Wrong value for key " + String.valueOf(key1) + " in get operation."), (Object)"v3", (Object)get.get(30L, TimeUnit.SECONDS));
        this.assertInMemory(key1, "v3");
        this.assertNotInMemory(key2, "v2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScenario6() throws Exception {
        CompletableFuture put2;
        Future<Object> get;
        final SameHashCodeKey key1 = new SameHashCodeKey("key1");
        this.initializeKeyAndCheckData(key1, "v1");
        SameHashCodeKey key2 = new SameHashCodeKey("key2");
        Latch readLatch = new Latch();
        final Latch writeLatch = new Latch();
        Latch writeLatch2 = new Latch();
        AtomicBoolean firstWriter = new AtomicBoolean(false);
        AfterEntryWrappingInterceptor afterEntryWrappingInterceptor = new AfterEntryWrappingInterceptor().injectThis((Cache<Object, Object>)this.cache);
        afterEntryWrappingInterceptor.beforeGet = () -> readLatch.blockIfNeeded();
        afterEntryWrappingInterceptor.afterPut = () -> {
            if (!firstWriter.compareAndSet(false, true)) {
                writeLatch2.blockIfNeeded();
            }
        };
        SyncEvictionListener evictionListener = new SyncEvictionListener(){

            @Override
            @CacheEntriesEvicted
            public void evicted(CacheEntriesEvictedEvent event) {
                if (event.getEntries().containsKey(key1)) {
                    writeLatch.blockIfNeeded();
                }
            }
        };
        this.cache.addListener((Object)evictionListener);
        readLatch.enable();
        try {
            Future<Object> put = this.fork(() -> this.cache.put(key2, (Object)"v2"));
            writeLatch.waitToBlock(30L, TimeUnit.SECONDS);
            get = this.fork(() -> this.cache.get(key1));
            readLatch.waitToBlock(30L, TimeUnit.SECONDS);
            put.get(30L, TimeUnit.SECONDS);
            put2 = this.cache.putAsync((Object)key1, (Object)"v3");
            writeLatch2.waitToBlock(30L, TimeUnit.SECONDS);
        }
        finally {
            readLatch.disable();
        }
        this.assertPossibleValues(key1, get.get(30L, TimeUnit.SECONDS), "v1", "v3");
        AssertJUnit.assertEquals((String)("Wrong value for key " + String.valueOf(key1) + " in put operation."), (Object)"v1", put2.get(30L, TimeUnit.SECONDS));
        this.assertInMemory(key1, "v3");
        this.assertNotInMemory(key2, "v2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScenario7() throws Exception {
        Future<Object> get;
        SameHashCodeKey key1 = new SameHashCodeKey("key1");
        this.initializeKeyAndCheckData(key1, "v1");
        Latch readLatch = new Latch();
        AfterActivationOrCacheLoader commandController = new AfterActivationOrCacheLoader().injectThis((Cache<Object, Object>)this.cache);
        commandController.afterGet = () -> readLatch.blockIfNeeded();
        this.cache.evict((Object)key1);
        this.assertNotInMemory(key1, "v1");
        readLatch.enable();
        try {
            get = this.fork(() -> this.cache.get(key1));
            readLatch.waitToBlock(30L, TimeUnit.SECONDS);
            AssertJUnit.assertEquals((String)("Wrong value for key " + String.valueOf(key1) + " in put operation."), (Object)"v1", (Object)this.cache.put((Object)key1, (Object)"v2"));
        }
        finally {
            readLatch.disable();
        }
        this.assertPossibleValues(key1, get.get(30L, TimeUnit.SECONDS), "v1");
        this.assertInMemory(key1, "v2");
    }

    public void testEvictionDuringWrite() throws InterruptedException, ExecutionException, TimeoutException {
        String key = "evicted-key";
        this.testEvictionDuring(key, () -> this.cache.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD).put((Object)key, (Object)"value"), AssertJUnit::assertNull, AssertJUnit::assertNotNull, true);
    }

    public void testEvictionDuringRemove() throws InterruptedException, ExecutionException, TimeoutException {
        String key = "evicted-key";
        this.cache.put((Object)key, (Object)"removed");
        this.testEvictionDuring(key, () -> this.cache.remove((Object)key), AssertJUnit::assertNotNull, AssertJUnit::assertNull, false);
    }

    void testEvictionDuring(String key, Callable<Object> callable, Consumer<Object> valueConsumer, Consumer<Object> finalResultConsumer, boolean blockOnCompletion) throws TimeoutException, InterruptedException, ExecutionException {
        CheckPoint operationCheckPoint = new CheckPoint("operation");
        operationCheckPoint.triggerForever(blockOnCompletion ? "after_release" : "before_release");
        DataOperationOrderer original = blockOnCompletion ? Mocks.blockingMock(operationCheckPoint, DataOperationOrderer.class, this.cache, (stub, m) -> ((DataOperationOrderer)stub.when(m)).completeOperation(ArgumentMatchers.eq((Object)key), (CompletableFuture)ArgumentMatchers.any(), (DataOperationOrderer.Operation)ArgumentMatchers.any()), new Class[0]) : Mocks.blockingMock(operationCheckPoint, DataOperationOrderer.class, this.cache, (stub, m) -> ((DataOperationOrderer)stub.when(m)).orderOn(ArgumentMatchers.eq((Object)key), (CompletionStage)ArgumentMatchers.any()), new Class[0]);
        Future<Object> operationFuture = this.fork(callable);
        operationCheckPoint.awaitStrict("before_invocation", 10L, TimeUnit.SECONDS);
        TestingUtil.replaceComponent(this.cache, DataOperationOrderer.class, original, true);
        CheckPoint evictionCheckPoint = new CheckPoint("eviction");
        evictionCheckPoint.triggerForever("before_release");
        Mocks.blockingMock(evictionCheckPoint, DataOperationOrderer.class, this.cache, (stub, m) -> ((DataOperationOrderer)stub.when(m)).orderOn(ArgumentMatchers.eq((Object)key), (CompletionStage)ArgumentMatchers.any()), new Class[0]);
        Future<Object> evictFuture = this.fork(() -> this.cache.put((Object)"other-key", (Object)"other-value"));
        evictionCheckPoint.awaitStrict("after_invocation", 10L, TimeUnit.SECONDS);
        operationCheckPoint.trigger(blockOnCompletion ? "before_release" : "after_release");
        if (!blockOnCompletion) {
            evictionCheckPoint.triggerForever("after_release");
        }
        valueConsumer.accept(operationFuture.get(10L, TimeUnit.SECONDS));
        evictionCheckPoint.triggerForever("after_release");
        evictFuture.get(10L, TimeUnit.SECONDS);
        finalResultConsumer.accept(this.cache.get((Object)key));
    }

    protected void initializeKeyAndCheckData(Object key, Object value) {
        AssertJUnit.assertTrue((String)"A cache store should be configured!", (boolean)this.cache.getCacheConfiguration().persistence().usingStores());
        this.cache.put(key, value);
        DataContainer container = this.cache.getAdvancedCache().getDataContainer();
        InternalCacheEntry entry = container.peek(key);
        AssertJUnit.assertNotNull((String)("Key " + String.valueOf(key) + " does not exist in data container."), (Object)entry);
        AssertJUnit.assertEquals((String)("Wrong value for key " + String.valueOf(key) + " in data container."), (Object)value, (Object)entry.getValue());
        WaitDelegatingNonBlockingStore loader = TestingUtil.getFirstStoreWait(this.cache);
        MarshallableEntry entryLoaded = loader.loadEntry(key);
        if (this.passivation) {
            AssertJUnit.assertNull(entryLoaded);
        } else {
            AssertJUnit.assertEquals((String)("Wrong value for key " + String.valueOf(key) + " in cache loader"), (Object)value, (Object)this.extractValue(entryLoaded));
        }
    }

    protected void assertInMemory(Object key, Object value) {
        DataContainer container = this.cache.getAdvancedCache().getDataContainer();
        InternalCacheEntry entry = container.get(key);
        AssertJUnit.assertNotNull((String)("Key " + String.valueOf(key) + " does not exist in data container"), (Object)entry);
        AssertJUnit.assertEquals((String)("Wrong value for key " + String.valueOf(key) + " in data container"), (Object)value, (Object)entry.getValue());
        WaitDelegatingNonBlockingStore loader = TestingUtil.getFirstStoreWait(this.cache);
        if (!this.passivation) {
            MarshallableEntry entryLoaded = loader.loadEntry(key);
            AssertJUnit.assertEquals((String)("Wrong value for key " + String.valueOf(key) + " in cache loader"), (Object)value, (Object)this.extractValue(entryLoaded));
        }
    }

    protected void assertNotInMemory(Object key, Object value) {
        DataContainer container = this.cache.getAdvancedCache().getDataContainer();
        InternalCacheEntry memoryEntry = container.peek(key);
        AssertJUnit.assertNull((String)("Key " + String.valueOf(key) + " exists in data container"), (Object)memoryEntry);
        WaitDelegatingNonBlockingStore loader = TestingUtil.getFirstStoreWait(this.cache);
        if (this.passivation) {
            PersistenceManager pm = TestingUtil.extractComponent(this.cache, PersistenceManager.class);
            MarshallableEntry entryLoaded = (MarshallableEntry)CompletionStages.join((CompletionStage)pm.loadFromAllStores(key, true, true));
            AssertJUnit.assertEquals((String)("Wrong value for key " + String.valueOf(key) + " in cache loader"), (Object)value, (Object)this.extractValue(entryLoaded));
            EvictionWithConcurrentOperationsTest.eventuallyEquals("Wrong value for key " + String.valueOf(key) + " in cache loader", value, () -> this.extractValue(loader.loadEntry(key)));
        } else {
            MarshallableEntry entryLoaded = loader.loadEntry(key);
            AssertJUnit.assertEquals((String)("Wrong value for key " + String.valueOf(key) + " in cache loader"), (Object)value, (Object)this.extractValue(entryLoaded));
        }
    }

    private Object extractValue(MarshallableEntry<?, ?> entry) {
        return entry != null ? entry.getValue() : null;
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = this.getDefaultStandaloneCacheConfig(false);
        this.configurePersistence(builder);
        this.configureEviction(builder);
        GlobalConfigurationBuilder globalBuilder = new GlobalConfigurationBuilder().nonClusteredDefault();
        globalBuilder.serialization().addContextInitializer((SerializationContextInitializer)new EvictionWithConcurrentOperationsSCIImpl());
        globalBuilder.globalState().enable().persistentLocation(this.persistentLocation);
        return TestCacheManagerFactory.createCacheManager(globalBuilder, builder);
    }

    @AfterClass(alwaysRun=true)
    protected void clearTempDir() {
        Util.recursiveFileRemove((String)this.persistentLocation);
    }

    protected void configureEviction(ConfigurationBuilder builder) {
        builder.memory().size(1L);
    }

    protected void configurePersistence(ConfigurationBuilder builder) {
        ((DummyInMemoryStoreConfigurationBuilder)builder.persistence().passivation(false).addStore(DummyInMemoryStoreConfigurationBuilder.class)).storeName(this.storeName + this.storeNamePrefix.getAndIncrement());
    }

    protected final ControlledPassivationManager replacePassivationManager(Latch latch) {
        PassivationManager current = TestingUtil.extractComponent(this.cache, PassivationManager.class);
        ControlledPassivationManager controlledPassivationManager = new ControlledPassivationManager(current);
        controlledPassivationManager.beforePassivate = latch::blockIfNeeded;
        TestingUtil.replaceComponent(this.cache, PassivationManager.class, controlledPassivationManager, true);
        return controlledPassivationManager;
    }

    protected void assertPossibleValues(Object key, Object value, Object ... expectedValues) {
        for (Object expectedValue : expectedValues) {
            if (!(value == null ? expectedValue == null : value.equals(expectedValue))) continue;
            return;
        }
        AssertJUnit.fail((String)("Wrong value for key " + String.valueOf(key) + ". value=" + String.valueOf(value) + ", expectedValues=" + Arrays.toString(expectedValues)));
    }

    public static class SameHashCodeKey {
        @ProtoField(value=1)
        final String name;
        @ProtoField(number=2, defaultValue="0")
        final int hashCode;

        SameHashCodeKey(String name) {
            this(name, 0);
        }

        @ProtoFactory
        SameHashCodeKey(String name, int hashCode) {
            this.name = name;
            this.hashCode = hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SameHashCodeKey that = (SameHashCodeKey)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return this.name;
        }
    }

    protected static class Latch {
        private boolean enabled = false;
        private boolean blocked = false;

        protected Latch() {
        }

        public final synchronized void enable() {
            this.enabled = true;
        }

        public final synchronized void disable() {
            this.enabled = false;
            this.notifyAll();
        }

        public final synchronized void blockIfNeeded() {
            this.blocked = true;
            this.notifyAll();
            while (this.enabled) {
                try {
                    this.wait(TimeUnit.SECONDS.toMillis(10L));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }

        public final synchronized void waitToBlock(long timeout, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
            long waitingTime;
            long endTime = Util.currentMillisFromNanotime() + timeUnit.toMillis(timeout);
            while (!this.blocked && (waitingTime = endTime - Util.currentMillisFromNanotime()) > 0L) {
                this.wait(waitingTime);
            }
            if (!this.blocked) {
                throw new TimeoutException();
            }
        }
    }

    protected static class ControlledPassivationManager
    implements PassivationManager {
        protected final PassivationManager delegate;
        protected volatile Runnable beforePassivate;
        protected volatile Runnable afterPassivate;

        private ControlledPassivationManager(PassivationManager delegate) {
            this.delegate = delegate;
        }

        public boolean isEnabled() {
            return this.delegate.isEnabled();
        }

        public CompletionStage<Void> passivateAsync(InternalCacheEntry entry) {
            Runnable before = this.beforePassivate;
            if (before != null) {
                before.run();
            }
            CompletionStage stage = this.delegate.passivateAsync(entry);
            Runnable after = this.afterPassivate;
            if (after != null) {
                return stage.thenRun(after);
            }
            return stage;
        }

        public CompletionStage<Void> passivateAllAsync() {
            return this.delegate.passivateAllAsync();
        }

        public void skipPassivationOnStop(boolean skip) {
            this.delegate.skipPassivationOnStop(skip);
        }

        public long getPassivations() {
            return this.delegate.getPassivations();
        }

        public boolean getStatisticsEnabled() {
            return this.delegate.getStatisticsEnabled();
        }

        public void setStatisticsEnabled(boolean enabled) {
            this.delegate.setStatisticsEnabled(enabled);
        }

        public void resetStatistics() {
            this.delegate.resetStatistics();
        }
    }

    protected class AfterEntryWrappingInterceptor
    extends ControlledCommandInterceptor {
        protected AfterEntryWrappingInterceptor() {
        }

        public AfterEntryWrappingInterceptor injectThis(Cache<Object, Object> injectInCache) {
            TestingUtil.extractInterceptorChain(injectInCache).addInterceptorAfter((AsyncInterceptor)this, EntryWrappingInterceptor.class);
            return this;
        }
    }

    class AfterActivationOrCacheLoader
    extends ControlledCommandInterceptor {
        AfterActivationOrCacheLoader() {
        }

        public AfterActivationOrCacheLoader injectThis(Cache<Object, Object> injectInCache) {
            AsyncInterceptorChain chain = TestingUtil.extractComponent(injectInCache, AsyncInterceptorChain.class);
            AsyncInterceptor loaderInterceptor = chain.findInterceptorExtending(CacheLoaderInterceptor.class);
            TestingUtil.extractInterceptorChain(injectInCache).addInterceptorAfter((AsyncInterceptor)this, loaderInterceptor.getClass());
            return this;
        }
    }

    @AutoProtoSchemaBuilder(includeClasses={SameHashCodeKey.class}, schemaFileName="test.core.eviction.proto", schemaFilePath="proto/generated", schemaPackageName="org.infinispan.test.core.eviction", service=false)
    static interface EvictionWithConcurrentOperationsSCI
    extends SerializationContextInitializer {
    }

    protected static abstract class ControlledCommandInterceptor
    extends DDAsyncInterceptor {
        volatile Runnable beforeGet;
        volatile Runnable afterGet;
        volatile Runnable beforePut;
        volatile Runnable afterPut;

        protected ControlledCommandInterceptor() {
        }

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            return this.handle(ctx, (VisitableCommand)command, this.beforePut, this.afterPut);
        }

        public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
            return this.handle(ctx, (VisitableCommand)command, this.beforeGet, this.afterGet);
        }

        public Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
            return this.handle(ctx, (VisitableCommand)command, this.beforeGet, this.afterGet);
        }

        protected final Object handle(InvocationContext ctx, VisitableCommand command, Runnable before, Runnable after) throws Throwable {
            if (before != null) {
                before.run();
            }
            return this.invokeNextThenAccept(ctx, command, (rCtx, rCommand, rv) -> {
                if (after != null) {
                    after.run();
                }
            });
        }
    }

    @Listener(sync=true)
    protected static abstract class SyncEvictionListener {
        protected SyncEvictionListener() {
        }

        @CacheEntriesEvicted
        public abstract void evicted(CacheEntriesEvictedEvent var1);
    }
}

