/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.DataContainer;
import org.infinispan.container.impl.AbstractInternalDataContainer;
import org.infinispan.container.offheap.SegmentedBoundedOffHeapDataContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.persistence.impl.MarshalledEntryUtil;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntriesEvicted;
import org.infinispan.notifications.cachelistener.event.CacheEntriesEvictedEvent;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.Mocks;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CheckPoint;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.DataOperationOrderer;
import org.infinispan.util.function.SerializableBiFunction;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="eviction.EvictionWithPassivationTest")
public class EvictionWithPassivationTest
extends SingleCacheManagerTest {
    private static final String CACHE_NAME = "testCache";
    private final int EVICTION_MAX_ENTRIES = 2;
    private StorageType storage;
    private EvictionListener evictionListener;

    public EvictionWithPassivationTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    @Factory
    public Object[] factory() {
        return new Object[]{new EvictionWithPassivationTest().withStorage(StorageType.BINARY), new EvictionWithPassivationTest().withStorage(StorageType.OBJECT), new EvictionWithPassivationTest().withStorage(StorageType.OFF_HEAP)};
    }

    @Override
    protected String parameters() {
        return "[" + String.valueOf(this.storage) + "]";
    }

    private ConfigurationBuilder buildCfg() {
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)cfg.persistence().passivation(true).addStore(DummyInMemoryStoreConfigurationBuilder.class)).purgeOnStartup(true)).invocationBatching().enable().memory().storageType(this.storage);
        cfg.memory().size(2L);
        return cfg;
    }

    public EvictionWithPassivationTest withStorage(StorageType storage) {
        this.storage = storage;
        return this;
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManager(this.getDefaultStandaloneCacheConfig(true));
        this.cacheManager.defineConfiguration(CACHE_NAME, this.buildCfg().build());
        this.evictionListener = new EvictionListener();
        Cache testCache = this.cacheManager.getCache(CACHE_NAME);
        testCache.addListener((Object)this.evictionListener);
        return this.cacheManager;
    }

    public void testBasicStore() {
        String k;
        int i;
        Cache testCache = this.cacheManager.getCache(CACHE_NAME);
        testCache.clear();
        testCache.put((Object)"X", (Object)"4567");
        testCache.put((Object)"Y", (Object)"4568");
        testCache.put((Object)"Z", (Object)"4569");
        Assert.assertEquals((String)"4567", (String)((String)testCache.get((Object)"X")));
        Assert.assertEquals((String)"4568", (String)((String)testCache.get((Object)"Y")));
        Assert.assertEquals((String)"4569", (String)((String)testCache.get((Object)"Z")));
        for (i = 0; i < 10; ++i) {
            testCache.getAdvancedCache().startBatch();
            k = "A" + i;
            testCache.put((Object)k, (Object)k);
            k = "B" + i;
            testCache.put((Object)k, (Object)k);
            testCache.getAdvancedCache().endBatch(true);
        }
        for (i = 0; i < 10; ++i) {
            k = "A" + i;
            Assert.assertEquals((String)k, (String)((String)testCache.get((Object)k)));
            k = "B" + i;
            Assert.assertEquals((String)k, (String)((String)testCache.get((Object)k)));
        }
    }

    public void testActivationInBatchRolledBack() {
        Cache testCache = this.cacheManager.getCache(CACHE_NAME);
        String key = "X";
        String value = "4567";
        testCache.clear();
        testCache.put((Object)"X", (Object)"4567");
        testCache.evict((Object)"X");
        testCache.startBatch();
        Assert.assertEquals((String)"4567", (String)((String)testCache.get((Object)"X")));
        testCache.endBatch(false);
        Assert.assertEquals((String)"4567", (String)((String)testCache.get((Object)"X")));
    }

    public void testActivationWithAnotherConcurrentRequest() throws Exception {
        Cache testCache = this.cacheManager.getCache(CACHE_NAME);
        String key = "Y";
        String value = "4568";
        testCache.clear();
        testCache.put((Object)"Y", (Object)"4568");
        testCache.evict((Object)"Y");
        testCache.startBatch();
        Assert.assertEquals((String)"4568", (String)((String)testCache.get((Object)"Y")));
        CompletableFuture future = testCache.getAsync((Object)"Y");
        Assert.assertEquals((String)"4568", (String)((String)future.get(10L, TimeUnit.SECONDS)));
        Assert.assertEquals((String)"4568", (String)((String)testCache.get((Object)"Y")));
        testCache.endBatch(true);
        Assert.assertEquals((String)"4568", (String)((String)testCache.get((Object)"Y")));
    }

    public void testActivationPendingTransactionDoesNotAffectOthers() throws Throwable {
        String value;
        String previousValue = "prev-value";
        Cache testCache = this.cacheManager.getCache(CACHE_NAME);
        testCache.clear();
        String key = "Y";
        if ("prev-value" != null) {
            testCache.put((Object)"Y", (Object)"prev-value");
            value = "prev-value4568";
        } else {
            value = "4568";
        }
        testCache.evict((Object)"Y");
        testCache.startBatch();
        try {
            if ("prev-value" != null) {
                Assert.assertEquals((String)"prev-value", (String)((String)testCache.put((Object)"Y", (Object)value)));
            } else {
                Assert.assertNull((Object)testCache.put((Object)"Y", (Object)value));
            }
            Assert.assertEquals((String)value, (String)((String)testCache.get((Object)"Y")));
            Future<String> future = this.fork(() -> (String)testCache.get((Object)"Y"));
            if ("prev-value" != null) {
                Assert.assertEquals((String)"prev-value", (String)future.get(10000L, TimeUnit.SECONDS));
            } else {
                Assert.assertNull((Object)future.get(10L, TimeUnit.SECONDS));
            }
        }
        catch (Throwable e) {
            testCache.endBatch(false);
            throw e;
        }
        testCache.endBatch(true);
        Assert.assertEquals((String)value, (String)((String)testCache.get((Object)"Y")));
    }

    public void testActivationPutAllInBatchRolledBack() throws Exception {
        Cache testCache = this.cacheManager.getCache(CACHE_NAME);
        String key = "X";
        String value = "4567";
        testCache.clear();
        testCache.put((Object)"X", (Object)"4567");
        testCache.evict((Object)"X");
        testCache.startBatch();
        testCache.putAll(Collections.singletonMap("X", "4567-putall"));
        testCache.endBatch(false);
        Assert.assertEquals((String)"4567", (String)((String)testCache.get((Object)"X")));
    }

    public void testRemovalOfEvictedEntry() throws Exception {
        Cache testCache = this.cacheManager.getCache(CACHE_NAME);
        int phase = this.evictionListener.phaser.getPhase();
        for (int i = 0; i < 3; ++i) {
            testCache.put((Object)("key" + i), (Object)("value" + i));
        }
        this.evictionListener.phaser.awaitAdvanceInterruptibly(phase, 10L, TimeUnit.SECONDS);
        String evictedKey = this.evictionListener.getEvictedKey();
        this.assertEntryInStore(evictedKey, true);
        testCache.remove((Object)evictedKey);
        Assert.assertFalse((boolean)testCache.containsKey((Object)evictedKey));
        Assert.assertNull((Object)testCache.get((Object)evictedKey));
    }

    public void testComputeOnEvictedEntry() throws Exception {
        Cache testCache = this.cacheManager.getCache(CACHE_NAME);
        int phase = this.evictionListener.phaser.getPhase();
        for (int i = 0; i < 3; ++i) {
            testCache.put((Object)("key" + i), (Object)("value" + i));
        }
        this.evictionListener.phaser.awaitAdvanceInterruptibly(phase, 10L, TimeUnit.SECONDS);
        String evictedKey = this.evictionListener.getEvictedKey();
        this.assertEntryInStore(evictedKey, true);
        testCache.compute((Object)evictedKey, (SerializableBiFunction & Serializable)(k, v) -> v + "-modfied");
        this.assertEntryInStore(evictedKey, true);
    }

    public void testRemoveViaComputeOnEvictedEntry() throws Exception {
        Cache testCache = this.cacheManager.getCache(CACHE_NAME);
        int phase = this.evictionListener.phaser.getPhase();
        for (int i = 0; i < 3; ++i) {
            testCache.put((Object)("key" + i), (Object)("value" + i));
        }
        this.evictionListener.phaser.awaitAdvanceInterruptibly(phase, 10L, TimeUnit.SECONDS);
        String evictedKey = this.evictionListener.getEvictedKey();
        this.assertEntryInStore(evictedKey, true);
        testCache.compute((Object)evictedKey, (SerializableBiFunction & Serializable)(k, v) -> null);
        Assert.assertFalse((boolean)testCache.containsKey((Object)evictedKey));
        this.assertEntryInStore(evictedKey, false);
    }

    public void testCleanStoreOnPut() throws Exception {
        Cache testCache = this.cacheManager.getCache(CACHE_NAME);
        testCache.clear();
        this.putIntoStore("key", "oldValue");
        testCache.put((Object)"key", (Object)"value");
        this.assertEntryInStore("key", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentWriteWithEviction() throws InterruptedException, TimeoutException, ExecutionException {
        Cache testCache = this.cacheManager.getCache(CACHE_NAME);
        testCache.clear();
        DataContainer dc = testCache.getAdvancedCache().getDataContainer();
        Class dcClass = this.storage == StorageType.OFF_HEAP ? SegmentedBoundedOffHeapDataContainer.class : AbstractInternalDataContainer.class;
        CheckPoint checkPoint = new CheckPoint();
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(Object.class);
        DataOperationOrderer doo = Mocks.blockingFieldMock(checkPoint, DataOperationOrderer.class, dc, dcClass, "orderer", (stub, mock) -> ((DataOperationOrderer)stub.when(mock)).orderOn(argumentCaptor.capture(), (CompletionStage)Mockito.any()), new Class[0]);
        try {
            Future<Void> future = this.fork(() -> {
                for (int i = 0; i < 10; ++i) {
                    testCache.put((Object)("k" + i), (Object)("v" + i));
                }
            });
            checkPoint.awaitStrict("before_invocation", 1000L, TimeUnit.SECONDS);
            CompletableFuture stage = new CompletableFuture();
            Object keyEvicting = argumentCaptor.getValue();
            doo.orderOn(keyEvicting, stage);
            checkPoint.triggerForever("before_release");
            checkPoint.awaitStrict("after_invocation", 10L, TimeUnit.SECONDS);
            doo.completeOperation(keyEvicting, stage, DataOperationOrderer.Operation.WRITE);
            checkPoint.triggerForever("after_release");
            future.get(10L, TimeUnit.SECONDS);
        }
        finally {
            TestingUtil.replaceField(doo, "orderer", dc, dcClass);
        }
    }

    private void assertEntryInStore(String key, boolean expectPresent) throws Exception {
        Assert.assertNotNull((Object)key);
        AdvancedCache testCache = this.cacheManager.getCache(CACHE_NAME).getAdvancedCache();
        Object loaderKey = testCache.getKeyDataConversion().toStorage((Object)key);
        CompletionStage stage = TestingUtil.extractComponent(testCache, PersistenceManager.class).loadFromAllStores(loaderKey, true, true);
        MarshallableEntry entry = (MarshallableEntry)CompletionStages.join((CompletionStage)stage);
        if (expectPresent) {
            Assert.assertNotNull((Object)entry);
        } else {
            Assert.assertNull((Object)entry);
        }
        DummyInMemoryStore loader = (DummyInMemoryStore)TestingUtil.getFirstStore(testCache);
        if (expectPresent) {
            this.eventuallyEquals(entry, () -> loader.loadEntry(loaderKey));
        } else {
            Assert.assertFalse((boolean)loader.contains(loaderKey));
        }
    }

    private void putIntoStore(String key, String value) {
        AdvancedCache testCache = this.cacheManager.getCache(CACHE_NAME).getAdvancedCache();
        DummyInMemoryStore writer = (DummyInMemoryStore)TestingUtil.getFirstStore(testCache);
        Object writerKey = testCache.getKeyDataConversion().toStorage((Object)key);
        Object writerValue = testCache.getValueDataConversion().toStorage((Object)value);
        MarshallableEntry<Object, Object> entry = Configurations.isTxVersioned((Configuration)testCache.getCacheConfiguration()) ? MarshalledEntryUtil.createWithVersion(writerKey, writerValue, (Cache)testCache) : MarshalledEntryUtil.create(writerKey, writerValue, (Cache)testCache);
        writer.write(entry);
    }

    @Listener
    public static class EvictionListener {
        private String evictedKey;
        private final Phaser phaser = new Phaser(1);

        @CacheEntriesEvicted
        public void entryEvicted(CacheEntriesEvictedEvent e) {
            this.evictedKey = (String)e.getEntries().keySet().iterator().next();
            this.phaser.arrive();
        }

        public String getEvictedKey() {
            return this.evictedKey;
        }
    }
}

