/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.expiration.impl;

import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.expiration.impl.ExpirationStoreFunctionalTest;
import org.infinispan.expiration.impl.ExpiredCacheListener;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachelistener.event.CacheEntryExpiredEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="expiration.impl.ExpirationStoreListenerFunctionalTest")
public class ExpirationStoreListenerFunctionalTest
extends ExpirationStoreFunctionalTest {
    protected ExpiredCacheListener listener = new ExpiredCacheListener();

    @Override
    @Factory
    public Object[] factory() {
        return new Object[]{new ExpirationStoreListenerFunctionalTest().cacheMode(CacheMode.LOCAL)};
    }

    @Override
    protected String parameters() {
        return null;
    }

    @Override
    protected void afterCacheCreated(EmbeddedCacheManager cm) {
        this.cache.addListener((Object)this.listener);
    }

    @AfterMethod
    public void resetListener() {
        this.listener.reset();
    }

    @Override
    public void testSimpleExpirationLifespan() throws Exception {
        super.testSimpleExpirationLifespan();
        this.processExpiration();
        this.assertExpiredEvents(10);
    }

    @Override
    public void testSimpleExpirationMaxIdle() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.cache.put((Object)("key-" + i), (Object)("value-" + i), -1L, null, 1L, TimeUnit.MILLISECONDS);
        }
        this.timeService.advance(2L);
        this.processExpiration();
        AssertJUnit.assertEquals((int)0, (int)this.cache.size());
        this.assertExpiredEvents(10);
    }

    public void testExpirationOfStoreWhenDataNotInMemory() throws Exception {
        String key = "k";
        this.cache.put((Object)key, (Object)"v", 10L, TimeUnit.MILLISECONDS);
        this.removeFromContainer(key);
        AssertJUnit.assertEquals((int)1, (int)this.cache.size());
        AssertJUnit.assertEquals((int)0, (int)this.listener.getInvocationCount());
        this.timeService.advance(11L);
        AssertJUnit.assertNull((Object)this.cache.get((Object)key));
        this.processExpiration();
        AssertJUnit.assertEquals((int)1, (int)this.listener.getInvocationCount());
        CacheEntryExpiredEvent event = this.listener.getEvents().iterator().next();
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_EXPIRED, (Object)event.getType());
        AssertJUnit.assertEquals((Object)this.cache, (Object)event.getCache());
        AssertJUnit.assertFalse((boolean)event.isPre());
        AssertJUnit.assertNotNull((Object)event.getKey());
        AssertJUnit.assertEquals((Object)"v", (Object)event.getValue());
        if (TestingUtil.getFirstStore(this.cache) instanceof DummyInMemoryStore) {
            AssertJUnit.assertNotNull((Object)event.getMetadata());
        }
    }

    protected void removeFromContainer(String key) {
        this.cache.getAdvancedCache().getDataContainer().remove((Object)key);
    }

    private void assertExpiredEvents(int count) {
        this.eventuallyEquals(count, () -> this.listener.getInvocationCount());
        this.listener.getEvents().forEach(event -> {
            log.tracef("Checking event %s", event);
            AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_EXPIRED, (Object)event.getType());
            AssertJUnit.assertEquals((Object)this.cache, (Object)event.getCache());
            AssertJUnit.assertFalse((boolean)event.isPre());
            AssertJUnit.assertNotNull((Object)event.getKey());
            AssertJUnit.assertNotNull((Object)event.getValue());
            AssertJUnit.assertNotNull((Object)event.getMetadata());
        });
    }
}

