/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.container.impl.BoundedSegmentedDataContainer;
import org.infinispan.container.impl.DefaultDataContainer;
import org.infinispan.container.impl.DefaultSegmentedDataContainer;
import org.infinispan.container.impl.L1SegmentedDataContainer;
import org.infinispan.container.offheap.BoundedOffHeapDataContainer;
import org.infinispan.container.offheap.OffHeapConcurrentMap;
import org.infinispan.container.offheap.OffHeapDataContainer;
import org.infinispan.container.offheap.SegmentedBoundedOffHeapDataContainer;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.factories.DataContainerFactory;
import org.infinispan.test.AbstractInfinispanTest;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(testName="factories.DataContainerFactoryTest", groups={"functional"})
public class DataContainerFactoryTest
extends AbstractInfinispanTest {
    private static final String COMPONENT_NAME = "";
    private DataContainerFactory dataContainerFactory;

    @BeforeMethod
    public void before() {
        this.dataContainerFactory = new DataContainerFactory();
        this.dataContainerFactory.globalConfiguration = GlobalConfigurationBuilder.defaultClusteredBuilder().build();
    }

    @Test
    public void testDefaultConfigurationDataContainer() {
        this.dataContainerFactory.configuration = new ConfigurationBuilder().build();
        AssertJUnit.assertEquals(DefaultDataContainer.class, this.dataContainerFactory.construct(COMPONENT_NAME).getClass());
    }

    @Test
    public void testOffHeap() {
        this.dataContainerFactory.configuration = new ConfigurationBuilder().memory().storageType(StorageType.OFF_HEAP).build();
        AssertJUnit.assertEquals(OffHeapDataContainer.class, this.dataContainerFactory.construct(COMPONENT_NAME).getClass());
    }

    @Test
    public void testSegmentedOffHeap() {
        this.dataContainerFactory.configuration = new ConfigurationBuilder().clustering().cacheMode(CacheMode.DIST_ASYNC).memory().storageType(StorageType.OFF_HEAP).build();
        Object component = this.dataContainerFactory.construct(COMPONENT_NAME);
        AssertJUnit.assertEquals(DefaultSegmentedDataContainer.class, component.getClass());
    }

    @Test
    public void testSegmentedOffHeapAndL1() {
        this.dataContainerFactory = (DataContainerFactory)Mockito.spy((Object)new DataContainerFactory());
        ((DataContainerFactory)Mockito.doReturn((Object)Mockito.mock(OffHeapConcurrentMap.class)).when((Object)this.dataContainerFactory)).createAndStartOffHeapConcurrentMap();
        this.dataContainerFactory.globalConfiguration = GlobalConfigurationBuilder.defaultClusteredBuilder().build();
        this.dataContainerFactory.configuration = new ConfigurationBuilder().clustering().cacheMode(CacheMode.DIST_ASYNC).l1().enable().memory().storageType(StorageType.OFF_HEAP).build();
        Object component = this.dataContainerFactory.construct(COMPONENT_NAME);
        AssertJUnit.assertEquals(L1SegmentedDataContainer.class, component.getClass());
    }

    @Test
    public void testDefaultSegmented() {
        this.dataContainerFactory.configuration = new ConfigurationBuilder().clustering().cacheMode(CacheMode.DIST_ASYNC).build();
        Object component = this.dataContainerFactory.construct(COMPONENT_NAME);
        AssertJUnit.assertEquals(DefaultSegmentedDataContainer.class, component.getClass());
    }

    @Test
    public void testSegmentedL1() {
        this.dataContainerFactory.configuration = new ConfigurationBuilder().clustering().cacheMode(CacheMode.DIST_ASYNC).l1().enable().build();
        Object component = this.dataContainerFactory.construct(COMPONENT_NAME);
        AssertJUnit.assertEquals(L1SegmentedDataContainer.class, component.getClass());
    }

    @Test
    public void testEvictionRemoveNotSegmented() {
        this.dataContainerFactory.configuration = new ConfigurationBuilder().clustering().memory().evictionStrategy(EvictionStrategy.REMOVE).size(1000L).build();
        AssertJUnit.assertEquals(DefaultDataContainer.class, this.dataContainerFactory.construct(COMPONENT_NAME).getClass());
    }

    @Test
    public void testEvictionRemoveSegmented() {
        this.dataContainerFactory.configuration = new ConfigurationBuilder().clustering().memory().evictionStrategy(EvictionStrategy.REMOVE).size(1000L).clustering().cacheMode(CacheMode.DIST_ASYNC).build();
        Object component = this.dataContainerFactory.construct(COMPONENT_NAME);
        AssertJUnit.assertEquals(BoundedSegmentedDataContainer.class, component.getClass());
    }

    @Test
    public void testEvictionRemoveNotSegmentedOffHeap() {
        this.dataContainerFactory.configuration = new ConfigurationBuilder().clustering().memory().storageType(StorageType.OFF_HEAP).evictionStrategy(EvictionStrategy.REMOVE).size(1000L).build();
        AssertJUnit.assertEquals(BoundedOffHeapDataContainer.class, this.dataContainerFactory.construct(COMPONENT_NAME).getClass());
    }

    @Test
    public void testEvictionRemoveSegmentedOffHeap() {
        this.dataContainerFactory.configuration = new ConfigurationBuilder().clustering().memory().storageType(StorageType.OFF_HEAP).evictionStrategy(EvictionStrategy.REMOVE).size(1000L).clustering().cacheMode(CacheMode.DIST_ASYNC).build();
        Object component = this.dataContainerFactory.construct(COMPONENT_NAME);
        AssertJUnit.assertEquals(SegmentedBoundedOffHeapDataContainer.class, component.getClass());
    }
}

