/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.impl;

import java.util.Optional;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.functional.MetaParam;
import org.infinispan.functional.impl.MetaParams;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="functional.impl.MetaParamsTest")
public class MetaParamsTest {
    public void testEmptyMetaParamsFind() {
        MetaParams metas = MetaParams.empty();
        AssertJUnit.assertTrue((boolean)metas.isEmpty());
        AssertJUnit.assertEquals((int)0, (int)metas.size());
        AssertJUnit.assertFalse((boolean)metas.find(MetaParam.MetaLifespan.class).isPresent());
        AssertJUnit.assertFalse((boolean)metas.find(MetaParam.MetaEntryVersion.class).isPresent());
        AssertJUnit.assertFalse((boolean)metas.find(MetaParam.MetaMaxIdle.class).isPresent());
    }

    @Test
    public void testAddFindMetaParam() {
        MetaParams metas = MetaParams.empty();
        MetaParam.MetaLifespan lifespan = new MetaParam.MetaLifespan(1000L);
        metas.add((MetaParam)lifespan);
        AssertJUnit.assertFalse((boolean)metas.isEmpty());
        AssertJUnit.assertEquals((int)1, (int)metas.size());
        Optional lifespanFound = metas.find(MetaParam.MetaLifespan.class);
        AssertJUnit.assertEquals((Object)new MetaParam.MetaLifespan(1000L), lifespanFound.get());
        AssertJUnit.assertEquals((long)1000L, (long)((MetaParam.MetaLifespan)metas.find(MetaParam.MetaLifespan.class).get()).get());
        AssertJUnit.assertFalse((boolean)new MetaParam.MetaLifespan(900L).equals(lifespanFound.get()));
        metas.add((MetaParam)new MetaParam.MetaLifespan(900L));
        AssertJUnit.assertFalse((boolean)metas.isEmpty());
        AssertJUnit.assertEquals((int)1, (int)metas.size());
        AssertJUnit.assertEquals(Optional.of(new MetaParam.MetaLifespan(900L)), (Object)metas.find(lifespan.getClass()));
    }

    @Test
    public void testAddFindMultipleMetaParams() {
        MetaParams metas = MetaParams.empty();
        metas.addMany(new MetaParam[]{new MetaParam.MetaLifespan(1000L), new MetaParam.MetaMaxIdle(1000L), new MetaParam.MetaEntryVersion((EntryVersion)new NumericVersion(12345L))});
        AssertJUnit.assertFalse((boolean)metas.isEmpty());
        AssertJUnit.assertEquals((int)3, (int)metas.size());
        Optional maxIdle = metas.find(MetaParam.MetaMaxIdle.class);
        Optional entryVersion = metas.find(MetaParam.MetaEntryVersion.class);
        AssertJUnit.assertEquals(Optional.of(new MetaParam.MetaMaxIdle(1000L)), (Object)maxIdle);
        AssertJUnit.assertFalse((900L == ((MetaParam.MetaMaxIdle)maxIdle.get()).get() ? 1 : 0) != 0);
        AssertJUnit.assertEquals((Object)new MetaParam.MetaEntryVersion((EntryVersion)new NumericVersion(12345L)), entryVersion.get());
        AssertJUnit.assertFalse((boolean)new MetaParam.MetaEntryVersion((EntryVersion)new NumericVersion(23456L)).equals(entryVersion.get()));
    }

    @Test
    public void testReplaceFindMultipleMetaParams() {
        MetaParams metas = MetaParams.empty();
        metas.addMany(new MetaParam[]{new MetaParam.MetaLifespan(1000L), new MetaParam.MetaMaxIdle(1000L), new MetaParam.MetaEntryVersion((EntryVersion)new NumericVersion(12345L))});
        AssertJUnit.assertFalse((boolean)metas.isEmpty());
        AssertJUnit.assertEquals((int)3, (int)metas.size());
        metas.addMany(new MetaParam[]{new MetaParam.MetaLifespan(2000L), new MetaParam.MetaMaxIdle(2000L)});
        AssertJUnit.assertFalse((boolean)metas.isEmpty());
        AssertJUnit.assertEquals((int)3, (int)metas.size());
        AssertJUnit.assertEquals(Optional.of(new MetaParam.MetaMaxIdle(2000L)), (Object)metas.find(MetaParam.MetaMaxIdle.class));
        AssertJUnit.assertEquals(Optional.of(new MetaParam.MetaLifespan(2000L)), (Object)metas.find(MetaParam.MetaLifespan.class));
        AssertJUnit.assertEquals(Optional.of(new MetaParam.MetaEntryVersion((EntryVersion)new NumericVersion(12345L))), (Object)metas.find(MetaParam.MetaEntryVersion.class));
    }

    @Test
    public void testConstructors() {
        MetaParams metasOf1 = MetaParams.of((MetaParam)new MetaParam.MetaCreated(1000L));
        AssertJUnit.assertFalse((boolean)metasOf1.isEmpty());
        AssertJUnit.assertEquals((int)1, (int)metasOf1.size());
        MetaParams metasOf2 = MetaParams.of((MetaParam[])new MetaParam[]{new MetaParam.MetaCreated(1000L), new MetaParam.MetaLastUsed(2000L)});
        AssertJUnit.assertFalse((boolean)metasOf2.isEmpty());
        AssertJUnit.assertEquals((int)2, (int)metasOf2.size());
        MetaParams metasOf4 = MetaParams.of((MetaParam[])new MetaParam[]{new MetaParam.MetaCreated(1000L), new MetaParam.MetaLastUsed(2000L), new MetaParam.MetaLifespan(3000L), new MetaParam.MetaMaxIdle(4000L)});
        AssertJUnit.assertFalse((boolean)metasOf4.isEmpty());
        AssertJUnit.assertEquals((int)4, (int)metasOf4.size());
    }

    @Test
    public void testDuplicateParametersOnConstruction() {
        MetaParam.MetaEntryVersion versionParam1 = new MetaParam.MetaEntryVersion((EntryVersion)new NumericVersion(100L));
        MetaParam.MetaEntryVersion versionParam2 = new MetaParam.MetaEntryVersion((EntryVersion)new NumericVersion(200L));
        MetaParams metas = MetaParams.of((MetaParam[])new MetaParam[]{versionParam1, versionParam2});
        AssertJUnit.assertEquals((int)1, (int)metas.size());
        AssertJUnit.assertEquals(Optional.of(new MetaParam.MetaEntryVersion((EntryVersion)new NumericVersion(200L))), (Object)metas.find(MetaParam.MetaEntryVersion.class));
    }

    @Test
    public void testDuplicateParametersOnAdd() {
        MetaParam.MetaEntryVersion versionParam1 = new MetaParam.MetaEntryVersion((EntryVersion)new NumericVersion(100L));
        MetaParams metas = MetaParams.of((MetaParam)versionParam1);
        AssertJUnit.assertEquals((int)1, (int)metas.size());
        AssertJUnit.assertEquals(Optional.of(new MetaParam.MetaEntryVersion((EntryVersion)new NumericVersion(100L))), (Object)metas.find(MetaParam.MetaEntryVersion.class));
        MetaParam.MetaEntryVersion versionParam2 = new MetaParam.MetaEntryVersion((EntryVersion)new NumericVersion(200L));
        metas.add((MetaParam)versionParam2);
        AssertJUnit.assertEquals((int)1, (int)metas.size());
        AssertJUnit.assertEquals(Optional.of(new MetaParam.MetaEntryVersion((EntryVersion)new NumericVersion(200L))), (Object)metas.find(MetaParam.MetaEntryVersion.class));
        MetaParam.MetaEntryVersion versionParam3 = new MetaParam.MetaEntryVersion((EntryVersion)new NumericVersion(300L));
        MetaParam.MetaEntryVersion versionParam4 = new MetaParam.MetaEntryVersion((EntryVersion)new NumericVersion(400L));
        metas.addMany(new MetaParam[]{versionParam3, versionParam4});
        AssertJUnit.assertEquals((int)1, (int)metas.size());
        AssertJUnit.assertEquals(Optional.of(new MetaParam.MetaEntryVersion((EntryVersion)new NumericVersion(400L))), (Object)metas.find(MetaParam.MetaEntryVersion.class));
    }
}

