/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.globalstate;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.globalstate.AbstractGlobalStateRestartTest;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.topology.PersistentUUID;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="globalstate.ThreeNodeReplGlobalStateRestartTest", groups={"functional"})
public class ThreeNodeReplGlobalStateRestartTest
extends AbstractGlobalStateRestartTest {
    @Override
    protected int getClusterSize() {
        return 3;
    }

    @Override
    protected void applyCacheManagerClusteringConfiguration(ConfigurationBuilder config) {
        config.clustering().cacheMode(CacheMode.REPL_SYNC);
    }

    public void testGracefulShutdownAndRestart() throws Throwable {
        this.shutdownAndRestart(-1, false);
    }

    public void testGracefulShutdownAndRestartReverseOrder() throws Throwable {
        this.shutdownAndRestart(-1, true);
    }

    public void testFailedRestartWithExtraneousCoordinator() throws Throwable {
        this.shutdownAndRestart(0, false);
    }

    public void testFailedRestartWithExtraneousNode() throws Throwable {
        this.shutdownAndRestart(1, false);
    }

    public void testAddMemberAfterRecover() throws Throwable {
        this.shutdownAndRestart(-1, false);
        this.createStatefulCacheManager(Character.toString('@'), true);
        this.waitForClusterToForm("testCache");
        int index = this.getClusterSize();
        AssertJUnit.assertEquals((int)100, (int)this.cache(index, "testCache").size());
        for (int i = 0; i < 100; ++i) {
            AssertJUnit.assertEquals((Object)this.cache(index, "testCache").get((Object)String.valueOf(i)), (Object)String.valueOf(i));
        }
    }

    public void testDisableRebalanceRestartEnableRebalance() throws Throwable {
        int i;
        Map<JGroupsAddress, PersistentUUID> addressMappings = this.createInitialCluster();
        ConsistentHash oldConsistentHash = this.advancedCache(0, "testCache").getDistributionManager().getWriteConsistentHash();
        GlobalComponentRegistry.of((EmbeddedCacheManager)this.manager(0)).getLocalTopologyManager().setRebalancingEnabled(false);
        for (i = 0; i < this.getClusterSize(); ++i) {
            ((DefaultCacheManager)this.manager(i)).shutdownAllCaches();
            this.manager(i).stop();
        }
        this.cacheManagers.clear();
        this.createStatefulCacheManagers(false, -1, false);
        for (i = 0; i < this.getClusterSize() - 1; ++i) {
            this.cache(i, "testCache");
        }
        LocalTopologyManager ltm = GlobalComponentRegistry.of((EmbeddedCacheManager)this.manager(0)).getLocalTopologyManager();
        Assertions.assertThat((boolean)ltm.isRebalancingEnabled()).isFalse();
        ltm.setRebalancingEnabled(true);
        this.cache(this.getClusterSize() - 1, "testCache");
        this.assertHealthyCluster(addressMappings, oldConsistentHash);
        AssertJUnit.assertTrue((boolean)GlobalComponentRegistry.of((EmbeddedCacheManager)this.manager(0)).getLocalTopologyManager().isRebalancingEnabled());
    }

    public void testPersistentStateIsDeletedAfterRestart() throws Throwable {
        this.shutdownAndRestart(-1, false);
        this.restartWithoutGracefulShutdown();
    }
}

