/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.testng.annotations.Test;

@Test(testName="lock.StaleLocksTransactionTest", groups={"functional"})
@CleanupAfterMethod
public class StaleLocksTransactionTest
extends MultipleCacheManagersTest {
    Cache<String, String> c1;
    Cache<String, String> c2;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfg = StaleLocksTransactionTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        cfg.locking().lockAcquisitionTimeout(TestingUtil.shortTimeoutMillis()).transaction().lockingMode(LockingMode.PESSIMISTIC);
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.createClusteredCacheManager(cfg);
        EmbeddedCacheManager cm2 = TestCacheManagerFactory.createClusteredCacheManager(cfg);
        this.registerCacheManager(new CacheContainer[]{cm1, cm2});
        this.c1 = cm1.getCache();
        this.c2 = cm2.getCache();
    }

    public void testNoModsCommit() throws Exception {
        this.doTest(false, true);
    }

    public void testModsRollback() throws Exception {
        this.doTest(true, false);
    }

    public void testNoModsRollback() throws Exception {
        this.doTest(false, false);
    }

    public void testModsCommit() throws Exception {
        this.doTest(true, true);
    }

    private void doTest(boolean mods, boolean commit) throws Exception {
        this.tm(this.c1).begin();
        this.c1.getAdvancedCache().lock((Object[])new String[]{"k"});
        assert (this.c1.get((Object)"k") == null);
        if (mods) {
            this.c1.put((Object)"k", (Object)"v");
        }
        if (commit) {
            this.tm(this.c1).commit();
        } else {
            this.tm(this.c1).rollback();
        }
        this.assertEventuallyNotLocked(this.c1, "k");
        this.assertEventuallyNotLocked(this.c2, "k");
    }
}

