/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.util.StripedHashFunction;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="lock.StripedHashFunctionTest")
public class StripedHashFunctionTest
extends AbstractInfinispanTest {
    private StripedHashFunction<String> stripedHashFunction;

    @BeforeMethod
    public void setUp() {
        this.stripedHashFunction = new StripedHashFunction(500);
    }

    public void testHashingDistribution() {
        List<String> keys = this.createRandomKeys(1000);
        HashMap<Integer, Integer> distribution = new HashMap<Integer, Integer>();
        for (String s : keys) {
            int segmentIndex = this.stripedHashFunction.hashToSegment((Object)s);
            log.tracef("Lock for %s is %s", (Object)s, (Object)segmentIndex);
            if (distribution.containsKey(segmentIndex)) {
                int count = (Integer)distribution.get(segmentIndex) + 1;
                distribution.put(segmentIndex, count);
                continue;
            }
            distribution.put(segmentIndex, 1);
        }
        log.trace((Object)("dist size: " + distribution.size()));
        log.trace((Object)("num shared locks: " + this.stripedHashFunction.getNumSegments()));
        assert (distribution.size() <= this.stripedHashFunction.getNumSegments());
        assert ((double)distribution.size() * 1.5 >= (double)this.stripedHashFunction.getNumSegments());
    }

    private List<String> createRandomKeys(int number) {
        ArrayList<String> f = new ArrayList<String>(number);
        int i = number;
        while (f.size() < number) {
            String s = i + "baseKey" + (10000 + i++);
            f.add(s);
        }
        return f;
    }
}

