/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.singlelock.optimistic;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.lock.singlelock.AbstractCrashTest;
import org.infinispan.lock.singlelock.AbstractInitiatorCrashTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.LockingMode;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.singlelock.optimistic.InitiatorCrashOptimisticTest")
@CleanupAfterMethod
public class InitiatorCrashOptimisticTest
extends AbstractInitiatorCrashTest {
    public InitiatorCrashOptimisticTest() {
        super(CacheMode.DIST_SYNC, LockingMode.OPTIMISTIC, false);
    }

    public void testInitiatorNodeCrashesBeforePrepare() throws Exception {
        AbstractCrashTest.TxControlInterceptor txControlInterceptor = new AbstractCrashTest.TxControlInterceptor();
        TestingUtil.extractInterceptorChain(this.advancedCache(1)).addInterceptor((AsyncInterceptor)txControlInterceptor, 1);
        Object k = this.getKeyForCache(2);
        Future<Void> future = this.beginAndPrepareTx(k, 1);
        txControlInterceptor.preparedReceived.await();
        assert (this.checkTxCount(0, 0, 1));
        assert (this.checkTxCount(1, 1, 0));
        assert (this.checkTxCount(2, 0, 1));
        this.killMember(1);
        assert (this.caches().size() == 2);
        txControlInterceptor.prepareProgress.countDown();
        this.assertNotLocked(k);
        InitiatorCrashOptimisticTest.eventually(() -> this.checkTxCount(0, 0, 0) && this.checkTxCount(1, 0, 0));
        future.get(30L, TimeUnit.SECONDS);
    }
}

