/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.singlelock.replicated.pessimistic;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.distribution.MagicKey;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.lock.singlelock.AbstractCrashTest;
import org.infinispan.lock.singlelock.replicated.optimistic.InitiatorCrashOptimisticReplTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.LockingMode;
import org.testng.annotations.Test;

@Test(groups={"unstable"}, testName="lock.singlelock.replicated.pessimistic.InitiatorCrashPessimisticReplTest", description="See ISPN-2161 -- original group: functional")
@CleanupAfterMethod
public class InitiatorCrashPessimisticReplTest
extends InitiatorCrashOptimisticReplTest {
    public InitiatorCrashPessimisticReplTest() {
        super(CacheMode.REPL_SYNC, LockingMode.PESSIMISTIC, false);
    }

    @Override
    public void testInitiatorNodeCrashesBeforeCommit() throws Exception {
        AbstractCrashTest.TxControlInterceptor txControlInterceptor = new AbstractCrashTest.TxControlInterceptor();
        txControlInterceptor.prepareProgress.countDown();
        TestingUtil.extractInterceptorChain(this.advancedCache(1)).addInterceptor((AsyncInterceptor)txControlInterceptor, 1);
        MagicKey key = new MagicKey("k", this.cache(0));
        Future<Void> future = this.beginAndCommitTx(key, 1);
        txControlInterceptor.preparedReceived.await();
        this.assertLocked(this.cache(0), (Object)key);
        this.assertEventuallyNotLocked(this.cache(1), key);
        this.assertEventuallyNotLocked(this.cache(2), key);
        this.checkTxCount(0, 0, 1);
        this.checkTxCount(1, 1, 0);
        this.checkTxCount(2, 0, 1);
        this.killMember(1);
        this.assertNotLocked(key);
        InitiatorCrashPessimisticReplTest.eventually(() -> this.checkTxCount(0, 0, 0) && this.checkTxCount(1, 0, 0));
        future.get(30L, TimeUnit.SECONDS);
    }

    @Override
    public void testInitiatorCrashesBeforeReleasingLock() throws Exception {
        CountDownLatch releaseLocksLatch = new CountDownLatch(1);
        this.skipTxCompletion(this.advancedCache(1), releaseLocksLatch);
        MagicKey key = new MagicKey("k", this.cache(0));
        Future<Void> future = this.beginAndCommitTx(key, 1);
        releaseLocksLatch.await();
        assert (this.checkTxCount(0, 0, 1));
        assert (this.checkTxCount(1, 0, 0));
        assert (this.checkTxCount(2, 0, 1));
        this.assertLocked(this.cache(0), (Object)key);
        this.assertEventuallyNotLocked(this.cache(1), key);
        this.assertEventuallyNotLocked(this.cache(2), key);
        this.killMember(1);
        InitiatorCrashPessimisticReplTest.eventually(() -> this.checkTxCount(0, 0, 0) && this.checkTxCount(1, 0, 0));
        this.assertNotLocked(key);
        assert (this.cache(0).get((Object)key).equals("v"));
        assert (this.cache(1).get((Object)key).equals("v"));
        future.get(30L, TimeUnit.SECONDS);
    }

    @Override
    public void testInitiatorNodeCrashesBeforePrepare() throws Exception {
        MagicKey key = new MagicKey("a", this.cache(0));
        this.cache(0).put((Object)key, (Object)"b");
        assert (this.cache(0).get((Object)key).equals("b"));
        assert (this.cache(1).get((Object)key).equals("b"));
        assert (this.cache(2).get((Object)key).equals("b"));
        AbstractCrashTest.TxControlInterceptor txControlInterceptor = new AbstractCrashTest.TxControlInterceptor();
        TestingUtil.extractInterceptorChain(this.advancedCache(1)).addInterceptor((AsyncInterceptor)txControlInterceptor, 1);
        Future<Void> future = this.beginAndPrepareTx("k", 1);
        InitiatorCrashPessimisticReplTest.eventually(() -> this.checkTxCount(0, 0, 1) && this.checkTxCount(1, 1, 0) && this.checkTxCount(2, 0, 1));
        this.killMember(1);
        assert (this.caches().size() == 2);
        txControlInterceptor.prepareProgress.countDown();
        this.assertNotLocked("k");
        InitiatorCrashPessimisticReplTest.eventually(() -> this.checkTxCount(0, 0, 0) && this.checkTxCount(1, 0, 0));
        future.get(30L, TimeUnit.SECONDS);
    }
}

