/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.core;

import java.io.IOException;
import java.util.Objects;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.BytesObjectInput;
import org.infinispan.marshall.core.BytesObjectOutput;
import org.infinispan.marshall.core.GlobalMarshaller;
import org.infinispan.marshall.core.Primitives;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="marshall.PrimitivesTest")
public class PrimitivesTest
extends AbstractInfinispanTest {
    private EmbeddedCacheManager cm;
    private GlobalMarshaller globalMarshaller;

    @BeforeClass
    public void setUp() {
        this.cm = TestCacheManagerFactory.createCacheManager();
        this.globalMarshaller = TestingUtil.extractGlobalMarshaller(this.cm);
    }

    @AfterClass
    public void tearDown() {
        if (this.cm != null) {
            this.cm.stop();
        }
    }

    public void testReadAndWrite() throws Exception {
        this.assertReadAndWrite(new byte[]{0, 1}, 1);
        this.assertReadAndWrite("kaixo", 2);
        this.assertReadAndWrite(true, 16);
        this.assertReadAndWrite((byte)0, 17);
        this.assertReadAndWrite(Character.valueOf('P'), 18);
        this.assertReadAndWrite(123.0, 19);
        this.assertReadAndWrite(Float.valueOf(123.0f), 20);
        this.assertReadAndWrite(123, 21);
        this.assertReadAndWrite(123L, 22);
        this.assertReadAndWrite((short)123, 23);
        this.assertReadAndWrite(new boolean[]{true, false}, 24);
        this.assertReadAndWrite(new char[]{'k', 'a', 'i', 'x', 'o'}, 25);
        this.assertReadAndWrite(new double[]{123.0, 456.0}, 26);
        this.assertReadAndWrite(new float[]{123.0f, 456.0f}, 27);
        this.assertReadAndWrite(new int[]{123, 456}, 28);
        this.assertReadAndWrite(new long[]{123L, 456L}, 29);
        this.assertReadAndWrite(new short[]{123, 456}, 30);
        Exceptions.expectException(IOException.class, (String)"Unknown primitive type: diable", () -> Primitives.writePrimitive((Object)"diable", (BytesObjectOutput)new BytesObjectOutput(10240, this.globalMarshaller), (int)666));
    }

    private void assertReadAndWrite(Object write, int id) throws IOException, ClassNotFoundException {
        BytesObjectOutput out = new BytesObjectOutput(10240, this.globalMarshaller);
        Primitives.writePrimitive((Object)write, (BytesObjectOutput)out, (int)id);
        Object read = Primitives.readPrimitive((BytesObjectInput)BytesObjectInput.from((byte[])out.bytes, (int)0, (GlobalMarshaller)this.globalMarshaller));
        AssertJUnit.assertTrue((boolean)Objects.deepEquals(write, read));
    }

    public void testLargeArray() {
        BytesObjectOutput out = new BytesObjectOutput(10240, this.globalMarshaller);
        byte[] bytes = new byte[]{0};
        out.write(bytes);
        Exceptions.expectException(OutOfMemoryError.class, () -> out.write(bytes, 0, Integer.MAX_VALUE));
    }
}

