/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.metadata;

import java.util.concurrent.TimeUnit;
import org.infinispan.container.entries.AbstractInternalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.InternalMetadataImpl;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="metadata.InternalMetadataTest")
public class InternalMetadataTest {
    public void testWithMetadata() {
        TestMetadata metadata = new TestMetadata(1L, 2L);
        InternalMetadataImpl internalMetadata = new InternalMetadataImpl((Metadata)metadata, 3L, 4L);
        this.assertInternalMetadataValues((InternalMetadata)internalMetadata, 1L, 2L, 3L, 4L);
        this.assertInternalMetadataActual(internalMetadata);
        InternalMetadataImpl internalMetadata2 = new InternalMetadataImpl((Metadata)internalMetadata, 5L, 6L);
        this.assertInternalMetadataValues((InternalMetadata)internalMetadata2, 1L, 2L, 5L, 6L);
        this.assertInternalMetadataActual(internalMetadata2);
    }

    public void testWithInternalCacheEntry() {
        TestMetadata metadata = new TestMetadata(1L, 2L);
        InternalMetadataImpl internalMetadata = new InternalMetadataImpl((Metadata)metadata, 3L, 4L);
        this.assertInternalMetadataValues((InternalMetadata)internalMetadata, 1L, 2L, 3L, 4L);
        this.assertInternalMetadataActual(internalMetadata);
        TestInternalCacheEntry cacheEntry = new TestInternalCacheEntry((Metadata)internalMetadata, 5L, 6L);
        InternalMetadataImpl internalMetadata2 = new InternalMetadataImpl((InternalCacheEntry)cacheEntry);
        this.assertInternalMetadataValues((InternalMetadata)internalMetadata2, 1L, 2L, 5L, 6L);
        this.assertInternalMetadataActual(internalMetadata2);
    }

    public void testWithInternalCacheEntry2() {
        TestMetadata metadata = new TestMetadata(1L, 2L);
        TestInternalCacheEntry cacheEntry = new TestInternalCacheEntry(metadata, 3L, 4L);
        InternalMetadataImpl internalMetadata = new InternalMetadataImpl((InternalCacheEntry)cacheEntry);
        this.assertInternalMetadataValues((InternalMetadata)internalMetadata, 1L, 2L, 3L, 4L);
        this.assertInternalMetadataActual(internalMetadata);
    }

    private void assertInternalMetadataActual(InternalMetadataImpl metadata) {
        AssertJUnit.assertFalse((String)"'actual' field must not be an InternalMetadataImpl", (boolean)(metadata.actual() instanceof InternalMetadataImpl));
    }

    private void assertInternalMetadataValues(InternalMetadata metadata, long lifespan, long maxIdle, long created, long lastUsed) {
        AssertJUnit.assertEquals((String)"Wrong lifespan value.", (long)lifespan, (long)metadata.lifespan());
        AssertJUnit.assertEquals((String)"Wrong maxIdle value.", (long)maxIdle, (long)metadata.maxIdle());
        AssertJUnit.assertEquals((String)"Wrong created value.", (long)created, (long)metadata.created());
        AssertJUnit.assertEquals((String)"Wrong lastUsed value.", (long)lastUsed, (long)metadata.lastUsed());
    }

    private static class TestMetadata
    implements Metadata,
    Metadata.Builder {
        private final long lifespan;
        private final long maxIdle;

        private TestMetadata(long lifespan, long maxIdle) {
            this.lifespan = lifespan;
            this.maxIdle = maxIdle;
        }

        public long lifespan() {
            return this.lifespan;
        }

        public long maxIdle() {
            return this.maxIdle;
        }

        public EntryVersion version() {
            return null;
        }

        public Metadata.Builder builder() {
            return this;
        }

        public Metadata.Builder lifespan(long time, TimeUnit unit) {
            return new TestMetadata(unit.toMillis(time), this.maxIdle);
        }

        public Metadata.Builder lifespan(long time) {
            return this.lifespan(time, TimeUnit.MILLISECONDS);
        }

        public Metadata.Builder maxIdle(long time, TimeUnit unit) {
            return new TestMetadata(this.lifespan, unit.toMillis(time));
        }

        public Metadata.Builder maxIdle(long time) {
            return this.maxIdle(time, TimeUnit.MILLISECONDS);
        }

        public Metadata.Builder version(EntryVersion version) {
            return this;
        }

        public Metadata build() {
            return this;
        }

        public Metadata.Builder merge(Metadata metadata) {
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestMetadata that = (TestMetadata)o;
            return this.lifespan == that.lifespan && this.maxIdle == that.maxIdle;
        }

        public int hashCode() {
            int result = (int)(this.lifespan ^ this.lifespan >>> 32);
            result = 31 * result + (int)(this.maxIdle ^ this.maxIdle >>> 32);
            return result;
        }

        public String toString() {
            return "TestMetadata{lifespan=" + this.lifespan + ", maxIdle=" + this.maxIdle + "}";
        }
    }

    private static class TestInternalCacheEntry
    extends AbstractInternalCacheEntry {
        private final Metadata metadata;
        private final long created;
        private final long lastUsed;

        private TestInternalCacheEntry(Metadata metadata, long created, long lastUsed) {
            super(null, null, null);
            this.metadata = metadata;
            this.created = created;
            this.lastUsed = lastUsed;
        }

        public boolean isExpired(long now) {
            return false;
        }

        public boolean canExpire() {
            return false;
        }

        public long getCreated() {
            return this.created;
        }

        public long getLastUsed() {
            return this.lastUsed;
        }

        public long getExpiryTime() {
            return 0L;
        }

        public void touch(long currentTimeMillis) {
        }

        public void reincarnate(long now) {
        }

        public InternalCacheValue<?> toInternalCacheValue() {
            return null;
        }

        public long getLifespan() {
            return this.metadata.lifespan();
        }

        public long getMaxIdle() {
            return this.metadata.maxIdle();
        }

        public Metadata getMetadata() {
            return this.metadata;
        }
    }
}

