/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications;

import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.Cache;
import org.infinispan.manager.CacheContainer;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="notifications.CacheListenerRemovalTest")
public class CacheListenerRemovalTest
extends AbstractInfinispanTest {
    Cache<String, String> cache;
    CacheContainer cm;

    @BeforeMethod
    public void setUp() {
        this.cm = TestCacheManagerFactory.createCacheManager(false);
        this.cache = this.cm.getCache();
    }

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCacheManagers(this.cm);
        this.cm = null;
        this.cache = null;
    }

    public void testListenerRemoval() {
        this.cache.put((Object)"x", (Object)"y");
        AtomicInteger i = new AtomicInteger(0);
        int listenerSize = TestingUtil.getListeners(this.cache).size();
        CacheListener l = new CacheListener(i);
        this.cache.addListener((Object)l);
        AssertJUnit.assertEquals((int)(listenerSize + 1), (int)TestingUtil.getListeners(this.cache).size());
        assert (TestingUtil.getListeners(this.cache).contains(l));
        assert (0 == i.get());
        this.cache.get((Object)"x");
        assert (1 == i.get());
        this.cache.removeListener((Object)l);
        AssertJUnit.assertEquals((int)listenerSize, (int)TestingUtil.getListeners(this.cache).size());
        i.set(0);
        assert (0 == i.get());
        this.cache.get((Object)"x");
        assert (0 == i.get());
    }

    @Listener
    public static class CacheListener {
        AtomicInteger i;

        private CacheListener(AtomicInteger i) {
            this.i = i;
        }

        @CacheEntryVisited
        public void listen(Event e) {
            if (e.isPre()) {
                this.i.incrementAndGet();
            }
        }
    }
}

