/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.conflict.EntryMergePolicy;
import org.infinispan.context.Flag;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.partitionhandling.AvailabilityException;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.MergeView;
import org.jgroups.View;
import org.jgroups.protocols.DISCARD;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.STABLE;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.Digest;
import org.jgroups.util.MutableDigest;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="partitionhandling.BasePartitionHandlingTest")
public class BasePartitionHandlingTest
extends MultipleCacheManagersTest {
    protected static Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final AtomicInteger viewId = new AtomicInteger(5);
    protected int numMembersInCluster = 4;
    protected int numberOfOwners = 2;
    protected volatile Partition[] partitions;
    protected PartitionHandling partitionHandling = PartitionHandling.DENY_READ_WRITES;
    protected EntryMergePolicy<String, String> mergePolicy = null;

    public BasePartitionHandlingTest() {
        this.cacheMode = CacheMode.DIST_SYNC;
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder dcc = this.cacheConfiguration();
        this.partitionHandlingBuilder(dcc);
        this.customizeCacheConfiguration(dcc);
        this.createClusteredCaches(this.numMembersInCluster, this.serializationContextInitializer(), dcc, new TransportFlags().withFD(true).withMerge(true), new String[0]);
        this.waitForClusterToForm();
    }

    protected String customCacheName() {
        return null;
    }

    protected void customizeCacheConfiguration(ConfigurationBuilder dcc) {
    }

    protected void partitionHandlingBuilder(ConfigurationBuilder dcc) {
        dcc.clustering().cacheMode(this.cacheMode).partitionHandling().whenSplit(this.partitionHandling).mergePolicy(this.mergePolicy);
        if (this.cacheMode == CacheMode.DIST_SYNC) {
            dcc.clustering().hash().numOwners(this.numberOfOwners);
        }
        if (this.lockingMode != null) {
            dcc.transaction().lockingMode(this.lockingMode);
        }
    }

    @AfterMethod(alwaysRun=true)
    public void enableDiscovery() {
        for (EmbeddedCacheManager manager : this.managers()) {
            if (!manager.getStatus().allowInvocations()) continue;
            this.enableDiscoveryProtocol(this.channel(manager));
        }
    }

    protected SerializationContextInitializer serializationContextInitializer() {
        return TestDataSCI.INSTANCE;
    }

    protected BasePartitionHandlingTest partitionHandling(PartitionHandling partitionHandling) {
        this.partitionHandling = partitionHandling;
        return this;
    }

    @Override
    protected String[] parameterNames() {
        return new String[]{null, "tx", "locking", "isolation", "triangle", null};
    }

    @Override
    protected Object[] parameterValues() {
        return new Object[]{this.cacheMode, this.transactional, this.lockingMode, this.isolationLevel, this.useTriangle, this.partitionHandling};
    }

    protected ConfigurationBuilder cacheConfiguration() {
        return new ConfigurationBuilder();
    }

    protected void disableDiscoveryProtocol(JChannel c) {
        ((Discovery)c.getProtocolStack().findProtocol(Discovery.class)).setClusterName(c.getAddressAsString());
    }

    protected void enableDiscoveryProtocol(JChannel c) {
        try {
            String defaultClusterName = TestResourceTracker.getCurrentTestName();
            ((Discovery)c.getProtocolStack().findProtocol(Discovery.class)).setClusterName(defaultClusterName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private GMS getGms(JChannel c) {
        return (GMS)c.getProtocolStack().findProtocol(GMS.class);
    }

    protected void assertKeyAvailableForRead(Cache<?, ?> c, Object k, Object expectedValue) {
        log.tracef("Checking key %s is available on %s", k, c);
        Assert.assertEquals((Object)c.get(k), (Object)expectedValue, (String)("Cache " + String.valueOf(c.getAdvancedCache().getRpcManager().getAddress()) + " doesn't see the right value: "));
        Map expectedMap = expectedValue == null ? Collections.emptyMap() : Collections.singletonMap(k, expectedValue);
        Assert.assertEquals((Map)c.getAdvancedCache().getAll(Collections.singleton(k)), expectedMap, (String)("Cache " + String.valueOf(c.getAdvancedCache().getRpcManager().getAddress()) + " doesn't see the right value: "));
    }

    protected void assertKeyNotAvailableForRead(Cache<Object, ?> c, Object key) {
        log.tracef("Checking key %s is not available on %s", key, c);
        Exceptions.expectException(AvailabilityException.class, () -> c.get(key));
        Exceptions.expectException(AvailabilityException.class, () -> c.getAdvancedCache().getAll(Collections.singleton(key)));
    }

    protected void splitCluster(PartitionDescriptor ... partitions) {
        this.splitCluster((int[][])Arrays.stream(partitions).map(PartitionDescriptor::getNodes).toArray(x$0 -> new int[x$0][]));
    }

    protected void splitCluster(int[] ... parts) {
        List allMembers = this.channel(0).getView().getMembers();
        this.partitions = new Partition[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            Partition p = new Partition(allMembers);
            for (int j : parts[i]) {
                p.addNode(this.channel(j));
            }
            this.partitions[i] = p;
            p.discardOtherMembers();
        }
        for (Partition p : this.partitions) {
            p.partition();
        }
    }

    protected AdvancedCache<?, ?>[] getPartitionCaches(PartitionDescriptor descriptor) {
        int[] nodes = descriptor.getNodes();
        AdvancedCache[] caches = new AdvancedCache[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            caches[i] = this.advancedCache(nodes[i]);
        }
        return caches;
    }

    protected void isolatePartition(int[] isolatedPartition) {
        List allMembers = this.channel(0).getView().getMembers();
        Partition p0 = new Partition(allMembers);
        IntStream.range(0, allMembers.size()).forEach(i -> p0.addNode(this.channel(i)));
        Partition p1 = new Partition(allMembers);
        Arrays.stream(isolatedPartition).forEach(i -> p1.addNode(this.channel(i)));
        p1.partition();
        this.partitions = new Partition[]{p0, p1};
    }

    private JChannel channel(int i) {
        return this.channel(this.manager(i));
    }

    protected JChannel channel(Cache<?, ?> cache) {
        return this.channel(cache.getCacheManager());
    }

    protected JChannel channel(EmbeddedCacheManager manager) {
        return TestingUtil.extractJChannel(manager);
    }

    protected Partition partition(int i) {
        if (this.partitions == null) {
            throw new IllegalStateException("splitCluster(..) must be invoked before this method!");
        }
        return this.partitions[i];
    }

    protected PartitionHandlingManager partitionHandlingManager(int index) {
        return this.partitionHandlingManager((Cache<?, ?>)this.advancedCache(index));
    }

    protected PartitionHandlingManager partitionHandlingManager(Cache<?, ?> cache) {
        return TestingUtil.extractComponent(cache, PartitionHandlingManager.class);
    }

    protected void assertExpectedValue(Object expectedVal, Object key) {
        for (int i = 0; i < this.numMembersInCluster; ++i) {
            Assert.assertEquals((Object)this.cache(i).get(key), (Object)expectedVal);
        }
    }

    public class Partition {
        private final List<Address> allMembers;
        List<JChannel> channels = new ArrayList<JChannel>();

        public Partition(List<Address> allMembers) {
            this.allMembers = allMembers;
        }

        public void addNode(JChannel c) {
            this.channels.add(c);
        }

        public void partition() {
            log.trace((Object)"Partition forming");
            this.disableDiscovery();
            this.installNewView();
            this.assertPartitionFormed();
            log.trace((Object)"New views installed");
        }

        private void disableDiscovery() {
            this.channels.forEach(BasePartitionHandlingTest.this::disableDiscoveryProtocol);
        }

        private void assertPartitionFormed() {
            ArrayList<Address> viewMembers = new ArrayList<Address>();
            for (JChannel ac : this.channels) {
                viewMembers.add(ac.getAddress());
            }
            for (JChannel c : this.channels) {
                List members = c.getView().getMembers();
                if (!members.equals(viewMembers)) {
                    throw new AssertionError();
                }
            }
        }

        private List<Address> installNewView() {
            ArrayList<Address> viewMembers = new ArrayList<Address>();
            for (JChannel c : this.channels) {
                viewMembers.add(c.getAddress());
            }
            View view = View.create((Address)this.channels.get(0).getAddress(), (long)BasePartitionHandlingTest.this.viewId.incrementAndGet(), (Address[])viewMembers.toArray(new Address[0]));
            log.trace((Object)"Before installing new view...");
            for (JChannel c : this.channels) {
                BasePartitionHandlingTest.this.getGms(c).installView(view);
            }
            return viewMembers;
        }

        private List<Address> installMergeView(ArrayList<JChannel> view1, ArrayList<JChannel> view2) {
            List<Address> allAddresses = Stream.concat(view1.stream(), view2.stream()).map(JChannel::getAddress).distinct().collect(Collectors.toList());
            View v1 = this.toView(view1);
            View v2 = this.toView(view2);
            ArrayList<View> allViews = new ArrayList<View>();
            allViews.add(v1);
            allViews.add(v2);
            for (JChannel c : this.channels) {
                STABLE stable = (STABLE)c.getProtocolStack().findProtocol(STABLE.class);
                stable.gc();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            MergeView mv = new MergeView(view1.get(0).getAddress(), (long)BasePartitionHandlingTest.this.viewId.incrementAndGet(), allAddresses, allViews);
            MutableDigest digest = new MutableDigest(allAddresses.toArray(new Address[0]));
            for (JChannel c : this.channels) {
                digest.merge(BasePartitionHandlingTest.this.getGms(c).getDigest());
            }
            for (JChannel c : this.channels) {
                BasePartitionHandlingTest.this.getGms(c).installView((View)mv, (Digest)digest);
            }
            return this.allMembers;
        }

        private View toView(ArrayList<JChannel> channels) {
            ArrayList<Address> viewMembers = new ArrayList<Address>();
            for (JChannel c : channels) {
                viewMembers.add(c.getAddress());
            }
            return View.create((Address)channels.get(0).getAddress(), (long)BasePartitionHandlingTest.this.viewId.incrementAndGet(), (Address[])viewMembers.toArray(new Address[0]));
        }

        private void discardOtherMembers() {
            ArrayList<Address> outsideMembers = new ArrayList<Address>();
            for (Address a : this.allMembers) {
                boolean inThisPartition = false;
                for (JChannel c : this.channels) {
                    if (!c.getAddress().equals((Object)a)) continue;
                    inThisPartition = true;
                }
                if (inThisPartition) continue;
                outsideMembers.add(a);
            }
            for (JChannel c : this.channels) {
                DISCARD discard = new DISCARD();
                log.tracef("%s discarding messages from %s", (Object)c.getAddress(), outsideMembers);
                for (Address a : outsideMembers) {
                    discard.addIgnoreMember(a);
                }
                try {
                    c.getProtocolStack().insertProtocol((Protocol)discard, ProtocolStack.Position.ABOVE, TP.class);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public String toString() {
            StringBuilder addresses = new StringBuilder();
            for (JChannel c : this.channels) {
                addresses.append(c.getAddress()).append(" ");
            }
            return "Partition{" + String.valueOf(addresses) + "}";
        }

        public void merge(Partition partition) {
            this.merge(partition, true);
        }

        public void merge(Partition partition, boolean waitForNoRebalance) {
            this.observeMembers(partition);
            partition.observeMembers(this);
            ArrayList<JChannel> view1 = new ArrayList<JChannel>(this.channels);
            ArrayList<JChannel> view2 = new ArrayList<JChannel>(partition.channels);
            partition.channels.stream().filter(c -> !this.channels.contains(c)).forEach(c -> this.channels.add((JChannel)c));
            this.installMergeView(view1, view2);
            this.enableDiscovery();
            this.waitForPartitionToForm(waitForNoRebalance);
            ArrayList<Partition> tmp = new ArrayList<Partition>(Arrays.asList(BasePartitionHandlingTest.this.partitions));
            if (!tmp.remove(partition)) {
                throw new AssertionError();
            }
            BasePartitionHandlingTest.this.partitions = tmp.toArray(new Partition[0]);
        }

        private String printView(ArrayList<JChannel> view1) {
            StringBuilder sb = new StringBuilder();
            for (JChannel c : view1) {
                sb.append(c.getAddress()).append(" ");
            }
            return sb.insert(0, "[ ").append(" ]").toString();
        }

        private void waitForPartitionToForm(boolean waitForNoRebalance) {
            ArrayList<Cache> caches = new ArrayList<Cache>(BasePartitionHandlingTest.this.getCaches(BasePartitionHandlingTest.this.customCacheName()));
            caches.removeIf(objectObjectCache -> !this.channels.contains(BasePartitionHandlingTest.this.channel((Cache<?, ?>)objectObjectCache)));
            Cache cache = (Cache)caches.get(0);
            TestingUtil.blockUntilViewsReceived(10000, caches);
            if (waitForNoRebalance && cache.getCacheConfiguration().clustering().cacheMode().isClustered()) {
                TestingUtil.waitForNoRebalance(caches);
            }
        }

        public void enableDiscovery() {
            this.channels.forEach(BasePartitionHandlingTest.this::enableDiscoveryProtocol);
            log.trace((Object)"Discovery started.");
        }

        private void observeMembers(Partition partition) {
            for (JChannel c : this.channels) {
                List protocols = c.getProtocolStack().getProtocols();
                for (Protocol p : protocols) {
                    if (!(p instanceof DISCARD)) continue;
                    for (JChannel oc : partition.channels) {
                        ((DISCARD)p).removeIgnoredMember(oc.getAddress());
                    }
                }
            }
        }

        public void assertDegradedMode() {
            if (BasePartitionHandlingTest.this.partitionHandling != PartitionHandling.ALLOW_READ_WRITES) {
                this.assertAvailabilityMode(AvailabilityMode.DEGRADED_MODE);
            }
            this.assertActualMembers();
        }

        public void assertKeyAvailableForRead(Object k, Object expectedValue) {
            for (Cache c : this.cachesInThisPartition()) {
                BasePartitionHandlingTest.this.assertKeyAvailableForRead(c, k, expectedValue);
            }
        }

        public void assertKeyAvailableForWrite(Object k, Object newValue) {
            for (Cache c : this.cachesInThisPartition()) {
                c.put(k, newValue);
                Assert.assertEquals((Object)c.get(k), (Object)newValue, (String)("Cache " + String.valueOf(c.getAdvancedCache().getRpcManager().getAddress()) + " doesn't see the right value"));
            }
        }

        protected void assertKeysNotAvailableForRead(Object ... keys) {
            for (Object k : keys) {
                this.assertKeyNotAvailableForRead(k);
            }
        }

        public void assertKeyNotAvailableForRead(Object key) {
            for (Cache c : this.cachesInThisPartition()) {
                BasePartitionHandlingTest.this.assertKeyNotAvailableForRead(c, key);
            }
        }

        private <K, V> List<Cache<K, V>> cachesInThisPartition() {
            ArrayList<Cache<K, V>> caches = new ArrayList<Cache<K, V>>();
            for (Cache c : BasePartitionHandlingTest.this.caches(BasePartitionHandlingTest.this.customCacheName())) {
                JChannel ch = BasePartitionHandlingTest.this.channel(c);
                if (!this.channels.contains(ch)) continue;
                caches.add(c);
            }
            return caches;
        }

        public void assertExceptionWithForceLock(Object key) {
            this.cachesInThisPartition().forEach(c -> Exceptions.expectException(AvailabilityException.class, () -> c.getAdvancedCache().withFlags(Flag.FORCE_WRITE_LOCK).get(key)));
        }

        public void assertKeyNotAvailableForWrite(Object key) {
            this.cachesInThisPartition().forEach(c -> Exceptions.expectException(AvailabilityException.class, () -> c.put(key, key)));
        }

        public void assertKeysNotAvailableForWrite(Object ... keys) {
            for (Object k : keys) {
                this.assertKeyNotAvailableForWrite(k);
            }
        }

        public void assertAvailabilityMode(AvailabilityMode state) {
            for (Cache c : this.cachesInThisPartition()) {
                BasePartitionHandlingTest.this.eventuallyEquals(state, () -> BasePartitionHandlingTest.this.partitionHandlingManager(c).getAvailabilityMode());
            }
        }

        public void assertConsistentHashMembers(List<org.infinispan.remoting.transport.Address> expectedMembers) {
            for (Cache c : this.cachesInThisPartition()) {
                Assert.assertEquals(new HashSet(c.getAdvancedCache().getDistributionManager().getCacheTopology().getMembers()), new HashSet<org.infinispan.remoting.transport.Address>(expectedMembers));
            }
        }

        public void assertActualMembers() {
            Set expected = this.cachesInThisPartition().stream().map(c -> c.getAdvancedCache().getRpcManager().getAddress()).collect(Collectors.toSet());
            for (Cache c2 : this.cachesInThisPartition()) {
                BasePartitionHandlingTest.this.eventuallyEquals(expected, () -> new HashSet(c2.getAdvancedCache().getDistributionManager().getCacheTopology().getActualMembers()));
            }
        }

        public List<org.infinispan.remoting.transport.Address> getAddresses() {
            return this.channels.stream().map(ch -> new JGroupsAddress(ch.getAddress())).collect(Collectors.toList());
        }
    }

    public static class PartitionDescriptor {
        int[] nodes;
        AvailabilityMode expectedMode;

        public PartitionDescriptor(int ... nodes) {
            this(null, nodes);
        }

        public PartitionDescriptor(AvailabilityMode expectedMode, int ... nodes) {
            this.expectedMode = expectedMode;
            this.nodes = nodes;
        }

        public int[] getNodes() {
            return this.nodes;
        }

        public int node(int i) {
            return this.nodes[i];
        }

        public void assertAvailabilityMode(Partition partition) {
            partition.assertAvailabilityMode(this.expectedMode);
        }

        public AvailabilityMode getExpectedMode() {
            return this.expectedMode;
        }

        public String toString() {
            return Arrays.toString(this.nodes);
        }
    }

    @Listener
    public static class ViewChangedHandler {
        private volatile boolean notified = false;

        public boolean isNotified() {
            return this.notified;
        }

        public void setNotified(boolean notified) {
            this.notified = notified;
        }

        @ViewChanged
        public void viewChanged(ViewChangedEvent vce) {
            this.notified = true;
        }
    }
}

