/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.context.Flag;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.MagicKey;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.partitionhandling.AvailabilityException;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.BaseStatefulPartitionHandlingTest;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.test.TestingUtil;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.topology.PersistentUUID;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="partitionhandling.PreferConsistencyRestartTest")
public class PreferConsistencyRestartTest
extends BaseStatefulPartitionHandlingTest {
    public PreferConsistencyRestartTest() {
        this.lockingMode = null;
        this.partitionHandling = PartitionHandling.DENY_READ_WRITES;
        this.cacheMode = CacheMode.DIST_SYNC;
        this.numberOfOwners = 2;
        this.numMembersInCluster = 3;
        this.createDefault = true;
    }

    public void testCrashBeforeRecover() throws Exception {
        Map<JGroupsAddress, PersistentUUID> addressMappings = this.createInitialCluster();
        this.checkData();
        MagicKey mkOther = new MagicKey("kc", this.cache(1, "testCache"), this.cache(2, "testCache"));
        this.killManagers1and2();
        Exceptions.expectException(AvailabilityException.class, (String)"ISPN000306: Key '.*' is not available. Not all owners are in this partition", () -> this.cache(0, "testCache").put((Object)mkOther, (Object)"fail"));
        this.createStatefulCacheManager(Character.toString('B'), false);
        this.createStatefulCacheManager(Character.toString('C'), false);
        this.waitForClusterToForm();
        Exceptions.expectException(AvailabilityException.class, (String)"ISPN000306: Key '.*' is not available. Not all owners are in this partition", () -> this.cache(0, "testCache").put((Object)mkOther, (Object)"fail"));
        MagicKey mkDefault = new MagicKey("kd", this.cache(1), this.cache(2));
        this.cache(0).put((Object)mkDefault, (Object)"value");
        Assertions.assertThat((Object)this.cache(0).get((Object)mkDefault)).isEqualTo((Object)"value");
        this.killManagers1and2();
        this.createStatefulCacheManager(Character.toString('B'), false);
        this.createStatefulCacheManager(Character.toString('C'), false);
        this.waitForClusterToForm();
        if (this.isASegmentOwner(mkDefault.getSegment())) {
            Assertions.assertThat((Object)this.readKeyLocallyBOrC(mkDefault)).isEqualTo((Object)"value");
        } else {
            Assertions.assertThat((Object)this.cache(0).get((Object)mkDefault)).isEqualTo((Object)"value");
        }
        this.waitForClusterToForm("testCache");
        List members = this.cacheManagers.stream().map(EmbeddedCacheManager::getAddress).collect(Collectors.toList());
        LocalTopologyManager ltm = TestingUtil.extractGlobalComponent((CacheContainer)this.manager(0), LocalTopologyManager.class);
        PreferConsistencyRestartTest.eventually(() -> {
            List actual = ltm.getCacheTopology("testCache").getActualMembers();
            return actual.size() == members.size() && actual.containsAll(members);
        });
        this.checkClusterRestartedCorrectly(addressMappings);
        Assertions.assertThat((int)this.cache(0, "testCache").size()).isBetween(Integer.valueOf((int)((float)this.numberOfOwners / (float)this.numMembersInCluster * 100.0f)), Integer.valueOf(100));
    }

    private void killManagers1and2() throws Exception {
        EmbeddedCacheManager e2 = (EmbeddedCacheManager)this.cacheManagers.remove(2);
        EmbeddedCacheManager e1 = (EmbeddedCacheManager)this.cacheManagers.remove(1);
        e2.start();
        Future<Void> f2 = this.fork(() -> ((EmbeddedCacheManager)e2).stop());
        Future<Void> f1 = this.fork(() -> ((EmbeddedCacheManager)e1).stop());
        LocalTopologyManager ltm = TestingUtil.extractGlobalComponent((CacheContainer)this.manager(0), LocalTopologyManager.class);
        PreferConsistencyRestartTest.eventually(() -> ltm.getCacheAvailability("testCache") == AvailabilityMode.DEGRADED_MODE);
        PreferConsistencyRestartTest.eventually(() -> ltm.getCacheTopology("testCache").getActualMembers().size() == 1);
        f2.get(10L, TimeUnit.SECONDS);
        f1.get(10L, TimeUnit.SECONDS);
    }

    private boolean isASegmentOwner(int segment) {
        LocalizedCacheTopology cacheTopology = this.cache(0).getAdvancedCache().getDistributionManager().getCacheTopology();
        return cacheTopology.getSegmentDistribution(segment).isPrimary() || cacheTopology.getSegmentDistribution(segment).isReadOwner();
    }

    private Object readKeyLocallyBOrC(MagicKey mk) {
        Object v = this.cache(1).getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL).get((Object)mk);
        return v == null ? this.cache(2).getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL).get((Object)mk) : v;
    }
}

