/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling;

import java.util.stream.BaseStream;
import org.infinispan.Cache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.context.Flag;
import org.infinispan.distribution.MagicKey;
import org.infinispan.partitionhandling.StreamDistPartitionHandlingTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="partitionhandling.StreamReplPartitionHandlingTest")
public class StreamReplPartitionHandlingTest
extends StreamDistPartitionHandlingTest {
    public StreamReplPartitionHandlingTest() {
        this.cacheMode = CacheMode.REPL_SYNC;
    }

    @Override
    @Test(enabled=false)
    public void testUsingIteratorButPartitionOccursBeforeRetrievingRemoteValues() throws InterruptedException {
    }

    @Override
    @Test(enabled=false)
    public void testUsingIteratorButPartitionOccursAfterRetrievingRemoteValues() throws InterruptedException {
    }

    @Override
    public void testRetrievalWhenPartitionIsDegradedButLocal() {
        Cache cache0 = this.cache(0);
        cache0.put((Object)new MagicKey(this.cache(1), this.cache(2)), (Object)"not-local");
        cache0.put((Object)new MagicKey(this.cache(0), this.cache(1)), (Object)"local");
        this.splitCluster({0, 1}, {2, 3});
        this.partition(0).assertDegradedMode();
        try (CloseableIterator iterator = Closeables.iterator((BaseStream)cache0.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL).entrySet().stream());){
            AssertJUnit.assertNotNull((Object)iterator.next());
            AssertJUnit.assertNotNull((Object)iterator.next());
            AssertJUnit.assertFalse((boolean)iterator.hasNext());
        }
    }
}

