/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.CompletionStage;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.distribution.BaseDistStoreTest;
import org.infinispan.encoding.DataConversion;
import org.infinispan.persistence.sifs.Compactor;
import org.infinispan.persistence.sifs.EntryHeader;
import org.infinispan.persistence.sifs.SoftIndexFileStoreRestartTest;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.persistence.support.WaitDelegatingNonBlockingStore;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.sifs.SoftIndexFileStoreCorruptRestartTest")
public class SoftIndexFileStoreCorruptRestartTest
extends BaseDistStoreTest<Integer, String, SoftIndexFileStoreRestartTest> {
    protected String tmpDirectory;

    public SoftIndexFileStoreCorruptRestartTest() {
        this.INIT_CLUSTER_SIZE = 1;
        this.l1CacheEnabled = false;
        this.segmented = true;
    }

    @Override
    public Object[] factory() {
        return new Object[]{new SoftIndexFileStoreCorruptRestartTest().cacheMode(CacheMode.LOCAL), new SoftIndexFileStoreCorruptRestartTest().cacheMode(CacheMode.DIST_SYNC)};
    }

    @Override
    @BeforeClass(alwaysRun=true)
    public void createBeforeClass() throws Throwable {
        this.tmpDirectory = CommonsTestingUtil.tmpDirectory(this.getClass());
        super.createBeforeClass();
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void destroy() {
        super.destroy();
        Util.recursiveFileRemove((String)this.tmpDirectory);
    }

    @Override
    protected StoreConfigurationBuilder addStore(PersistenceConfigurationBuilder persistenceConfigurationBuilder, boolean shared) {
        assert (!shared);
        return persistenceConfigurationBuilder.addSoftIndexFileStore().dataLocation(Paths.get(this.tmpDirectory, "data").toString()).indexLocation(Paths.get(this.tmpDirectory, "index").toString());
    }

    @Test(dataProvider="booleans")
    public void testRestartWithEmptyDataFile(boolean deleteIndex) throws Throwable {
        File file;
        this.cache(0, this.cacheName).put((Object)"some-value", (Object)"1");
        AssertJUnit.assertEquals((int)1, (int)this.cache(0, this.cacheName).size());
        this.killMember(0, this.cacheName);
        if (deleteIndex) {
            Util.recursiveFileRemove((Path)Paths.get(this.tmpDirectory, "index"));
        }
        if (!(file = Paths.get(this.tmpDirectory, "data", this.cacheName, "data", "ispn12.123").toFile()).createNewFile()) {
            AssertJUnit.fail((String)("Unable to create file: " + String.valueOf(file)));
        }
        this.createCacheManagers();
        WaitDelegatingNonBlockingStore store = TestingUtil.getFirstStoreWait(this.cache(0, this.cacheName));
        Compactor compactor = (Compactor)TestingUtil.extractField(store.delegate(), "compactor");
        CompletionStages.join((CompletionStage)compactor.forceCompactionForAllNonLogFiles());
        AssertJUnit.assertEquals((int)1, (int)this.cache(0, this.cacheName).size());
    }

    MarshallableEntry objectToMarshalledBuffer(Object obj) {
        DataConversion dc = this.cache(0, this.cacheName).getAdvancedCache().getKeyDataConversion();
        Object storedKey = dc.toStorage(obj);
        MarshallableEntryFactory mef = TestingUtil.extractComponent(this.cache(0, this.cacheName), MarshallableEntryFactory.class);
        return mef.create(storedKey);
    }

    @DataProvider(name="booleans")
    Object[][] booleans() {
        return new Object[][]{{Boolean.TRUE}, {Boolean.FALSE}};
    }

    @Test(dataProvider="booleans")
    public void testRestartWithPartialKeyWritten(boolean deleteIndex) throws Throwable {
        File file;
        this.cache(0, this.cacheName).put((Object)"some-value", (Object)"1");
        AssertJUnit.assertEquals((int)1, (int)this.cache(0, this.cacheName).size());
        ByteBuffer keyBytes = this.objectToMarshalledBuffer("key-1").getKeyBytes();
        java.nio.ByteBuffer trimmedKey = java.nio.ByteBuffer.wrap(keyBytes.getBuf(), 0, keyBytes.getLength() - 1);
        this.killMember(0, this.cacheName);
        if (deleteIndex) {
            Util.recursiveFileRemove((Path)Paths.get(this.tmpDirectory, "index"));
        }
        if (!(file = Paths.get(this.tmpDirectory, "data", this.cacheName, "data", "ispn12.123").toFile()).createNewFile()) {
            AssertJUnit.fail((String)("Unable to create file: " + String.valueOf(file)));
        }
        try (FileOutputStream stream = new FileOutputStream(file);){
            FileChannel channel = stream.getChannel();
            java.nio.ByteBuffer buffer = java.nio.ByteBuffer.allocate(27);
            EntryHeader.writeHeader((java.nio.ByteBuffer)buffer, (short)((short)(trimmedKey.remaining() + 2)), (short)0, (int)0, (short)0, (long)20L, (long)-1L);
            buffer.flip();
            int writeCount = channel.write(buffer);
            AssertJUnit.assertEquals((int)27, (int)writeCount);
            int expected = trimmedKey.remaining();
            AssertJUnit.assertEquals((int)expected, (int)channel.write(trimmedKey));
        }
        this.createCacheManagers();
        WaitDelegatingNonBlockingStore store = TestingUtil.getFirstStoreWait(this.cache(0, this.cacheName));
        Compactor compactor = (Compactor)TestingUtil.extractField(store.delegate(), "compactor");
        CompletionStages.join((CompletionStage)compactor.forceCompactionForAllNonLogFiles());
        AssertJUnit.assertEquals((int)1, (int)this.cache(0, this.cacheName).size());
    }

    @Test(dataProvider="booleans")
    public void testRestartWithOnlyHeaderWritten(boolean deleteIndex) throws Throwable {
        File file;
        this.cache(0, this.cacheName).put((Object)"some-value", (Object)"1");
        AssertJUnit.assertEquals((int)1, (int)this.cache(0, this.cacheName).size());
        this.killMember(0, this.cacheName);
        if (deleteIndex) {
            Util.recursiveFileRemove((Path)Paths.get(this.tmpDirectory, "index"));
        }
        if (!(file = Paths.get(this.tmpDirectory, "data", this.cacheName, "data", "ispn12.123").toFile()).createNewFile()) {
            AssertJUnit.fail((String)("Unable to create file: " + String.valueOf(file)));
        }
        try (FileOutputStream stream = new FileOutputStream(file);){
            FileChannel channel = stream.getChannel();
            java.nio.ByteBuffer buffer = java.nio.ByteBuffer.allocate(27);
            EntryHeader.writeHeader((java.nio.ByteBuffer)buffer, (short)10, (short)0, (int)100, (short)0, (long)20L, (long)-1L);
            buffer.flip();
            int writeCount = channel.write(buffer);
            AssertJUnit.assertEquals((int)27, (int)writeCount);
        }
        this.createCacheManagers();
        WaitDelegatingNonBlockingStore store = TestingUtil.getFirstStoreWait(this.cache(0, this.cacheName));
        Compactor compactor = (Compactor)TestingUtil.extractField(store.delegate(), "compactor");
        CompletionStages.join((CompletionStage)compactor.forceCompactionForAllNonLogFiles());
        AssertJUnit.assertEquals((int)1, (int)this.cache(0, this.cacheName).size());
    }
}

