/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import java.nio.file.Paths;
import org.infinispan.Cache;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.sifs.SoftIndexFileStoreSplitInnerNodeTest")
public class SoftIndexFileStoreSplitInnerNodeTest
extends MultipleCacheManagersTest {
    protected String tmpDirectory;
    private final int MAX_ENTRIES = 598;
    private static final String CACHE_NAME = "SIFS-Backed";
    private Cache<Object, Object> c1;

    @BeforeSuite(alwaysRun=true)
    protected void setUpTempDir() {
        this.tmpDirectory = CommonsTestingUtil.tmpDirectory(this.getClass());
    }

    @AfterSuite(alwaysRun=true)
    protected void clearTempDir() {
        Util.recursiveFileRemove((String)this.tmpDirectory);
    }

    @Override
    protected void createCacheManagers() {
        this.createCluster(2);
        for (EmbeddedCacheManager manager : this.managers()) {
            ConfigurationBuilder cb = SoftIndexFileStoreSplitInnerNodeTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
            cb.clustering().hash().numSegments(1);
            ((SoftIndexFileStoreConfigurationBuilder)((SoftIndexFileStoreConfigurationBuilder)cb.memory().maxCount((long)Math.ceil(119.60000000000001)).persistence().passivation(false).addSoftIndexFileStore().dataLocation(Paths.get(this.tmpDirectory, manager.getAddress().toString(), "data").toString()).indexLocation(Paths.get(this.tmpDirectory, manager.getAddress().toString(), "index").toString()).purgeOnStartup(true)).preload(false)).expiration().wakeUpInterval(Long.MAX_VALUE).indexing().disable();
            TestingUtil.defineConfiguration(manager, CACHE_NAME, cb.build());
        }
        this.c1 = this.cache(0, CACHE_NAME);
    }

    public void testPopulatingAndQueryingSize() {
        for (int i = 0; i < 598; ++i) {
            this.c1.put((Object)("k" + i), (Object)("v" + i));
        }
        AssertJUnit.assertEquals((int)598, (int)this.c1.size());
    }
}

