/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.replication;

import java.util.HashMap;
import org.infinispan.AdvancedCache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="replication.ReplicatedAPITest")
public class ReplicatedAPITest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder build = ReplicatedAPITest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true);
        build.clustering().stateTransfer().timeout(30000L);
        this.createClusteredCaches(2, "replication", build);
    }

    public void put() {
        AdvancedCache cache1 = this.advancedCache(0, "replication");
        AdvancedCache cache2 = this.advancedCache(1, "replication");
        assert (cache1.get((Object)"key") == null);
        assert (cache2.get((Object)"key") == null);
        cache1.put((Object)"key", (Object)"value");
        assert (((String)cache1.get((Object)"key")).equals("value"));
        assert (((String)cache2.get((Object)"key")).equals("value"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key2", "value2");
        map.put("key3", "value3");
        cache1.putAll(map);
        assert (((String)cache1.get((Object)"key")).equals("value"));
        assert (((String)cache2.get((Object)"key")).equals("value"));
        assert (((String)cache1.get((Object)"key2")).equals("value2"));
        assert (((String)cache2.get((Object)"key2")).equals("value2"));
        assert (((String)cache1.get((Object)"key3")).equals("value3"));
        assert (((String)cache2.get((Object)"key3")).equals("value3"));
    }

    public void remove() {
        AdvancedCache cache1 = this.advancedCache(0, "replication");
        AdvancedCache cache2 = this.advancedCache(1, "replication");
        cache2.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)"key", (Object)"value");
        assert (((String)cache2.get((Object)"key")).equals("value"));
        assert (cache1.get((Object)"key") == null);
        cache1.remove((Object)"key");
        assert (cache1.get((Object)"key") == null);
        assert (cache2.get((Object)"key") == null);
        cache1.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)"key", (Object)"value");
        cache2.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)"key", (Object)"value");
        assert (((String)cache1.get((Object)"key")).equals("value"));
        assert (((String)cache2.get((Object)"key")).equals("value"));
        cache1.remove((Object)"key");
        assert (cache1.get((Object)"key") == null);
        assert (cache2.get((Object)"key") == null);
    }

    public void testPutIfAbsent() {
        AdvancedCache cache1 = this.advancedCache(0, "replication");
        AdvancedCache cache2 = this.advancedCache(1, "replication");
        cache2.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)"key", (Object)"valueOld");
        assert (((String)cache2.get((Object)"key")).equals("valueOld"));
        assert (cache1.get((Object)"key") == null);
        cache1.putIfAbsent((Object)"key", (Object)"value");
        AssertJUnit.assertEquals((String)"value", (String)((String)cache1.get((Object)"key")));
        AssertJUnit.assertEquals((String)"value", (String)((String)cache2.get((Object)"key")));
        cache2.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)"key", (Object)"value3");
        assert (((String)cache1.get((Object)"key")).equals("value"));
        assert (((String)cache2.get((Object)"key")).equals("value3"));
        cache1.putIfAbsent((Object)"key", (Object)"value4");
        assert (((String)cache1.get((Object)"key")).equals("value"));
        assert (((String)cache2.get((Object)"key")).equals("value3"));
    }

    public void testRemoveIfPresent() {
        AdvancedCache cache1 = this.advancedCache(0, "replication");
        AdvancedCache cache2 = this.advancedCache(1, "replication");
        cache1.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)"key", (Object)"value1");
        cache2.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)"key", (Object)"value2");
        assert (((String)cache1.get((Object)"key")).equals("value1"));
        assert (((String)cache2.get((Object)"key")).equals("value2"));
        cache1.remove((Object)"key", (Object)"value");
        assert (((String)cache1.get((Object)"key")).equals("value1")) : "Should not remove";
        assert (((String)cache2.get((Object)"key")).equals("value2")) : "Should not remove";
        cache1.remove((Object)"key", (Object)"value1");
        assert (cache1.get((Object)"key") == null);
        assert (cache2.get((Object)"key") == null);
    }

    public void testClear() {
        AdvancedCache cache1 = this.advancedCache(0, "replication");
        AdvancedCache cache2 = this.advancedCache(1, "replication");
        cache1.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)"key", (Object)"value1");
        cache2.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)"key", (Object)"value2");
        assert (((String)cache1.get((Object)"key")).equals("value1"));
        assert (((String)cache2.get((Object)"key")).equals("value2"));
        cache1.clear();
        assert (cache1.get((Object)"key") == null);
        assert (cache2.get((Object)"key") == null);
    }

    public void testReplace() {
        AdvancedCache cache1 = this.advancedCache(0, "replication");
        AdvancedCache cache2 = this.advancedCache(1, "replication");
        cache2.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)"key", (Object)"value2");
        assert (cache1.get((Object)"key") == null);
        assert (((String)cache2.get((Object)"key")).equals("value2"));
        cache1.replace((Object)"key", (Object)"value1");
        assert (cache1.get((Object)"key") == null);
        assert (((String)cache2.get((Object)"key")).equals("value2"));
        cache1.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)"key", (Object)"valueN");
        cache1.replace((Object)"key", (Object)"value1");
        assert (((String)cache1.get((Object)"key")).equals("value1"));
        assert (((String)cache2.get((Object)"key")).equals("value1"));
    }

    public void testReplaceWithOldVal() {
        AdvancedCache cache1 = this.advancedCache(0, "replication");
        AdvancedCache cache2 = this.advancedCache(1, "replication");
        cache2.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)"key", (Object)"value2");
        assert (cache1.get((Object)"key") == null);
        assert (((String)cache2.get((Object)"key")).equals("value2"));
        cache1.replace((Object)"key", (Object)"valueOld", (Object)"value1");
        assert (cache1.get((Object)"key") == null);
        assert (((String)cache2.get((Object)"key")).equals("value2"));
        cache1.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)"key", (Object)"valueN");
        cache1.replace((Object)"key", (Object)"valueOld", (Object)"value1");
        assert (((String)cache1.get((Object)"key")).equals("valueN"));
        assert (((String)cache2.get((Object)"key")).equals("value2"));
        cache1.replace((Object)"key", (Object)"valueN", (Object)"value1");
        AssertJUnit.assertEquals((String)"value1", (String)((String)cache1.get((Object)"key")));
        AssertJUnit.assertEquals((String)"value1", (String)((String)cache2.get((Object)"key")));
    }

    public void testLocalOnlyClear() {
        AdvancedCache cache1 = this.advancedCache(0, "replication");
        AdvancedCache cache2 = this.advancedCache(1, "replication");
        cache1.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)"key", (Object)"value1");
        cache2.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)"key", (Object)"value2");
        assert (((String)cache1.get((Object)"key")).equals("value1"));
        assert (((String)cache2.get((Object)"key")).equals("value2"));
        cache1.withFlags(Flag.CACHE_MODE_LOCAL).clear();
        assert (cache1.get((Object)"key") == null);
        assert (cache2.get((Object)"key") != null);
        assert (((String)cache2.get((Object)"key")).equals("value2"));
    }
}

