/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.replication;

import jakarta.transaction.TransactionManager;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.InCacheMode;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="replication.SyncLockingTest")
@InCacheMode(value={CacheMode.DIST_SYNC, CacheMode.REPL_SYNC})
public class SyncLockingTest
extends MultipleCacheManagersTest {
    private String k = "key";
    private String v = "value";

    public SyncLockingTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfg = SyncLockingTest.getDefaultClusteredCacheConfig(this.cacheMode, true);
        cfg.transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup()).lockingMode(LockingMode.PESSIMISTIC).locking().lockAcquisitionTimeout(TestingUtil.shortTimeoutMillis());
        this.createClusteredCaches(2, "testcache", cfg);
        this.waitForClusterToForm("testcache");
    }

    public void testLocksReleasedWithoutExplicitUnlock() throws Exception {
        this.locksReleasedWithoutExplicitUnlockHelper(false, false);
        this.locksReleasedWithoutExplicitUnlockHelper(true, false);
        this.locksReleasedWithoutExplicitUnlockHelper(false, true);
        this.locksReleasedWithoutExplicitUnlockHelper(true, true);
    }

    public void testConcurrentNonTxLocking() throws Exception {
        this.concurrentLockingHelper(false, false);
        this.concurrentLockingHelper(true, false);
    }

    public void testConcurrentTxLocking() throws Exception {
        this.concurrentLockingHelper(false, true);
        this.concurrentLockingHelper(true, true);
    }

    public void testLocksReleasedWithNoMods() throws Exception {
        Cache cache1 = this.cache(0, "testcache");
        Cache cache2 = this.cache(1, "testcache");
        this.assertClusterSize("Should only be 2  caches in the cluster!!!", 2);
        AssertJUnit.assertNull((String)"Should be null", (Object)cache1.get((Object)this.k));
        AssertJUnit.assertNull((String)"Should be null", (Object)cache2.get((Object)this.k));
        TransactionManager mgr = TestingUtil.getTransactionManager(cache1);
        mgr.begin();
        cache1.getAdvancedCache().lock(new Object[]{this.k});
        cache1.get((Object)this.k);
        mgr.commit();
        this.assertEventuallyNotLocked(cache1, "testcache");
        this.assertEventuallyNotLocked(cache2, "testcache");
        assert (cache1.isEmpty());
        assert (cache2.isEmpty());
        cache1.clear();
        cache2.clear();
    }

    public void testReplaceNonExistentKey() throws Exception {
        Cache cache1 = this.cache(0, "testcache");
        Cache cache2 = this.cache(1, "testcache");
        this.assertClusterSize("Should only be 2  caches in the cluster!!!", 2);
        TransactionManager mgr = TestingUtil.getTransactionManager(cache1);
        mgr.begin();
        cache1.getAdvancedCache().lock(new Object[]{this.k});
        Object old = cache1.replace((Object)this.k, (Object)"blah");
        AssertJUnit.assertNull((String)"Should be null", (Object)cache1.get((Object)this.k));
        boolean replaced = cache1.replace((Object)this.k, (Object)"Vladimir", (Object)"Blagojevic");
        assert (!replaced);
        AssertJUnit.assertNull((String)"Should be null", (Object)cache1.get((Object)this.k));
        mgr.commit();
        this.assertEventuallyNotLocked(cache1, "testcache");
        this.assertEventuallyNotLocked(cache2, "testcache");
        assert (cache1.isEmpty());
        assert (cache2.isEmpty());
        cache1.clear();
        cache2.clear();
    }

    private void concurrentLockingHelper(final boolean sameNode, final boolean useTx) throws Exception {
        log.debugf("sameNode=%s, useTx=%s", (Object)sameNode, (Object)useTx);
        final Cache cache1 = this.cache(0, "testcache");
        final Cache cache2 = this.cache(1, "testcache");
        this.assertClusterSize("Should only be 2  caches in the cluster!!!", 2);
        AssertJUnit.assertNull((String)"Should be null", (Object)cache1.get((Object)this.k));
        AssertJUnit.assertNull((String)"Should be null", (Object)cache2.get((Object)this.k));
        final CountDownLatch latch = new CountDownLatch(1);
        Thread t = this.getTestThreadFactory("Worker").newThread(new Runnable(){

            @Override
            public void run() {
                log.info((Object)("Concurrent " + (useTx ? "tx" : "non-tx") + " write started " + (sameNode ? "on same node..." : "on a different node...")));
                EmbeddedTransactionManager mgr = null;
                try {
                    if (useTx) {
                        mgr = (EmbeddedTransactionManager)TestingUtil.getTransactionManager(sameNode ? cache1 : cache2);
                        mgr.begin();
                    }
                    if (sameNode) {
                        cache1.put((Object)SyncLockingTest.this.k, (Object)"JBC");
                    } else {
                        cache2.put((Object)SyncLockingTest.this.k, (Object)"JBC");
                    }
                    if (useTx && !mgr.getTransaction().runPrepare()) {
                        latch.countDown();
                        mgr.rollback();
                    }
                }
                catch (Exception e) {
                    if (useTx) {
                        try {
                            mgr.commit();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    latch.countDown();
                }
            }
        });
        String name = "Infinispan";
        TransactionManager mgr = TestingUtil.getTransactionManager(cache1);
        mgr.begin();
        log.trace((Object)"Here is where the fun starts...Here is where the fun starts...");
        cache1.getAdvancedCache().lock(new Object[]{this.k});
        t.start();
        assert (latch.await(10L, TimeUnit.SECONDS)) : "Concurrent put didn't time out!";
        cache1.put((Object)this.k, (Object)name);
        mgr.commit();
        this.assertNotLocked("testcache", (Object)this.k);
        t.join();
        cache2.remove((Object)this.k);
        assert (cache1.isEmpty());
        assert (cache2.isEmpty());
        cache1.clear();
        cache2.clear();
    }

    private void locksReleasedWithoutExplicitUnlockHelper(boolean lockPriorToPut, boolean useCommit) throws Exception {
        log.debugf("lockPriorToPut=%s, useCommit=%s", (Object)lockPriorToPut, (Object)useCommit);
        Cache cache1 = this.cache(0, "testcache");
        Cache cache2 = this.cache(1, "testcache");
        this.assertClusterSize("Should only be 2  caches in the cluster!!!", 2);
        AssertJUnit.assertNull((String)"Should be null", (Object)cache1.get((Object)this.k));
        AssertJUnit.assertNull((String)"Should be null", (Object)cache2.get((Object)this.k));
        String name = "Infinispan";
        TransactionManager mgr = TestingUtil.getTransactionManager(cache1);
        mgr.begin();
        if (lockPriorToPut) {
            cache1.getAdvancedCache().lock(new Object[]{this.k});
        }
        cache1.put((Object)this.k, (Object)name);
        if (!lockPriorToPut) {
            cache1.getAdvancedCache().lock(new Object[]{this.k});
        }
        if (useCommit) {
            mgr.commit();
        } else {
            mgr.rollback();
        }
        if (useCommit) {
            AssertJUnit.assertEquals((Object)name, (Object)cache1.get((Object)this.k));
            AssertJUnit.assertEquals((String)"Should have replicated", (Object)name, (Object)cache2.get((Object)this.k));
        } else {
            AssertJUnit.assertEquals(null, (Object)cache1.get((Object)this.k));
            AssertJUnit.assertEquals((String)"Should not have replicated", null, (Object)cache2.get((Object)this.k));
        }
        cache2.remove((Object)this.k);
        assert (cache1.isEmpty());
        assert (cache2.isEmpty());
        cache1.clear();
        cache2.clear();
    }
}

