/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.replication;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.manager.CacheContainer;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcManagerImpl;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.ReplicatedControlledConsistentHashFactory;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="replication.SyncReplTest")
public class SyncReplTest
extends MultipleCacheManagersTest {
    private String k = "key";
    private String v = "value";

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder replSync = SyncReplTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, false);
        replSync.clustering().hash().numSegments(1).consistentHashFactory((ConsistentHashFactory)new ReplicatedControlledConsistentHashFactory(0, new int[0]));
        this.createClusteredCaches(2, "replSync", replSync);
    }

    public void testBasicOperation() {
        Cache cache1 = this.cache(0, "replSync");
        Cache cache2 = this.cache(1, "replSync");
        this.assertClusterSize("Should only be 2  caches in the cluster!!!", 2);
        AssertJUnit.assertNull((String)"Should be null", (Object)cache1.get((Object)this.k));
        AssertJUnit.assertNull((String)"Should be null", (Object)cache2.get((Object)this.k));
        cache1.put((Object)this.k, (Object)this.v);
        AssertJUnit.assertEquals((String)this.v, (String)((String)cache1.get((Object)this.k)));
        AssertJUnit.assertEquals((String)"Should have replicated", (Object)this.v, (Object)cache2.get((Object)this.k));
        cache2.remove((Object)this.k);
        assert (cache1.isEmpty());
        assert (cache2.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultpleCachesOnSharedTransport() {
        Cache cache1 = this.cache(0, "replSync");
        Cache cache2 = this.cache(1, "replSync");
        this.assertClusterSize("Should only be 2  caches in the cluster!!!", 2);
        assert (cache1.isEmpty());
        assert (cache2.isEmpty());
        ConfigurationBuilder newConf = SyncReplTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, false);
        this.defineConfigurationOnAllManagers("newCache", newConf);
        Cache altCache1 = this.manager(0).getCache("newCache");
        Cache altCache2 = this.manager(1).getCache("newCache");
        try {
            assert (altCache1.isEmpty());
            assert (altCache2.isEmpty());
            cache1.put((Object)this.k, (Object)this.v);
            assert (((String)cache1.get((Object)this.k)).equals(this.v));
            assert (cache2.get((Object)this.k).equals(this.v));
            assert (altCache1.isEmpty());
            assert (altCache2.isEmpty());
            altCache1.put((Object)this.k, (Object)"value2");
            assert (((String)altCache1.get((Object)this.k)).equals("value2"));
            assert (altCache2.get((Object)this.k).equals("value2"));
            assert (((String)cache1.get((Object)this.k)).equals(this.v));
            assert (cache2.get((Object)this.k).equals(this.v));
        }
        finally {
            this.removeCacheFromCluster("newCache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReplicateToNonExistentCache() {
        boolean strictPeerToPeer = false;
        Cache cache1 = this.cache(0, "replSync");
        Cache cache2 = this.cache(1, "replSync");
        this.assertClusterSize("Should only be 2  caches in the cluster!!!", 2);
        assert (cache1.isEmpty());
        assert (cache2.isEmpty());
        ConfigurationBuilder newConf = SyncReplTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, false);
        this.defineConfigurationOnAllManagers("newCache2", newConf);
        Cache altCache1 = this.manager(0).getCache("newCache2");
        try {
            assert (altCache1.isEmpty());
            cache1.put((Object)this.k, (Object)this.v);
            assert (((String)cache1.get((Object)this.k)).equals(this.v));
            assert (cache2.get((Object)this.k).equals(this.v));
            assert (altCache1.isEmpty());
            altCache1.put((Object)this.k, (Object)"value2");
            assert (((String)altCache1.get((Object)this.k)).equals("value2"));
            assert (((String)cache1.get((Object)this.k)).equals(this.v));
            assert (cache2.get((Object)this.k).equals(this.v));
            assert (this.manager(0).getCache("newCache2").get((Object)this.k).equals("value2"));
        }
        finally {
            this.removeCacheFromCluster("newCache2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMixingSyncAndAsyncOnSameTransport() throws Exception {
        RpcManagerImpl asyncRpcManager;
        Transport originalTransport;
        block5: {
            Cache cache1 = this.cache(0, "replSync");
            this.cache(1, "replSync");
            this.waitForClusterToForm("replSync");
            originalTransport = null;
            RpcManagerImpl rpcManager = null;
            asyncRpcManager = null;
            try {
                ConfigurationBuilder asyncCache = SyncReplTest.getDefaultClusteredCacheConfig(CacheMode.REPL_ASYNC, false);
                asyncCache.clustering().hash().numSegments(1).consistentHashFactory((ConsistentHashFactory)new ReplicatedControlledConsistentHashFactory(0, new int[0]));
                this.defineConfigurationOnAllManagers("asyncCache", asyncCache);
                Cache asyncCache1 = this.manager(0).getCache("asyncCache");
                this.manager(1).getCache("asyncCache");
                this.waitForClusterToForm("asyncCache");
                originalTransport = TestingUtil.extractGlobalComponent((CacheContainer)cache1.getCacheManager(), Transport.class);
                Transport mockTransport = (Transport)Mockito.spy((Object)originalTransport);
                rpcManager = (RpcManagerImpl)TestingUtil.extractComponent(cache1, RpcManager.class);
                rpcManager.setTransport(mockTransport);
                cache1.put((Object)"k", (Object)"v");
                ((Transport)Mockito.verify((Object)mockTransport)).invokeCommandOnAll((Collection)Mockito.any(), (ReplicableCommand)Mockito.any(), (ResponseCollector)Mockito.any(), (DeliverOrder)Mockito.any(), ArgumentMatchers.anyLong(), (TimeUnit)((Object)Mockito.any()));
                asyncRpcManager = (RpcManagerImpl)TestingUtil.extractComponent(asyncCache1, RpcManager.class);
                asyncRpcManager.setTransport(mockTransport);
                Mockito.reset((Object[])new Transport[]{mockTransport});
                asyncCache1.put((Object)"k", (Object)"v");
                ((Transport)Mockito.verify((Object)mockTransport)).sendToAll((ReplicableCommand)Mockito.any(ReplicableCommand.class), (DeliverOrder)Mockito.any(DeliverOrder.class));
                if (rpcManager == null) break block5;
            }
            catch (Throwable throwable) {
                if (rpcManager != null) {
                    rpcManager.setTransport(originalTransport);
                }
                if (asyncRpcManager != null) {
                    asyncRpcManager.setTransport(originalTransport);
                }
                throw throwable;
            }
            rpcManager.setTransport(originalTransport);
        }
        if (asyncRpcManager != null) {
            asyncRpcManager.setTransport(originalTransport);
        }
    }
}

