/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security;

import java.security.Principal;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.Role;
import org.infinispan.security.Security;
import org.infinispan.security.mappers.ClusterRoleMapper;
import org.infinispan.security.mappers.IdentityRoleMapper;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="security.SecurityXmlFileParsingTest")
public class SecurityXmlFileParsingTest
extends AbstractInfinispanTest {
    Subject ADMIN = TestingUtil.makeSubject("admin", "admin");

    public void testParseAndConstructUnifiedXmlFile() {
        Security.doAs((Subject)this.ADMIN, () -> TestingUtil.withCacheManager(new CacheManagerCallable((EmbeddedCacheManager)Exceptions.unchecked(() -> TestCacheManagerFactory.fromXml("configs/security.xml", true))){

            @Override
            public void call() {
                GlobalConfiguration g = this.cm.getCacheManagerConfiguration();
                AssertJUnit.assertTrue((boolean)g.security().authorization().enabled());
                AssertJUnit.assertEquals(IdentityRoleMapper.class, (Object)g.security().authorization().principalRoleMapper().getClass());
                Map globalRoles = g.security().authorization().roles();
                AssertJUnit.assertTrue((boolean)globalRoles.containsKey("supervisor"));
                AssertJUnit.assertTrue((boolean)((Role)globalRoles.get("supervisor")).getPermissions().containsAll(Arrays.asList(AuthorizationPermission.READ, AuthorizationPermission.WRITE, AuthorizationPermission.EXEC)));
                Configuration c = this.cm.getCache("secured").getCacheConfiguration();
                AssertJUnit.assertTrue((boolean)c.security().authorization().enabled());
                c.security().authorization().roles().containsAll(Arrays.asList("admin", "reader", "writer"));
            }
        }));
    }

    public void testClusterRoleMapperWithRewriter() {
        Security.doAs((Subject)this.ADMIN, () -> TestingUtil.withCacheManager(new CacheManagerCallable((EmbeddedCacheManager)Exceptions.unchecked(() -> TestCacheManagerFactory.fromXml("configs/security-role-mapper-rewriter.xml", true))){

            @Override
            public void call() {
                GlobalConfiguration g = this.cm.getCacheManagerConfiguration();
                AssertJUnit.assertTrue((boolean)g.security().authorization().enabled());
                AssertJUnit.assertEquals(ClusterRoleMapper.class, (Object)g.security().authorization().principalRoleMapper().getClass());
                ClusterRoleMapper mapper = (ClusterRoleMapper)g.security().authorization().principalRoleMapper();
                mapper.grant("supervisor", "tristan");
                Set roles = mapper.principalToRoles((Principal)new TestingUtil.TestPrincipal("cn=tristan,ou=developers,dc=infinispan,dc=org"));
                AssertJUnit.assertEquals((int)1, (int)roles.size());
                AssertJUnit.assertTrue((boolean)roles.contains("supervisor"));
            }
        }));
    }
}

