/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.statetransfer.CustomChannelLookup;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.JGroupsConfigBuilder;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.jgroups.JChannel;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(testName="statetransfer.ConcurrentStartChanelLookupTest", groups={"functional"})
@CleanupAfterMethod
public class ConcurrentStartChanelLookupTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
    }

    @DataProvider(name="startOrder")
    public Object[][] startOrder() {
        return new Object[][]{{0, 1}, {1, 0}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=60000L, dataProvider="startOrder")
    public void testConcurrentStart(int eagerManager, int lazyManager) throws Exception {
        TestResourceTracker.testThreadStarted((String)this.getTestName());
        String name1 = TestResourceTracker.getNextNodeName();
        String name2 = TestResourceTracker.getNextNodeName();
        JChannel ch1 = this.createChannel(name1, 0);
        JChannel ch2 = this.createChannel(name2, 1);
        EmbeddedCacheManager cm1 = this.createCacheManager(name1, ch1);
        EmbeddedCacheManager cm2 = this.createCacheManager(name2, ch2);
        try {
            AssertJUnit.assertEquals((Object)ComponentStatus.INSTANTIATED, (Object)TestingUtil.extractGlobalComponentRegistry((CacheContainer)cm1).getStatus());
            AssertJUnit.assertEquals((Object)ComponentStatus.INSTANTIATED, (Object)TestingUtil.extractGlobalComponentRegistry((CacheContainer)cm2).getStatus());
            log.debugf("Channels created. Starting the caches", new Object[0]);
            Future<Object> repl1Future = this.fork(() -> this.manager(eagerManager).getCache());
            Thread.sleep(1000L);
            Future<Object> repl2Future = this.fork(() -> this.manager(lazyManager).getCache());
            repl1Future.get(10L, TimeUnit.SECONDS);
            repl2Future.get(10L, TimeUnit.SECONDS);
            Cache c1r = cm1.getCache();
            Cache c2r = cm2.getCache();
            TestingUtil.blockUntilViewsReceived(10000L, new CacheContainer[]{cm1, cm2});
            TestingUtil.waitForNoRebalance(c1r, c2r);
            c1r.put((Object)"key", (Object)"value");
            AssertJUnit.assertEquals((String)"value", (String)((String)c2r.get((Object)"key")));
        }
        finally {
            cm1.stop();
            cm2.stop();
            ch1.close();
            ch2.close();
        }
    }

    private EmbeddedCacheManager createCacheManager(String name1, JChannel ch1) {
        GlobalConfigurationBuilder gcb1 = new GlobalConfigurationBuilder();
        gcb1.transport().nodeName(ch1.getName()).distributedSyncTimeout(10L, TimeUnit.SECONDS);
        CustomChannelLookup.configureTransportWithChannel(gcb1, ch1, name1, false);
        ConfigurationBuilder replCfg = new ConfigurationBuilder();
        replCfg.clustering().cacheMode(CacheMode.REPL_SYNC);
        replCfg.clustering().stateTransfer().timeout(30L, TimeUnit.SECONDS);
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.newDefaultCacheManager(false, gcb1, replCfg);
        this.registerCacheManager(new CacheContainer[]{cm1});
        return cm1;
    }

    private JChannel createChannel(String name, int portRange) throws Exception {
        String configString = JGroupsConfigBuilder.getJGroupsConfig(ConcurrentStartChanelLookupTest.class.getName(), new TransportFlags());
        JChannel channel = new JChannel((InputStream)new ByteArrayInputStream(configString.getBytes()));
        channel.setName(name);
        channel.connect(ConcurrentStartChanelLookupTest.class.getSimpleName());
        log.tracef("Channel %s connected: %s", (Object)channel, (Object)channel.getViewAsString());
        return channel;
    }
}

