/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.BaseAsyncInterceptor;
import org.infinispan.interceptors.impl.InvocationContextInterceptor;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.DistStateTransferOnJoinConsistencyTest")
@CleanupAfterMethod
public class DistStateTransferOnJoinConsistencyTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(DistStateTransferOnJoinConsistencyTest.class);

    @Override
    protected final void createCacheManagers() {
    }

    protected ConfigurationBuilder createConfigurationBuilder(boolean isOptimistic) {
        ConfigurationBuilder builder = DistStateTransferOnJoinConsistencyTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true, true);
        builder.clustering().hash().numOwners(3).numSegments(2);
        builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup());
        if (isOptimistic) {
            builder.transaction().lockingMode(LockingMode.OPTIMISTIC).locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
        } else {
            builder.transaction().lockingMode(LockingMode.PESSIMISTIC);
        }
        builder.clustering().l1().disable().locking().lockAcquisitionTimeout(TestingUtil.shortTimeoutMillis());
        builder.clustering().stateTransfer().fetchInMemoryState(true).awaitInitialTransfer(false);
        return builder;
    }

    public void testRemoveOptimistic() throws Exception {
        this.testOperationDuringJoin(Operation.REMOVE, true);
    }

    public void testRemovePessimistic() throws Exception {
        this.testOperationDuringJoin(Operation.REMOVE, false);
    }

    public void testClearOptimistic() throws Exception {
        this.testOperationDuringJoin(Operation.CLEAR, true);
    }

    public void testClearPessimistic() throws Exception {
        this.testOperationDuringJoin(Operation.CLEAR, false);
    }

    public void testPutOptimistic() throws Exception {
        this.testOperationDuringJoin(Operation.PUT, true);
    }

    public void testPutPessimistic() throws Exception {
        this.testOperationDuringJoin(Operation.PUT, false);
    }

    public void testPutMapOptimistic() throws Exception {
        this.testOperationDuringJoin(Operation.PUT_MAP, true);
    }

    public void testPutMapPessimistic() throws Exception {
        this.testOperationDuringJoin(Operation.PUT_MAP, false);
    }

    public void testPutIfAbsentOptimistic() throws Exception {
        this.testOperationDuringJoin(Operation.PUT_IF_ABSENT, true);
    }

    public void testPutIfAbsentPessimistic() throws Exception {
        this.testOperationDuringJoin(Operation.PUT_IF_ABSENT, false);
    }

    public void testReplaceOptimistic() throws Exception {
        this.testOperationDuringJoin(Operation.REPLACE, true);
    }

    public void testReplacePessimistic() throws Exception {
        this.testOperationDuringJoin(Operation.REPLACE, false);
    }

    private void testOperationDuringJoin(Operation op, boolean isOptimistic) throws Exception {
        int i;
        int i2;
        ConfigurationBuilder builder = this.createConfigurationBuilder(isOptimistic);
        this.createCluster(builder, 2);
        this.waitForClusterToForm();
        int numKeys = 5;
        log.infof("Putting %d keys into cache ..", (Object)5);
        for (i2 = 0; i2 < 5; ++i2) {
            this.cache(0).put((Object)i2, (Object)("before_st_" + i2));
        }
        log.info((Object)"Finished putting keys");
        for (i2 = 0; i2 < 5; ++i2) {
            String expected = "before_st_" + i2;
            this.assertValue(0, i2, expected);
            this.assertValue(1, i2, expected);
        }
        CountDownLatch applyStateProceedLatch = new CountDownLatch(1);
        CountDownLatch applyStateStartedLatch = new CountDownLatch(1);
        GlobalConfigurationBuilder global = GlobalConfigurationBuilder.defaultClusteredBuilder();
        TestCacheManagerFactory.addInterceptor(global, "defaultcache"::equals, (AsyncInterceptor)new LatchInterceptor(applyStateStartedLatch, applyStateProceedLatch), TestCacheManagerFactory.InterceptorPosition.BEFORE, InvocationContextInterceptor.class);
        log.info((Object)"Adding a new node ..");
        this.addClusterEnabledCacheManager(global, builder);
        log.info((Object)"Added a new node");
        DataContainer dc0 = this.advancedCache(0).getDataContainer();
        DataContainer dc1 = this.advancedCache(1).getDataContainer();
        DataContainer dc2 = this.advancedCache(2).getDataContainer();
        if (!applyStateStartedLatch.await(15L, TimeUnit.SECONDS)) {
            throw new TimeoutException();
        }
        if (op == Operation.CLEAR) {
            log.info((Object)"Clearing cache ..");
            this.cache(0).clear();
            log.info((Object)"Finished clearing cache");
            AssertJUnit.assertEquals((int)0, (int)dc0.size());
            AssertJUnit.assertEquals((int)0, (int)dc1.size());
        } else if (op == Operation.REMOVE) {
            log.info((Object)"Removing all keys one by one ..");
            for (i = 0; i < 5; ++i) {
                this.cache(0).remove((Object)i);
            }
            log.info((Object)"Finished removing keys");
            AssertJUnit.assertEquals((int)0, (int)dc0.size());
            AssertJUnit.assertEquals((int)0, (int)dc1.size());
        } else if (op == Operation.PUT || op == Operation.PUT_MAP || op == Operation.REPLACE || op == Operation.PUT_IF_ABSENT) {
            log.info((Object)"Updating all keys ..");
            if (op == Operation.PUT) {
                for (int i3 = 0; i3 < 5; ++i3) {
                    this.cache(0).put((Object)i3, (Object)("after_st_" + i3));
                }
            } else if (op == Operation.PUT_MAP) {
                HashMap<Integer, CallSite> toPut = new HashMap<Integer, CallSite>();
                for (int i4 = 0; i4 < 5; ++i4) {
                    toPut.put(i4, (CallSite)((Object)("after_st_" + i4)));
                }
                this.cache(0).putAll(toPut);
            } else if (op == Operation.REPLACE) {
                for (int i5 = 0; i5 < 5; ++i5) {
                    String expectedOldValue = "before_st_" + i5;
                    boolean replaced = this.cache(0).replace((Object)i5, (Object)expectedOldValue, (Object)("after_st_" + i5));
                    AssertJUnit.assertTrue((boolean)replaced);
                }
            } else {
                for (int i6 = 0; i6 < 5; ++i6) {
                    String expectedOldValue = "before_st_" + i6;
                    Object prevValue = this.cache(0).putIfAbsent((Object)i6, (Object)("after_st_" + i6));
                    AssertJUnit.assertEquals((Object)expectedOldValue, (Object)prevValue);
                }
            }
            log.info((Object)"Finished updating keys");
        }
        applyStateProceedLatch.countDown();
        TestingUtil.waitForNoRebalance(this.cache(0), this.cache(1), this.cache(2));
        log.tracef("Data container of NodeA has %d keys: %s", dc0.size(), (Object)StreamSupport.stream(dc0.spliterator(), false).map(ice -> ice.getKey().toString()).collect(Collectors.joining(",")));
        log.tracef("Data container of NodeB has %d keys: %s", dc1.size(), (Object)StreamSupport.stream(dc1.spliterator(), false).map(ice -> ice.getKey().toString()).collect(Collectors.joining(",")));
        log.tracef("Data container of NodeC has %d keys: %s", dc2.size(), (Object)StreamSupport.stream(dc2.spliterator(), false).map(ice -> ice.getKey().toString()).collect(Collectors.joining(",")));
        if (op == Operation.CLEAR || op == Operation.REMOVE) {
            for (i = 0; i < 5; ++i) {
                AssertJUnit.assertNull((Object)dc0.get((Object)i));
                AssertJUnit.assertNull((Object)dc1.get((Object)i));
                AssertJUnit.assertNull((Object)dc2.get((Object)i));
            }
        } else if (op == Operation.PUT || op == Operation.PUT_MAP || op == Operation.REPLACE) {
            for (i = 0; i < 5; ++i) {
                String expectedValue = "after_st_" + i;
                this.assertValue(0, i, expectedValue);
                this.assertValue(1, i, expectedValue);
                this.assertValue(2, i, expectedValue);
            }
        } else {
            for (i = 0; i < 5; ++i) {
                String expectedValue = "before_st_" + i;
                this.assertValue(0, i, expectedValue);
                this.assertValue(1, i, expectedValue);
                this.assertValue(2, i, expectedValue);
            }
        }
    }

    private void assertValue(int cacheIndex, int key, String expectedValue) {
        InternalCacheEntry ice = this.cache(cacheIndex).getAdvancedCache().getDataContainer().get((Object)key);
        AssertJUnit.assertNotNull((String)("Found null on cache " + cacheIndex), (Object)ice);
        AssertJUnit.assertEquals((String)("Did not find the expected value on cache " + cacheIndex), (Object)expectedValue, (Object)ice.getValue());
        AssertJUnit.assertEquals((String)("Did not find the expected value on cache " + cacheIndex), (Object)expectedValue, (Object)this.cache(cacheIndex).get((Object)key));
    }

    private static enum Operation {
        REMOVE,
        CLEAR,
        PUT,
        PUT_MAP,
        PUT_IF_ABSENT,
        REPLACE;

    }

    static class LatchInterceptor
    extends BaseAsyncInterceptor {
        private final CountDownLatch applyStateStartedLatch;
        private final CountDownLatch applyStateProceedLatch;

        public LatchInterceptor(CountDownLatch applyStateStartedLatch, CountDownLatch applyStateProceedLatch) {
            this.applyStateStartedLatch = applyStateStartedLatch;
            this.applyStateProceedLatch = applyStateProceedLatch;
        }

        public Object visitCommand(InvocationContext ctx, VisitableCommand cmd) throws Throwable {
            if (cmd instanceof PutKeyValueCommand && ((PutKeyValueCommand)cmd).hasAnyFlag(FlagBitSets.PUT_FOR_STATE_TRANSFER)) {
                this.applyStateStartedLatch.countDown();
                if (!this.applyStateProceedLatch.await(15L, TimeUnit.SECONDS)) {
                    throw new TimeoutException();
                }
            }
            return this.invokeNext(ctx, cmd);
        }
    }
}

