/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import jakarta.transaction.TransactionManager;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.MagicKey;
import org.infinispan.statetransfer.StateProvider;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.concurrent.StateSequencer;
import org.infinispan.test.concurrent.StateSequencerUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.impl.TransactionTable;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="lock.StaleLocksWithLockOnlyTxDuringStateTransferTest", groups={"functional"})
@CleanupAfterMethod
public class StaleLocksWithLockOnlyTxDuringStateTransferTest
extends MultipleCacheManagersTest {
    public static final String CACHE_NAME = "testCache";

    @Override
    protected void createCacheManagers() throws Throwable {
        this.createCluster(TestDataSCI.INSTANCE, new ConfigurationBuilder(), 2);
        this.waitForClusterToForm();
    }

    public void testSync() throws Throwable {
        StateSequencer sequencer = new StateSequencer();
        sequencer.logicalThread("st", "st:block_get_transactions", "st:resume_get_transactions", "st:block_ch_update_on_0", "st:block_ch_update_on_1", "st:resume_ch_update_on_0", "st:resume_ch_update_on_1");
        sequencer.logicalThread("tx", "tx:before_lock", "tx:block_remote_lock", "tx:resume_remote_lock", "tx:after_commit");
        sequencer.order("st:block_get_transactions", "tx:before_lock", "tx:block_remote_lock", "st:resume_get_transactions");
        sequencer.order("st:block_ch_update_on_1", "tx:resume_remote_lock", "tx:after_commit", "st:resume_ch_update_on_0");
        ConfigurationBuilder cfg = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        cfg.clustering().cacheMode(CacheMode.DIST_SYNC).stateTransfer().awaitInitialTransfer(false).transaction().lockingMode(LockingMode.PESSIMISTIC);
        this.manager(0).defineConfiguration(CACHE_NAME, cfg.build());
        this.manager(1).defineConfiguration(CACHE_NAME, cfg.build());
        AdvancedCache cache0 = this.advancedCache(0, CACHE_NAME);
        TransactionManager tm0 = cache0.getTransactionManager();
        DistributionManager dm0 = cache0.getDistributionManager();
        int initialTopologyId = dm0.getCacheTopology().getTopologyId();
        int rebalanceTopologyId = initialTopologyId + 1;
        int finalTopologyId = rebalanceTopologyId + 3;
        StateSequencerUtil.advanceOnComponentMethod(sequencer, cache0, StateProvider.class, StateSequencerUtil.matchMethodCall("getTransactionsForSegments").build()).before("st:block_get_transactions", "st:resume_get_transactions");
        StateSequencerUtil.advanceOnGlobalComponentMethod(sequencer, this.manager(0), LocalTopologyManager.class, StateSequencerUtil.matchMethodCall("handleTopologyUpdate").withMatcher(0, CoreMatchers.equalTo((Object)CACHE_NAME)).withMatcher(1, (Matcher<?>)new CacheTopologyMatcher(finalTopologyId)).build()).before("st:block_ch_update_on_0", "st:resume_ch_update_on_0");
        StateSequencerUtil.advanceOnGlobalComponentMethod(sequencer, this.manager(1), LocalTopologyManager.class, StateSequencerUtil.matchMethodCall("handleTopologyUpdate").withMatcher(0, CoreMatchers.equalTo((Object)CACHE_NAME)).withMatcher(1, (Matcher<?>)new CacheTopologyMatcher(finalTopologyId)).build()).before("st:block_ch_update_on_1", "st:resume_ch_update_on_1");
        AdvancedCache cache1 = this.advancedCache(1, CACHE_NAME);
        StateSequencerUtil.advanceOnInboundRpc(sequencer, this.cache(1, CACHE_NAME), StateSequencerUtil.matchCommand(LockControlCommand.class).matchCount(0).withCache(CACHE_NAME).build()).before("tx:block_remote_lock", "tx:resume_remote_lock");
        sequencer.advance("tx:before_lock");
        AssertJUnit.assertEquals((int)rebalanceTopologyId, (int)dm0.getCacheTopology().getTopologyId());
        MagicKey key = new MagicKey("testkey", (Cache<?, ?>)cache0);
        tm0.begin();
        cache0.lock(new Object[]{key});
        tm0.commit();
        sequencer.advance("tx:after_commit");
        TestingUtil.waitForNoRebalance(this.caches(CACHE_NAME));
        AssertJUnit.assertEquals((int)finalTopologyId, (int)dm0.getCacheTopology().getTopologyId());
        TransactionTable tt0 = TestingUtil.extractComponent(cache0, TransactionTable.class);
        TransactionTable tt1 = TestingUtil.extractComponent(cache1, TransactionTable.class);
        StaleLocksWithLockOnlyTxDuringStateTransferTest.eventually(() -> tt0.getLocalTxCount() == 0 && tt1.getRemoteTxCount() == 0);
        sequencer.stop();
    }

    private static class CacheTopologyMatcher
    extends BaseMatcher<Object> {
        private final int topologyId;

        CacheTopologyMatcher(int topologyId) {
            this.topologyId = topologyId;
        }

        public boolean matches(Object item) {
            return item instanceof CacheTopology && ((CacheTopology)item).getTopologyId() == this.topologyId;
        }

        public void describeTo(Description description) {
            description.appendText("CacheTopology(" + this.topologyId + ")");
        }
    }
}

