/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats;

import java.util.stream.IntStream;
import org.infinispan.Cache;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.encoding.DataConversion;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.stats.ClusterCacheStats;
import org.infinispan.stats.SingleStatsTest;
import org.infinispan.stats.Stats;
import org.infinispan.test.TestingUtil;
import org.infinispan.topology.ClusterTopologyManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="stats.ClusteredStatsTest")
public class ClusteredStatsTest
extends SingleStatsTest {
    protected final int CLUSTER_SIZE = 3;
    protected final String CACHE_NAME = ClusteredStatsTest.class.getSimpleName();

    @Override
    public Object[] factory() {
        return new Object[]{new ClusteredStatsTest().withStorage(StorageType.OBJECT).withCountEviction(true), new ClusteredStatsTest().withStorage(StorageType.OBJECT).withCountEviction(true).withAccurateSize(false), new ClusteredStatsTest().withStorage(StorageType.OFF_HEAP).withCountEviction(true), new ClusteredStatsTest().withStorage(StorageType.OFF_HEAP).withCountEviction(true).withAccurateSize(false)};
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        GlobalConfigurationBuilder global = this.defaultGlobalConfigurationBuilder();
        global.metrics().accurateSize(this.accurateSize);
        ConfigurationBuilder configBuilder = ClusteredStatsTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, false);
        this.configure(configBuilder);
        Configuration config = configBuilder.build();
        this.createCluster(global, new ConfigurationBuilder(), 3);
        for (int i2 = 0; i2 < 2; ++i2) {
            ((EmbeddedCacheManager)this.cacheManagers.get(i2)).createCache(this.CACHE_NAME, config);
        }
        TestingUtil.blockUntilViewsReceived(30000, this.cacheManagers);
        TestingUtil.waitForNoRebalance((Cache[])IntStream.range(0, 2).mapToObj(i -> this.cache(i, this.CACHE_NAME)).toArray(Cache[]::new));
        this.cache = this.cache(0, this.CACHE_NAME);
        this.refreshStats();
    }

    public void testClusteredStats() {
        for (int i = 0; i < 5; ++i) {
            this.cache.put((Object)("key" + i), (Object)("value" + i));
        }
        ClusterCacheStats clusteredStats = TestingUtil.extractComponent(this.cache, ClusterCacheStats.class);
        clusteredStats.setStaleStatsThreshold(1L);
        int actualOwners = 2;
        AssertJUnit.assertEquals((long)(actualOwners * 5), (long)clusteredStats.getApproximateEntries());
        AssertJUnit.assertEquals((long)(actualOwners * 3), (long)clusteredStats.getApproximateEntriesInMemory());
        AssertJUnit.assertEquals((long)5L, (long)clusteredStats.getApproximateEntriesUnique());
        if (this.accurateSize) {
            AssertJUnit.assertEquals((int)5, (int)clusteredStats.getCurrentNumberOfEntries());
            AssertJUnit.assertEquals((int)3, (int)clusteredStats.getCurrentNumberOfEntriesInMemory());
        } else {
            AssertJUnit.assertEquals((int)-1, (int)clusteredStats.getCurrentNumberOfEntries());
            AssertJUnit.assertEquals((int)-1, (int)clusteredStats.getCurrentNumberOfEntriesInMemory());
        }
        this.eventuallyEquals((long)actualOwners * 2L, () -> ((ClusterCacheStats)clusteredStats).getPassivations());
    }

    public void testJoinerStats() {
        int i;
        for (i = 0; i < 5; ++i) {
            this.cache.put((Object)("key" + i), (Object)("value" + i));
        }
        for (i = 0; i < 2; ++i) {
            Cache cache = ((EmbeddedCacheManager)this.cacheManagers.get(i)).getCache(this.CACHE_NAME);
            ClusterTopologyManager crmTM = TestingUtil.extractComponent(cache, ClusterTopologyManager.class);
            crmTM.setRebalancingEnabled(false);
        }
        GlobalConfigurationBuilder globalConfigurationBuilder = this.defaultGlobalConfigurationBuilder();
        globalConfigurationBuilder.metrics().accurateSize(true);
        ConfigurationBuilder cb = new ConfigurationBuilder().read(this.cache.getAdvancedCache().getCacheConfiguration(), Combine.DEFAULT);
        cb.persistence().clearStores();
        Configuration configuration = ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)cb.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).segmented(false)).clustering().hash().numSegments(1).build();
        EmbeddedCacheManager ecm = this.addClusterEnabledCacheManager(new GlobalConfigurationBuilder().read(globalConfigurationBuilder.build()), new ConfigurationBuilder());
        Stats stats = ecm.createCache(this.CACHE_NAME, configuration).getAdvancedCache().getStats();
        AssertJUnit.assertEquals((long)0L, (long)stats.getApproximateEntries());
    }

    @Override
    protected long primaryKeysCount(Cache<?, ?> cache) {
        DistributionManager dm = TestingUtil.extractComponent(cache, DistributionManager.class);
        long count = 0L;
        for (int i = 0; i < 5; ++i) {
            DataConversion keyDataConversion = cache.getAdvancedCache().getKeyDataConversion();
            if (!dm.getCacheTopology().getDistribution(keyDataConversion.toStorage((Object)("key" + i))).isPrimary()) continue;
            ++count;
        }
        return count;
    }
}

