/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test;

import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.CleanupAfterTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;

public abstract class AbstractCacheTest
extends AbstractInfinispanTest {
    protected CleanupPhase cleanup = CleanupPhase.AFTER_TEST;

    protected boolean cleanupAfterTest() {
        return this.getClass().getAnnotation(CleanupAfterTest.class) != null || this.getClass().getAnnotation(CleanupAfterMethod.class) == null && this.cleanup == CleanupPhase.AFTER_TEST;
    }

    protected boolean cleanupAfterMethod() {
        return this.getClass().getAnnotation(CleanupAfterMethod.class) != null || this.getClass().getAnnotation(CleanupAfterTest.class) == null && this.cleanup == CleanupPhase.AFTER_METHOD;
    }

    public static ConfigurationBuilder getDefaultClusteredCacheConfig(CacheMode mode) {
        return AbstractCacheTest.getDefaultClusteredCacheConfig(mode, false, false);
    }

    public static ConfigurationBuilder getDefaultClusteredCacheConfig(CacheMode mode, boolean transactional) {
        return AbstractCacheTest.getDefaultClusteredCacheConfig(mode, transactional, false);
    }

    public static ConfigurationBuilder getDefaultClusteredCacheConfig(CacheMode mode, boolean transactional, boolean useCustomTxLookup) {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(transactional, useCustomTxLookup);
        builder.clustering().cacheMode(mode).transaction().cacheStopTimeout(0L);
        return builder;
    }

    protected boolean xor(boolean b1, boolean b2) {
        return !(!b1 && !b2 || b1 && b2);
    }

    protected void assertEventuallyNotLocked(Cache<?, ?> cache, Object key) {
        AbstractCacheTest.eventually(() -> String.format("Expected key '%s' to be unlocked on cache '%s'", key, cache), () -> !this.checkLocked(cache, key), 20000L, TimeUnit.MILLISECONDS);
    }

    protected void assertEventuallyLocked(Cache<?, ?> cache, Object key) {
        AbstractCacheTest.eventually(() -> String.format("Expected key '%s' to be locked on cache '%s'", key, cache), () -> this.checkLocked(cache, key), 20000L, TimeUnit.MILLISECONDS);
    }

    protected void assertLocked(Cache<?, ?> cache, Object key) {
        AssertJUnit.assertTrue((String)String.format("Expected key '%s' to be locked on cache '%s'", key, cache), (boolean)this.checkLocked(cache, key));
    }

    protected void assertNotLocked(Cache<?, ?> cache, Object key) {
        AssertJUnit.assertFalse((String)String.format("Expected key '%s' to not be locked on cache '%s'", key, cache), (boolean)this.checkLocked(cache, key));
    }

    protected boolean checkLocked(Cache<?, ?> cache, Object key) {
        return TestingUtil.extractLockManager(cache).isLocked(key);
    }

    public EmbeddedCacheManager manager(Cache<?, ?> c) {
        return c.getCacheManager();
    }

    public String getDefaultCacheName() {
        return "defaultcache";
    }

    public static enum CleanupPhase {
        AFTER_METHOD,
        AFTER_TEST;

    }
}

