/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.concurrent;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.concurrent.InvocationMatcher;
import org.infinispan.test.concurrent.StateSequencer;
import org.infinispan.test.concurrent.StateSequencerUtil;

public class GlobalComponentSequencerAction<T> {
    protected final StateSequencer stateSequencer;
    protected final EmbeddedCacheManager cacheManager;
    protected final Class<T> componentClass;
    protected final InvocationMatcher matcher;
    protected ProxyInvocationHandler ourHandler;
    protected T originalComponent;

    GlobalComponentSequencerAction(StateSequencer stateSequencer, EmbeddedCacheManager cacheManager, Class<T> componentClass, InvocationMatcher matcher) {
        this.matcher = matcher;
        this.componentClass = componentClass;
        this.stateSequencer = stateSequencer;
        this.cacheManager = cacheManager;
    }

    public GlobalComponentSequencerAction<T> before(String state1, String ... additionalStates) {
        this.replaceComponent();
        this.ourHandler.beforeStates(StateSequencerUtil.concat(state1, additionalStates));
        return this;
    }

    protected void replaceComponent() {
        if (this.ourHandler == null) {
            this.originalComponent = TestingUtil.extractGlobalComponent((CacheContainer)this.cacheManager, this.componentClass);
            if (this.originalComponent == null) {
                throw new IllegalStateException("Attempting to wrap a non-existing global component: " + String.valueOf(this.componentClass));
            }
            this.ourHandler = new ProxyInvocationHandler(this.originalComponent, this.stateSequencer, this.matcher);
            T componentProxy = this.createComponentProxy(this.componentClass, this.ourHandler);
            TestingUtil.replaceComponent((CacheContainer)this.cacheManager, this.componentClass, componentProxy, true);
        }
    }

    protected <T> T createComponentProxy(Class<T> componentClass, InvocationHandler handler) {
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{componentClass}, handler);
    }

    public GlobalComponentSequencerAction<T> after(String state1, String ... additionalStates) {
        this.replaceComponent();
        this.ourHandler.afterStates(StateSequencerUtil.concat(state1, additionalStates));
        return this;
    }

    public GlobalComponentSequencerAction<T> afterAsync(String state1, String ... additionalStates) {
        this.replaceComponent();
        this.ourHandler.afterStatesAsync(StateSequencerUtil.concat(state1, additionalStates));
        return this;
    }

    public T getOriginalComponent() {
        return this.originalComponent;
    }

    public static class ProxyInvocationHandler
    implements InvocationHandler {
        private final Object wrappedInstance;
        private final StateSequencer stateSequencer;
        private final InvocationMatcher matcher;
        private boolean async;
        private volatile List<String> statesBefore;
        private volatile List<String> statesAfter;

        public ProxyInvocationHandler(Object wrappedInstance, StateSequencer stateSequencer, InvocationMatcher matcher) {
            this.wrappedInstance = wrappedInstance;
            this.stateSequencer = stateSequencer;
            this.matcher = matcher;
        }

        public void beforeStates(List<String> states) {
            this.statesBefore = StateSequencerUtil.listCopy(states);
        }

        public void afterStates(List<String> states) {
            this.statesAfter = StateSequencerUtil.listCopy(states);
        }

        public void afterStatesAsync(List<String> states) {
            this.async = true;
            this.statesAfter = StateSequencerUtil.listCopy(states);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            boolean matches = this.matcher.accept(this.wrappedInstance, method.getName(), args);
            StateSequencerUtil.advanceMultiple(this.stateSequencer, matches, this.statesBefore);
            if (this.async) {
                CompletionStage stage = (CompletionStage)method.invoke(this.wrappedInstance, args);
                return stage.whenComplete((o, throwable) -> Exceptions.unchecked(() -> StateSequencerUtil.advanceMultiple(this.stateSequencer, matches, this.statesAfter)));
            }
            try {
                Object object = method.invoke(this.wrappedInstance, args);
                return object;
            }
            finally {
                StateSequencerUtil.advanceMultiple(this.stateSequencer, matches, this.statesAfter);
            }
        }

        public Object getWrappedInstance() {
            return this.wrappedInstance;
        }
    }
}

