/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.concurrent.StateSequencer;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="test.concurrent.StateSequencerTest")
public class StateSequencerTest
extends AbstractInfinispanTest {
    public void testSingleThread() throws Exception {
        StateSequencer stateSequencer = new StateSequencer();
        stateSequencer.logicalThread("t", "s0", "s1", "s2");
        stateSequencer.advance("s0", 0L, TimeUnit.SECONDS);
        stateSequencer.advance("s1", 0L, TimeUnit.SECONDS);
        stateSequencer.advance("s2", 0L, TimeUnit.SECONDS);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testAdvanceToInvalidState() throws Exception {
        StateSequencer stateSequencer = new StateSequencer();
        stateSequencer.advance("s1", 0L, TimeUnit.SECONDS);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvalidDependency() throws Exception {
        StateSequencer stateSequencer = new StateSequencer();
        stateSequencer.logicalThread("t", "s1", new String[0]);
        stateSequencer.order("s0", "s1", new String[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvalidDependency2() throws Exception {
        StateSequencer stateSequencer = new StateSequencer();
        stateSequencer.logicalThread("t", "s1", new String[0]);
        stateSequencer.order("s1", "s2", new String[0]);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testDependencyCycle() throws Exception {
        StateSequencer stateSequencer = new StateSequencer();
        stateSequencer.logicalThread("t", "s1", "s2", "s3", "s4");
        stateSequencer.order("s4", "s2", new String[0]);
    }

    public void testMultipleThreads() throws Exception {
        final StateSequencer stateSequencer = new StateSequencer();
        stateSequencer.logicalThread("start", "start", new String[0]);
        stateSequencer.logicalThread("t1", "t1:s1", new String[0]).order("start", "t1:s1", new String[0]);
        stateSequencer.logicalThread("t2", "t2:s2", new String[0]).order("start", "t2:s2", new String[0]).order("t1:s1", "t2:s2", new String[0]);
        stateSequencer.logicalThread("stop", "stop", new String[0]).order("t1:s1", "stop", new String[0]).order("t2:s2", "stop", new String[0]);
        Future<Object> future1 = this.fork(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                stateSequencer.advance("t1:s1", 10L, TimeUnit.SECONDS);
                return null;
            }
        });
        final AtomicBoolean t2s2Entered = new AtomicBoolean(false);
        Future<Object> future2 = this.fork(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                stateSequencer.enter("t2:s2", 10L, TimeUnit.SECONDS);
                t2s2Entered.set(true);
                stateSequencer.exit("t2:s2");
                return null;
            }
        });
        stateSequencer.enter("start", 0L, TimeUnit.SECONDS);
        Thread.sleep(500L);
        AssertJUnit.assertFalse((boolean)future1.isDone());
        AssertJUnit.assertFalse((boolean)future2.isDone());
        AssertJUnit.assertFalse((boolean)t2s2Entered.get());
        stateSequencer.exit("start");
        stateSequencer.advance("stop", 10L, TimeUnit.SECONDS);
        future1.get();
        future2.get();
    }
}

